/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.citizen.CitizenWindowUtils;
import com.minecolonies.coremod.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.network.messages.server.colony.citizen.RecallSingleCitizenMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class WindowCitizenPage
extends AbstractWindowTownHall {
    private static final Comparator<ICitizenDataView> COMPARE_BY_NAME = Comparator.comparing(ICitizen::getName);
    @NotNull
    private final List<ICitizenDataView> citizens = new ArrayList<ICitizenDataView>();

    public WindowCitizenPage(BuildingTownHall.View townHall) {
        super(townHall, "layoutcitizens.xml");
        this.updateCitizens();
        this.fillCitizensList();
        this.registerButton("name", this::fillCitizenInfo);
        this.registerButton("recallone", this::recallOneClicked);
    }

    private void updateCitizens() {
        this.citizens.clear();
        this.citizens.addAll(((ITownHallView)this.building).getColony().getCitizens().values());
        this.citizens.sort(COMPARE_BY_NAME);
    }

    private void fillCitizenInfo(Button button) {
        ScrollingList citizenList = (ScrollingList)this.findPaneOfTypeByID("citizenList", ScrollingList.class);
        for (Pane pane : citizenList.getContainer().getChildren()) {
            ((ButtonImage)pane.findPaneOfTypeByID("name", ButtonImage.class)).enable();
        }
        int row = citizenList.getListElementIndexByPane((Pane)button);
        this.findPaneByID("citizenInfoBox").show();
        button.disable();
        ICitizenDataView view = this.citizens.get(row);
        CitizenWindowUtils.createHappinessBar(view, this);
        CitizenWindowUtils.createSkillContent(view, this);
        String jobKey = view.getJob().trim().isEmpty() ? "com.minecolonies.coremod.gui.townhall.citizens.unemployed" : view.getJob();
        ((Text)this.findPaneOfTypeByID("job", Text.class)).setText(Component.m_237115_((String)jobKey).m_130940_(ChatFormatting.BOLD));
        ((Text)this.findPaneOfTypeByID("hiddenCitizenId", Text.class)).setText(Component.m_237113_((String)String.valueOf(view.getId())));
    }

    private void recallOneClicked(Button button) {
        int citizenid = Integer.parseInt(((Text)button.getParent().findPaneOfTypeByID("hiddenCitizenId", Text.class)).getTextAsString());
        Network.getNetwork().sendToServer(new RecallSingleCitizenMessage(this.building, citizenid));
    }

    private void fillCitizensList() {
        ScrollingList citizenList = (ScrollingList)this.findPaneOfTypeByID("citizenList", ScrollingList.class);
        citizenList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowCitizenPage.this.citizens.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ICitizenDataView citizen = WindowCitizenPage.this.citizens.get(index);
                ((ButtonImage)rowPane.findPaneOfTypeByID("name", ButtonImage.class)).setText(Component.m_237113_((String)citizen.getName()));
            }
        });
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.updateCitizens();
    }

    @Override
    protected String getWindowId() {
        return "citizens";
    }
}

