/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.integration.appmek.item.cell;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.IPartitionList;
import gripe._90.megacells.integration.appmek.item.MEGARadioactiveCell;
import java.util.List;
import java.util.Objects;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.common.registries.MekanismGases;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RadioactiveCellInventory
implements StorageCell {
    private static final String KEY = "key";
    private static final String COUNT = "count";
    static final int MAX_BYTES = 256;
    private static final long MAX_MB = 256L * (long)MekanismKeyType.TYPE.getAmountPerByte();
    private final ISaveProvider container;
    private final ItemStack i;
    private final MEGARadioactiveCell cellType;
    private AEKey storedChemical;
    private long chemAmount;
    private final IPartitionList partitionList;
    private boolean isPersisted = true;

    public RadioactiveCellInventory(MEGARadioactiveCell cellType, ItemStack o, ISaveProvider container) {
        this.i = o;
        this.cellType = cellType;
        this.container = container;
        this.storedChemical = this.getTag().m_128441_(KEY) ? AEKey.fromTagGeneric((CompoundTag)this.getTag().m_128469_(KEY)) : null;
        this.chemAmount = this.getTag().m_128454_(COUNT);
        IPartitionList.Builder builder = IPartitionList.builder();
        ConfigInventory config = this.getConfigInventory();
        builder.addAll((Iterable)config.keySet());
        this.partitionList = builder.build();
    }

    private CompoundTag getTag() {
        return this.i.m_41784_();
    }

    public static RadioactiveCellInventory createInventory(ItemStack o, ISaveProvider container) {
        Objects.requireNonNull(o, "Cannot create cell inventory for null itemstack");
        Item item = o.m_41720_();
        if (!(item instanceof MEGARadioactiveCell)) {
            return null;
        }
        MEGARadioactiveCell cellType = (MEGARadioactiveCell)item;
        return new RadioactiveCellInventory(cellType, o, container);
    }

    private static boolean isCellEmpty(RadioactiveCellInventory inv) {
        if (inv != null) {
            return inv.getAvailableStacks().isEmpty();
        }
        return true;
    }

    public CellState getStatus() {
        if (this.chemAmount == 0L) {
            return CellState.EMPTY;
        }
        if (this.chemAmount == MAX_MB) {
            return CellState.FULL;
        }
        if (this.chemAmount > MAX_MB / 2L) {
            return CellState.TYPES_FULL;
        }
        if (!this.storedChemical.equals(this.getFilterItem())) {
            return CellState.FULL;
        }
        return CellState.NOT_EMPTY;
    }

    protected AEKey getFilterItem() {
        List config = this.getConfigInventory().keySet().stream().toList();
        if (config.isEmpty()) {
            return null;
        }
        return (AEKey)config.get(0);
    }

    protected long getUsedBytes() {
        return this.chemAmount / (long)MekanismKeyType.TYPE.getAmountPerByte();
    }

    public double getIdleDrain() {
        return 250.0;
    }

    private ConfigInventory getConfigInventory() {
        return this.cellType.getConfigInventory(this.i);
    }

    protected boolean isBlackListed(AEKey what) {
        if (what instanceof MekanismKey) {
            MekanismKey key = (MekanismKey)what;
            return ChemicalAttributeValidator.DEFAULT.process(key.getStack()) || key.getStack().getRaw().getChemical() == MekanismGases.SPENT_NUCLEAR_WASTE.getChemical();
        }
        return true;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        AEItemKey itemKey;
        RadioactiveCellInventory meInventory;
        if (amount == 0L || !MekanismKeyType.TYPE.contains(what)) {
            return 0L;
        }
        if (!this.partitionList.isListed(what) || this.isBlackListed(what)) {
            return 0L;
        }
        if (what instanceof AEItemKey && !RadioactiveCellInventory.isCellEmpty(meInventory = RadioactiveCellInventory.createInventory((itemKey = (AEItemKey)what).toStack(), null))) {
            return 0L;
        }
        if (this.storedChemical != null && !this.storedChemical.equals(what)) {
            return 0L;
        }
        if (this.chemAmount == MAX_MB) {
            return 0L;
        }
        long remainingAmount = Math.max(0L, MAX_MB - this.chemAmount);
        if (amount > remainingAmount) {
            amount = remainingAmount;
        }
        if (mode == Actionable.MODULATE) {
            if (this.storedChemical == null) {
                this.storedChemical = what;
            }
            this.chemAmount += amount;
            this.saveChanges();
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        long extractAmount = Math.min(Integer.MAX_VALUE, amount);
        long currentCount = this.chemAmount;
        if (this.chemAmount > 0L && Objects.equals(this.storedChemical, what)) {
            if (extractAmount >= currentCount) {
                if (mode == Actionable.MODULATE) {
                    this.storedChemical = null;
                    this.chemAmount = 0L;
                    this.saveChanges();
                }
                return currentCount;
            }
            if (mode == Actionable.MODULATE) {
                this.chemAmount -= extractAmount;
                this.saveChanges();
            }
            return extractAmount;
        }
        return 0L;
    }

    protected void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.storedChemical == null || this.chemAmount < 0L) {
            this.getTag().m_128473_(KEY);
            this.getTag().m_128473_(COUNT);
        } else {
            this.getTag().m_128365_(KEY, (Tag)this.storedChemical.toTagGeneric());
            this.getTag().m_128356_(COUNT, this.chemAmount);
        }
        this.isPersisted = true;
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.storedChemical != null && this.chemAmount > 0L) {
            out.add(this.storedChemical, this.chemAmount);
        }
    }

    public Component getDescription() {
        return this.i.m_41786_();
    }
}

