/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.crafting;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.items.AEBaseItem;
import gripe._90.megacells.crafting.DecompressionPatternEncoding;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MEGADecompressionPattern
implements IPatternDetails {
    private final AEItemKey definition;
    private final AEItemKey input;
    private final IPatternDetails.IInput[] inputs;
    private final GenericStack[] outputs;

    public MEGADecompressionPattern(AEItemKey definition) {
        this.definition = definition;
        CompoundTag tag = Objects.requireNonNull(definition.getTag());
        this.input = DecompressionPatternEncoding.getCompressed(tag);
        AEItemKey decompressed = DecompressionPatternEncoding.getDecompressed(tag);
        int factor = DecompressionPatternEncoding.getFactor(tag);
        ItemStack output = decompressed.toStack(factor);
        this.inputs = new IPatternDetails.IInput[]{new Input()};
        this.outputs = new GenericStack[]{GenericStack.fromItemStack((ItemStack)output)};
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    public GenericStack[] getOutputs() {
        return this.outputs;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((MEGADecompressionPattern)obj).definition.equals((Object)this.definition);
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    private class Input
    implements IPatternDetails.IInput {
        private Input() {
        }

        public GenericStack[] getPossibleInputs() {
            return new GenericStack[]{new GenericStack((AEKey)MEGADecompressionPattern.this.input, 1L)};
        }

        public long getMultiplier() {
            return 1L;
        }

        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.getPossibleInputs()[0]);
        }

        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }

    public static class Item
    extends AEBaseItem {
        public Item(Item.Properties properties) {
            super(properties);
        }

        public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> list) {
        }
    }
}

