/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.gui.BuffStyle;
import mcjty.lib.gui.GuiStyle;
import mcjty.lib.network.SendPreferencesToClientHelper;
import net.minecraftforge.network.NetworkEvent;

public class PacketSendPreferencesToClient {
    private final BuffStyle buffStyle;
    private final int buffX;
    private final int buffY;
    private final GuiStyle style;

    public PacketSendPreferencesToClient(ByteBuf buf) {
        this.buffStyle = BuffStyle.values()[buf.readInt()];
        this.buffX = buf.readInt();
        this.buffY = buf.readInt();
        this.style = GuiStyle.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.buffStyle.ordinal());
        buf.writeInt(this.buffX);
        buf.writeInt(this.buffY);
        buf.writeInt(this.style.ordinal());
    }

    public PacketSendPreferencesToClient(BuffStyle buffStyle, int buffX, int buffY, GuiStyle style) {
        this.buffStyle = buffStyle;
        this.buffX = buffX;
        this.buffY = buffY;
        this.style = style;
    }

    public BuffStyle getBuffStyle() {
        return this.buffStyle;
    }

    public int getBuffX() {
        return this.buffX;
    }

    public int getBuffY() {
        return this.buffY;
    }

    public GuiStyle getStyle() {
        return this.style;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> SendPreferencesToClientHelper.setPreferences(this));
        ctx.setPacketHandled(true);
    }
}

