/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.boundary.BoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;

public class AlarmBoundaryMahoujinTileEntity
extends BoundaryMahoujinTileEntity {
    public boolean detected = false;
    public String alarmName = null;

    public AlarmBoundaryMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.alarmBoundary.get(), p, bs);
    }

    @Override
    public int getManaCost() {
        return MTConfig.ALARM_BARRIER_MANA_COST;
    }

    @Override
    public int getManaCycle() {
        return MTConfig.ALARM_BARRIER_MANA_CYCLE;
    }

    @Override
    public int getBarrierCycle() {
        return MTConfig.ALARM_BARRIER_CYCLE;
    }

    @Override
    public int getBarrierRadius() {
        return MTConfig.ALARM_BARRIER_RADIUS;
    }

    public String getAlarmName() {
        return this.alarmName;
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        if (this.getAlarmName() != null) {
            compound.m_128359_("alarm_name", this.alarmName);
        }
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("alarm_name")) {
            this.alarmName = compound.m_128461_("alarm_name");
        }
        super.m_142466_(compound);
    }

    @Override
    public void doBarrier(List<LivingEntity> entities) {
        Player caster = this.getCaster();
        this.detected = false;
        if (this.entitiesInBarrier != null && caster != null) {
            for (LivingEntity e : entities) {
                if (!ContractMahoujinTileEntity.isImmuneToSpell(this.f_58857_, this.getCasterUUID(), (Entity)e)) {
                    this.detected = true;
                }
                if (this.entitiesInBarrier.contains(e.m_20148_())) continue;
                this.soundAlarm(e, caster);
            }
        }
        this.setNewName();
        this.sendUpdates();
    }

    public void setNewName() {
        Entity entityIn;
        List lst = this.f_58857_.m_45976_(Entity.class, new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)(this.f_58858_.m_123342_() + 1), (double)(this.f_58858_.m_123343_() + 1)));
        if (!lst.isEmpty() && (entityIn = (Entity)lst.get(0)) instanceof ItemEntity && ((ItemEntity)entityIn).m_32055_().m_41720_() == Items.f_42656_ && ((ItemEntity)entityIn).m_32057_() != null && ((ItemEntity)entityIn).m_32057_().equals(this.getCasterUUID())) {
            String s;
            this.alarmName = s = ((ItemEntity)entityIn).m_32055_().m_41786_().getString();
        }
    }

    public void soundAlarm(LivingEntity entityIn, Player caster) {
        if (caster != null) {
            Object alarmName = this.getAlarmName();
            alarmName = alarmName == null ? "" : (String)alarmName + ": ";
            if (entityIn instanceof Player && !ContractMahoujinTileEntity.isImmuneToSpell(this.f_58857_, this.getCasterUUID(), (Entity)entityIn)) {
                caster.m_5661_((Component)Component.m_237113_((String)((String)alarmName + entityIn.m_5446_().getString() + " has entered your boundary.")).m_130940_(ChatFormatting.RED), MTConfig.ALARM_ACTION_BAR_MESSAGES);
            } else if (!ContractMahoujinTileEntity.isImmuneToSpell(this.f_58857_, this.getCasterUUID(), (Entity)entityIn)) {
                caster.m_5661_((Component)Component.m_237113_((String)((String)alarmName + entityIn.m_5446_().getString() + " has entered your boundary.")).m_130940_(ChatFormatting.RED), MTConfig.ALARM_ACTION_BAR_MESSAGES);
            }
        }
    }

    @Override
    public void doNotBarrier() {
        if (this.detected) {
            this.detected = false;
            this.sendUpdates();
        }
    }

    @Override
    public ItemStack getItemToGive() {
        return new ItemStack((ItemLike)ModItems.boundaryAlarmScroll.get());
    }
}

