/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.ConcurrentSet;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;

public class ChunkMahouPacket {
    int mode;
    ConcurrentSet<BlockPos> set;
    int x;
    int z;

    public ChunkMahouPacket() {
    }

    public ChunkMahouPacket(ConcurrentSet<BlockPos> set, int x, int z) {
        this.x = x;
        this.z = z;
        this.set = set;
        this.mode = 0;
    }

    public ChunkMahouPacket(ConcurrentSet<BlockPos> set, int x, int z, int mode) {
        this.x = x;
        this.z = z;
        this.set = set;
        this.mode = mode;
    }

    public void fromBytes(ByteBuf buf) {
        this.mode = buf.readInt();
        this.x = buf.readInt();
        this.z = buf.readInt();
        this.set = new ConcurrentSet();
        int sz = buf.readInt();
        for (int i = 0; i < sz; ++i) {
            this.set.add((Object)new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.mode);
        buf.writeInt(this.x);
        buf.writeInt(this.z);
        if (this.set != null && this.set.size() > 0) {
            buf.writeInt(this.set.size());
            for (BlockPos p : this.set) {
                if (p == null) continue;
                buf.writeInt(p.m_123341_());
                buf.writeInt(p.m_123342_());
                buf.writeInt(p.m_123343_());
            }
        } else {
            buf.writeInt(0);
        }
    }

    public static void encode(ChunkMahouPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static ChunkMahouPacket decode(FriendlyByteBuf buf) {
        ChunkMahouPacket msg = new ChunkMahouPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(ChunkMahouPacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.chunkMahouPacketHandler(message);
        context.get().setPacketHandled(true);
    }
}

