/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.tile;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.awt.Color;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.boundary.AlarmBoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.boundary.BoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.boundary.RaiseEnclosureBarrierMahoujinTileEntity;
import stepsword.mahoutsukai.tile.displacement.AscensionMahoujinTileEntity;
import stepsword.mahoutsukai.tile.displacement.EquivalentDisplacementMahoujinTileEntity;
import stepsword.mahoutsukai.tile.displacement.OrderedDisplacementMahoujinTileEntity;
import stepsword.mahoutsukai.tile.displacement.ScryingMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.AlchemicalExchangeMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.CatalystExchangeMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.ChronalExchangeMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.DurabilityExchangeMahoujinTileEntity;
import stepsword.mahoutsukai.tile.mystic.CupOfHeavenMahoujinTileEntity;
import stepsword.mahoutsukai.tile.projection.PowerConsolidationMahoujinTileEntity;
import stepsword.mahoutsukai.tile.secret.ProbabilityAlterMahoujinTileEntity;
import stepsword.mahoutsukai.util.UnorderedList;
import stepsword.mahoutsukai.util.Utils;

public class MahoujinRenderer
implements BlockEntityRenderer<MahoujinTileEntity> {
    public static ResourceLocation location = new ResourceLocation("mahoutsukai:textures/block/mahoujin_changeable.png");
    public static ResourceLocation location_fay = new ResourceLocation("mahoutsukai:textures/block/mahoujin_changeable_fae.png");
    public static ResourceLocation spellClothLocation = new ResourceLocation("mahoutsukai:textures/block/spell_cloth.png");
    private static final ResourceLocation white = new ResourceLocation("mahoutsukai:textures/block/white.png");
    HashMap<ArrayList<String>, MahoujinData> loadedMahoujin = new HashMap();
    public static int SIDE_SIZE = 256;
    public static int S_WIDTH = 256;
    public static int S_HEIGHT = 256;
    public static int PIXEL_COUNT = SIDE_SIZE * SIDE_SIZE;
    BlockEntityRenderDispatcher renderer;
    private static final ResourceLocation mahoujin = new ResourceLocation("mahoutsukai:textures/block/mahoujin_casting.png");
    private static final ResourceLocation circle = new ResourceLocation("mahoutsukai:textures/block/blood-circle.png");
    private static final ResourceLocation circle2 = new ResourceLocation("mahoutsukai:textures/block/blood-circle2.png");
    private static final ResourceLocation circle3 = new ResourceLocation("mahoutsukai:textures/block/blood-circle3.png");
    private static final ResourceLocation square2 = new ResourceLocation("mahoutsukai:textures/block/blood-square2.png");
    private static final ResourceLocation fcircle = new ResourceLocation("mahoutsukai:textures/block/fay-circle.png");
    private static final ResourceLocation fcircle2 = new ResourceLocation("mahoutsukai:textures/block/fay-circle2.png");
    private static final ResourceLocation fcircle3 = new ResourceLocation("mahoutsukai:textures/block/fay-circle3.png");
    private static final ResourceLocation fsquare2 = new ResourceLocation("mahoutsukai:textures/block/fay-square2.png");

    public MahoujinRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        this.renderer = rendererDispatcherIn.m_173581_();
    }

    public void render(MahoujinTileEntity mahoujin, float partialTicks, PoseStack matrix, MultiBufferSource MultiBufferSource2, int v1, int v2) {
        UnorderedList catalysts = mahoujin.getCatalysts();
        if (catalysts == null) {
            catalysts = new UnorderedList();
        }
        ArrayList<String> orderM = catalysts.getOrder();
        ArrayList<String> order = new ArrayList<String>();
        if (orderM != null) {
            for (String s : orderM) {
                order.add(s);
            }
        }
        if (mahoujin.isFay()) {
            order.add("fay");
        }
        boolean on = MahoujinRenderer.mahoujinOn(mahoujin);
        if (MTConfig.OLD_CIRCLE_RENDER) {
            this.oldRender(mahoujin, order, matrix, MultiBufferSource2, on, v1, v2);
        } else {
            MahoujinRenderer.circleRender(mahoujin.m_58904_().m_46467_(), on, mahoujin.hasCloth(), mahoujin.isFay(), matrix, MultiBufferSource2, order, v1, v2);
        }
        if (mahoujin instanceof AlarmBoundaryMahoujinTileEntity && mahoujin.getCasterUUID() != null && mahoujin.getCasterUUID().equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
            this.renderAlarmName(matrix, MultiBufferSource2, (AlarmBoundaryMahoujinTileEntity)mahoujin);
        }
        if (mahoujin instanceof CupOfHeavenMahoujinTileEntity && MTConfig.HEAVENS_CUP_CLIENT_CIRCLE) {
            CupOfHeavenMahoujinTileEntity cup = (CupOfHeavenMahoujinTileEntity)mahoujin;
            MahoujinRenderer.cupRender(cup, partialTicks, matrix, MultiBufferSource2, v1, v2);
        }
        if (mahoujin instanceof ScryingMahoujinTileEntity) {
            ScryingMahoujinTileEntity scry = (ScryingMahoujinTileEntity)mahoujin;
            MahoujinRenderer.scryingRender(scry, partialTicks, matrix, MultiBufferSource2, v1, v2);
        }
    }

    public static void circleRender(long time, boolean on, boolean cloth, boolean fay, PoseStack matrix, MultiBufferSource buffer, ArrayList<String> order, int v1, int v2) {
        RenderType s2;
        RenderType c3;
        RenderType c2;
        RenderType c;
        float rr = 1.0f;
        float gg = 1.0f;
        float bb = 1.0f;
        float aa = 1.0f;
        Color[] colors = MahoujinRenderer.getColors(order);
        float r1 = (float)colors[0].getRed() / 255.0f;
        float g1 = (float)colors[0].getGreen() / 255.0f;
        float b1 = (float)colors[0].getBlue() / 255.0f;
        float a1 = (float)colors[0].getAlpha() / 255.0f;
        float r2 = (float)colors[1].getRed() / 255.0f;
        float g2 = (float)colors[1].getGreen() / 255.0f;
        float b2 = (float)colors[1].getBlue() / 255.0f;
        float a2 = (float)colors[1].getAlpha() / 255.0f;
        float r3 = (float)colors[2].getRed() / 255.0f;
        float g3 = (float)colors[2].getGreen() / 255.0f;
        float b3 = (float)colors[2].getBlue() / 255.0f;
        float a3 = (float)colors[2].getAlpha() / 255.0f;
        int lightmapX = 240;
        int lightmapY = 240;
        float oscparam = 0.1f;
        long t = time;
        long t2 = t * 5L;
        float oscillate = (float)((double)(oscparam / 2.0f) + (double)(oscparam / 2.0f) * Math.sin((float)t2 / 100.0f));
        float oscillate1 = (float)((double)(oscparam / 2.0f) + (double)(oscparam / 2.0f) * Math.sin((float)t2 / 90.0f));
        float oscillate2 = (float)((double)(oscparam / 2.0f) + (double)(oscparam / 2.0f) * Math.sin((float)t2 / 80.0f));
        float oscillate3 = (float)((double)(oscparam / 2.0f) + (double)(oscparam / 2.0f) * Math.sin((float)t2 / 70.0f));
        float oscillate4 = (float)((double)(oscparam / 2.0f) + (double)(oscparam / 2.0f) * Math.sin((float)t2 / 60.0f));
        float oscillate5 = (float)((double)(oscparam / 2.0f) + (double)(oscparam / 2.0f) * Math.sin((float)t2 / 50.0f));
        if (!on) {
            t2 = 0L;
            t = 0L;
            oscillate = 0.0f;
            oscillate1 = 0.0f;
            oscillate2 = 0.0f;
            oscillate3 = 0.0f;
            oscillate4 = 0.0f;
            oscillate5 = 0.0f;
        }
        if (MTConfig.OLD_CIRCLE_ANIM) {
            oscillate = 0.0f;
            oscillate1 = 0.0f;
            oscillate2 = 0.0f;
            oscillate3 = 0.0f;
            oscillate4 = 0.0f;
            oscillate5 = 0.0f;
        }
        matrix.m_85836_();
        matrix.m_85837_(0.5, 0.0, 0.5);
        matrix.m_85836_();
        MahoujinRenderer.renderCloth(matrix, buffer, cloth, v1, v2);
        matrix.m_85849_();
        if (fay) {
            c = MahoujinRenderType.createMahoujinRenderType(fcircle, 1, false);
            c2 = MahoujinRenderType.createMahoujinRenderType(fcircle2, 1, false);
            c3 = MahoujinRenderType.createMahoujinRenderType(fcircle3, 1, false);
            s2 = MahoujinRenderType.createMahoujinRenderType(fsquare2, 1, false);
        } else {
            c = MahoujinRenderType.createMahoujinRenderType(circle, 1, false);
            c2 = MahoujinRenderType.createMahoujinRenderType(circle2, 1, false);
            c3 = MahoujinRenderType.createMahoujinRenderType(circle3, 1, false);
            s2 = MahoujinRenderType.createMahoujinRenderType(square2, 1, false);
        }
        RenderType lines = MahoujinRenderType.createMahoujinRenderType(white, 1, false);
        MahoujinRenderer.moveTex(matrix, 0.0f, 1.0E-4f + oscillate, 0.0f, 1.0f, 0.0f, false);
        MahoujinRenderer.renderTex(c, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 1.0E-4f + oscillate1, 0.0f, 0.69f, 0.0f, false);
        MahoujinRenderer.renderTex(c2, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 1.0E-4f + oscillate2, 0.0f, 0.43f, 0.0f, false);
        MahoujinRenderer.renderTex(c3, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 1.0E-4f + oscillate1, 0.0f, 0.19f, (float)(-t) * 1.0f, false);
        MahoujinRenderer.drawTriangle(lines, buffer, matrix, r1, g1, b1, a1);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 2.0E-4f + oscillate1, 0.0f, 0.19f, 40.0f - (float)t * 2.0f, false);
        MahoujinRenderer.drawTriangle(lines, buffer, matrix, r2, g2, b2, a2);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 3.0E-4f + oscillate1, 0.0f, 0.19f, 80.0f - (float)t * 3.0f, false);
        MahoujinRenderer.drawTriangle(lines, buffer, matrix, r3, g3, b3, a3);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 5.0E-5f + oscillate, 0.0f, 1.2f, 0L + t, false);
        MahoujinRenderer.renderTex(s2, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 5.0E-5f + oscillate1, 0.0f, 1.2f, 0.0f + (float)t * 2.0f, false);
        MahoujinRenderer.renderTex(s2, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 5.0E-5f + oscillate2, 0.0f, 1.2f, 30L + t, false);
        MahoujinRenderer.renderTex(s2, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 5.0E-5f + oscillate3, 0.0f, 1.2f, 30L + t * 2L, false);
        MahoujinRenderer.renderTex(s2, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 5.0E-5f + oscillate4, 0.0f, 1.2f, 60L + t, false);
        MahoujinRenderer.renderTex(s2, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        MahoujinRenderer.moveTex(matrix, 0.0f, 5.0E-5f + oscillate5, 0.0f, 1.2f, 60L + t * 2L, false);
        MahoujinRenderer.renderTex(s2, buffer, matrix, rr, gg, bb, aa, lightmapX, lightmapY);
        MahoujinRenderer.moveTex(matrix, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true);
        matrix.m_85849_();
    }

    public static void drawTriangle(RenderType type, MultiBufferSource buffer, PoseStack matrix, float rr, float gg, float bb, float aa) {
        float wide = 0.86602527f;
        float high = 0.5000002f;
        float r = -1.0f;
        float width = 0.8f;
        float wide2 = width * wide;
        float high2 = width * high;
        float r2 = r * width;
        int lightmapX = 240;
        int lightmapY = 240;
        Matrix4f positionMatrix = matrix.m_85850_().m_85861_();
        VertexConsumer b = buffer.m_6299_(type);
        b.m_85982_(positionMatrix, 0.0f, 0.06875f, r).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        b.m_85982_(positionMatrix, wide, 0.06875f, high).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        b.m_85982_(positionMatrix, wide2, 0.06875f, high2).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        b.m_85982_(positionMatrix, 0.0f, 0.06875f, r2).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        b.m_85982_(positionMatrix, 0.0f, 0.06875f, r).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        b.m_85982_(positionMatrix, -wide, 0.06875f, high).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        b.m_85982_(positionMatrix, -wide2, 0.06875f, high2).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        b.m_85982_(positionMatrix, 0.0f, 0.06875f, r2).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        b.m_85982_(positionMatrix, -wide, 0.06875f, high).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        b.m_85982_(positionMatrix, wide, 0.06875f, high).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        b.m_85982_(positionMatrix, wide2, 0.06875f, high2).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        b.m_85982_(positionMatrix, -wide2, 0.06875f, high2).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
    }

    public static void renderTex(RenderType type, MultiBufferSource buffer, PoseStack matrix, float rr, float gg, float bb, float aa, int lightmapX, int lightmapY) {
        Matrix4f positionMatrix = matrix.m_85850_().m_85861_();
        VertexConsumer b = buffer.m_6299_(type);
        b.m_85982_(positionMatrix, -0.5f, 0.0625f, 0.5f).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        b.m_85982_(positionMatrix, 0.5f, 0.0625f, 0.5f).m_85950_(rr, gg, bb, aa).m_7421_(1.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        b.m_85982_(positionMatrix, 0.5f, 0.0625f, -0.5f).m_85950_(rr, gg, bb, aa).m_7421_(1.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        b.m_85982_(positionMatrix, -0.5f, 0.0625f, -0.5f).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
    }

    public static void moveTex(PoseStack m, float x, float y, float z, float s, float degrees, boolean reverse) {
        if (reverse) {
            m.m_85849_();
        } else {
            m.m_85836_();
            m.m_85837_((double)x, (double)y, (double)z);
            RenderUtils.rotateQ(degrees, 0.0f, 1.0f, 0.0f, m);
            m.m_85841_(s, 1.0f, s);
        }
    }

    public static void scryingRender(ScryingMahoujinTileEntity scrying, float partialTicks, PoseStack stack, MultiBufferSource buffer, int v1, int v2) {
        LivingEntity e = scrying.getScryTarget();
        stack.m_85836_();
        if (e != null) {
            float offset;
            BlockPos pos = scrying.m_58899_();
            float xx = offset = 0.5f;
            float yy = offset;
            float zz = offset;
            float scale = 0.2f;
            double scaleall = 0.2;
            double invscaleall = 1.0 / scaleall;
            stack.m_85837_((double)xx, (double)yy, (double)zz);
            stack.m_85841_(scale, scale, scale);
            float f = Mth.m_14179_((float)partialTicks, (float)e.f_19859_, (float)e.f_19857_);
            Minecraft.m_91087_().m_91290_().m_114384_((Entity)e, 0.0, 0.0, 0.0, partialTicks, f, stack, buffer, v1);
            stack.m_85837_(invscaleall * -0.125, 0.0, invscaleall * -0.125);
            if (scrying.targetPos != null) {
                stack.m_85837_(-0.5 * (scrying.targetPos.f_82479_ - Math.floor(scrying.targetPos.f_82479_)), -0.5 * (scrying.targetPos.f_82480_ - Math.floor(scrying.targetPos.f_82480_)), -0.5 * (scrying.targetPos.f_82481_ - Math.floor(scrying.targetPos.f_82481_)));
            }
            if (scrying.lst != null && scrying.lst.size() > 0) {
                int index = 0;
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 2 && index < scrying.lst.size(); ++index, ++k) {
                            ScryingMahoujinTileEntity.BlockPosInfo info = scrying.lst.get(index);
                            if (info.state == null || info.state.m_60734_() == Blocks.f_50016_ || info.state.m_60734_() == Blocks.f_50627_ || info.state.m_60734_() == Blocks.f_50626_ || info.te != null) continue;
                            stack.m_85837_((double)i, (double)k, (double)j);
                            try {
                                Minecraft.m_91087_().m_91289_().m_110912_(info.state, stack, buffer, v1, v2);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            stack.m_85837_((double)(-i), (double)(-k), (double)(-j));
                        }
                    }
                }
            }
        }
        stack.m_85849_();
    }

    public static void renderCloth(PoseStack stack, MultiBufferSource buffer, boolean renderCloth, int v1, int v2) {
        RenderType type = MahoujinRenderType.createShadedRenderType(spellClothLocation, 0, false);
        float rr = 1.0f;
        float gg = 1.0f;
        float bb = 1.0f;
        float aa = 1.0f;
        VertexConsumer b = buffer.m_6299_(type);
        Matrix4f positionMatrix = stack.m_85850_().m_85861_();
        int clothlightX = v1 & 0xFFFF;
        int clothlightY = v1 >> 16 & 0xFFFF;
        if (renderCloth) {
            b.m_85982_(positionMatrix, -0.5f, 0.0625f, 0.5f).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, 0.5f, 0.0625f, 0.5f).m_85950_(rr, gg, bb, aa).m_7421_(1.0f, 1.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, 0.5f, 0.0625f, -0.5f).m_85950_(rr, gg, bb, aa).m_7421_(1.0f, 0.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, -0.5f, 0.0625f, -0.5f).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 0.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, -0.5f, 0.0f, 0.5f).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, -0.5f, 0.0f, -0.5f).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 0.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, 0.5f, 0.0f, -0.5f).m_85950_(rr, gg, bb, aa).m_7421_(1.0f, 0.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, 0.5f, 0.0f, 0.5f).m_85950_(rr, gg, bb, aa).m_7421_(1.0f, 1.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, -0.5f, 0.0625f, -0.5f).m_85950_(rr -= 0.4f, gg -= 0.4f, bb -= 0.4f, aa).m_7421_(0.0f, 1.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, 0.5f, 0.0625f, -0.5f).m_85950_(rr, gg, bb, aa).m_7421_(1.0f, 1.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, 0.5f, 0.0f, -0.5f).m_85950_(rr, gg, bb, aa).m_7421_(1.0f, 0.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, -0.5f, 0.0f, -0.5f).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 0.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, 0.5f, 0.0625f, 0.5f).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, -0.5f, 0.0625f, 0.5f).m_85950_(rr, gg, bb, aa).m_7421_(1.0f, 1.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, -0.5f, 0.0f, 0.5f).m_85950_(rr, gg, bb, aa).m_7421_(1.0f, 0.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, 0.5f, 0.0f, 0.5f).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 0.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, 0.5f, 0.0625f, -0.5f).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, 0.5f, 0.0625f, 0.5f).m_85950_(rr, gg, bb, aa).m_7421_(1.0f, 1.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, 0.5f, 0.0f, 0.5f).m_85950_(rr, gg, bb, aa).m_7421_(1.0f, 0.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, 0.5f, 0.0f, -0.5f).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 0.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, -0.5f, 0.0625f, 0.5f).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, -0.5f, 0.0625f, -0.5f).m_85950_(rr, gg, bb, aa).m_7421_(1.0f, 1.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, -0.5f, 0.0f, -0.5f).m_85950_(rr, gg, bb, aa).m_7421_(1.0f, 0.0f).m_7120_(clothlightX, clothlightY).m_5752_();
            b.m_85982_(positionMatrix, -0.5f, 0.0f, 0.5f).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 0.0f).m_7120_(clothlightX, clothlightY).m_5752_();
        }
    }

    public static void cupRender(CupOfHeavenMahoujinTileEntity cup, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int v1, int v2) {
        float size;
        matrix.m_85836_();
        float yv = cup.m_58899_().m_123342_();
        if (yv <= 0.0f) {
            yv = 1.0f;
        }
        float offsetx = 0.0f;
        float offsety = 120.0f - yv;
        float offsetz = 0.0f;
        float time = cup.m_58904_().m_46468_() % 24000L;
        if (time > 18000.0f) {
            time -= 24000.0f;
        }
        float timeColor = Math.abs(time - 6000.0f) / 12000.0f;
        float r1 = 0.19215687f;
        float g1 = 0.007843138f;
        float b1 = 0.8901961f;
        float a1 = 1.0f;
        float r2 = 0.47058824f;
        float g2 = 0.83137256f;
        float b2 = 1.0f;
        float a2 = 1.0f;
        float r = r1 + (r2 - r1) * timeColor;
        float g = g1 + (g2 - g1) * timeColor;
        float b = b1 + (b2 - b1) * timeColor;
        float a = a1 + (a2 - a1) * timeColor;
        float rotation = ClientHandler.clientTickCounter;
        float yaw = 0.0f;
        float pitch = 0.0f;
        float ring = 0.0f;
        int twopower = 0;
        rotation = rotation - 1.0f + partialTicks;
        if (yv > 80.0f) {
            size = 2.0f;
        } else {
            while (yv > 2.0f) {
                yv /= 2.0f;
                ++twopower;
            }
            size = 20.0f / (float)twopower;
        }
        if (size < 0.4f) {
            size = 0.4f;
        }
        matrix.m_85837_((double)offsetx + 0.5, (double)offsety, (double)offsetz + 0.5);
        matrix.m_85841_(size, size, size);
        RenderUtils.rotateQ(yaw, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pitch, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(rotation, 0.0f, 1.0f, 0.0f, matrix);
        int lightmapX = 240;
        int lightmapY = 240;
        RenderType type = MahoujinRenderType.createMahoujinNoFogRenderType(mahoujin, 0, true);
        VertexConsumer bb = buffer.m_6299_(type);
        Matrix4f m = matrix.m_85850_().m_85861_();
        bb.m_85982_(m, -0.5f * size, 0.0f, -0.5f * size).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_85982_(m, -0.5f * size, 0.0f, 0.5f * size).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_85982_(m, 0.5f * size, 0.0f, 0.5f * size).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_85982_(m, 0.5f * size, 0.0f, -0.5f * size).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        RenderUtils.renderRing(matrix, buffer, 0.0, ring, size / 2.0f + 0.125f, 0.125f, 128, lightmapX, lightmapY, r, g, b, a, 0);
        matrix.m_85849_();
    }

    public void renderAlarmName(PoseStack matrixStackIn, MultiBufferSource bufferIn, AlarmBoundaryMahoujinTileEntity te) {
        if (te != null && te.getAlarmName() != null) {
            String displayNameIn = te.getAlarmName();
            MutableComponent text = Component.m_237113_((String)displayNameIn);
            boolean flag = false;
            float f = 0.5f;
            int i = "deadmau5".equals(text.getString()) ? -10 : 0;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.0, (double)f, 0.0);
            matrixStackIn.m_85845_(Minecraft.m_91087_().m_91290_().m_114470_());
            matrixStackIn.m_85841_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
            float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int j = (int)(f1 * 255.0f) << 24;
            Font fontrenderer = Minecraft.m_91087_().f_91065_.m_93082_();
            int color = 0xDDDDFF;
            float f2 = -fontrenderer.m_92852_((FormattedText)text) / 2;
            fontrenderer.m_92744_(matrixStackIn, text.m_7532_(), f2, 0.0f, color);
            matrixStackIn.m_85849_();
        }
    }

    public boolean shouldRenderOffScreen(MahoujinTileEntity te) {
        return true;
    }

    public int getColor(int alpha, int colorValue) {
        int i = alpha;
        int j = colorValue >> 16 & 0xFF;
        int k = colorValue >> 8 & 0xFF;
        int l = colorValue & 0xFF;
        return i << 24 | l << 16 | k << 8 | j;
    }

    public static Color[] getColors(ArrayList<String> order) {
        Color newFirst = new Color(0, 0, 0, 0);
        Color newSecond = new Color(0, 0, 0, 0);
        Color newThird = new Color(0, 0, 0, 0);
        if (order.size() > 0) {
            if (!order.get(0).equals("fay")) {
                newFirst = ModItems.catalystMap.get((Object)order.get((int)0)).COLOR;
            }
            if (order.size() > 1) {
                if (!order.get(1).equals("fay")) {
                    newSecond = ModItems.catalystMap.get((Object)order.get((int)1)).COLOR;
                }
                if (order.size() > 2 && !order.get(2).equals("fay")) {
                    newThird = ModItems.catalystMap.get((Object)order.get((int)2)).COLOR;
                }
            }
        }
        Color[] colors = new Color[]{newFirst, newSecond, newThird};
        return colors;
    }

    public static boolean mahoujinOn(MahoujinTileEntity te) {
        boolean on = false;
        if (!te.hasCloth()) {
            if (te instanceof BoundaryMahoujinTileEntity) {
                BoundaryMahoujinTileEntity mte = (BoundaryMahoujinTileEntity)te;
                if (mte.shouldIPerformBarrier()) {
                    on = true;
                }
            } else if (te instanceof AscensionMahoujinTileEntity || te instanceof OrderedDisplacementMahoujinTileEntity || te instanceof EquivalentDisplacementMahoujinTileEntity || te instanceof AlchemicalExchangeMahoujinTileEntity || te instanceof PowerConsolidationMahoujinTileEntity || te instanceof RaiseEnclosureBarrierMahoujinTileEntity || te instanceof ScryingMahoujinTileEntity || te instanceof ChronalExchangeMahoujinTileEntity || te instanceof DurabilityExchangeMahoujinTileEntity || te instanceof CatalystExchangeMahoujinTileEntity || te instanceof ProbabilityAlterMahoujinTileEntity) {
                on = true;
            }
        }
        return on;
    }

    public void oldRender(MahoujinTileEntity mahoujin, ArrayList<String> order, PoseStack matrix, MultiBufferSource buffer, boolean on, int v1, int v2) {
        MahoujinData displayMe;
        if (this.loadedMahoujin.containsKey(order)) {
            displayMe = this.loadedMahoujin.get(order);
        } else {
            if (mahoujin.isFay()) {
                RenderUtils.bindTexture(location_fay);
            } else {
                RenderUtils.bindTexture(location);
            }
            PIXEL_COUNT = S_WIDTH * S_HEIGHT;
            displayMe = new MahoujinData(order);
            this.loadedMahoujin.put(order, displayMe);
            displayMe.changeMahoujin(order);
            MahoujinData image = new MahoujinData(order);
            try {
                InputStream io = mahoujin.isFay() ? ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(location_fay).get()).m_215507_() : ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(location).get()).m_215507_();
                image.colors = NativeImage.m_85058_((InputStream)io);
                image.changeMahoujin(order);
                displayMe = image;
                this.loadedMahoujin.put(order, displayMe);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        displayMe.render(mahoujin, matrix, buffer, on, v1, v2);
    }

    class MahoujinData {
        NativeImage colors;
        public final Color first = new Color(0, 0, 255, 255);
        public final Color second = new Color(0, 255, 0, 255);
        public final Color third = new Color(255, 255, 0, 255);
        public String texName = "mahoujin";
        public DynamicTexture dynamicTexture;
        public ResourceLocation texLocation;

        public MahoujinData(ArrayList<String> order) {
            for (int i = 0; i < order.size(); ++i) {
                this.texName = this.texName + "_" + order.get(i);
            }
            this.dynamicTexture = new DynamicTexture(S_WIDTH, S_HEIGHT, true);
            this.texLocation = Minecraft.m_91087_().m_91097_().m_118490_("mahoutsukai/" + this.texName, this.dynamicTexture);
            this.colors = this.dynamicTexture.m_117991_();
        }

        public void changeMahoujin(ArrayList<String> order) {
            Color newFirst = new Color(0, 0, 0, 0);
            Color newSecond = new Color(0, 0, 0, 0);
            Color newThird = new Color(0, 0, 0, 0);
            if (order.size() > 0) {
                if (!order.get(0).equals("fay")) {
                    newFirst = ModItems.catalystMap.get((Object)order.get((int)0)).COLOR;
                }
                if (order.size() > 1) {
                    if (!order.get(1).equals("fay")) {
                        newSecond = ModItems.catalystMap.get((Object)order.get((int)1)).COLOR;
                    }
                    if (order.size() > 2 && !order.get(2).equals("fay")) {
                        newThird = ModItems.catalystMap.get((Object)order.get((int)2)).COLOR;
                    }
                }
            }
            int firstRGB = MahoujinRenderer.this.getColor(this.first.getAlpha(), this.first.getRGB());
            int secondRGB = MahoujinRenderer.this.getColor(this.second.getAlpha(), this.second.getRGB());
            int thirdRGB = MahoujinRenderer.this.getColor(this.third.getAlpha(), this.third.getRGB());
            for (int i = 0; i < S_WIDTH; ++i) {
                for (int j = 0; j < S_HEIGHT; ++j) {
                    int pixel = this.colors.m_84985_(i, j);
                    if (pixel == firstRGB) {
                        this.colors.m_84988_(i, j, MahoujinRenderer.this.getColor(newFirst.getAlpha(), newFirst.getRGB()));
                        continue;
                    }
                    if (pixel == secondRGB) {
                        this.colors.m_84988_(i, j, MahoujinRenderer.this.getColor(newSecond.getAlpha(), newSecond.getRGB()));
                        continue;
                    }
                    if (pixel != thirdRGB) continue;
                    this.colors.m_84988_(i, j, MahoujinRenderer.this.getColor(newThird.getAlpha(), newThird.getRGB()));
                }
            }
            try {
                this.dynamicTexture = new DynamicTexture(this.colors);
            }
            catch (Exception e) {
                Utils.err(e.toString());
            }
            this.dynamicTexture.m_117985_();
            this.texLocation = Minecraft.m_91087_().m_91097_().m_118490_("mahoutsukai/" + this.texName, this.dynamicTexture);
        }

        public void render(MahoujinTileEntity te, PoseStack matrix, MultiBufferSource buffer, boolean on, int v1, int v2) {
            boolean renderCloth = te.hasCloth();
            int lightmapX = 128;
            int lightmapY = 240;
            matrix.m_85836_();
            matrix.m_85837_(0.5, 0.0, 0.5);
            float rr = 1.0f;
            float gg = 1.0f;
            float bb = 1.0f;
            float aa = 1.0f;
            Matrix4f positionMatrix = matrix.m_85850_().m_85861_();
            if (renderCloth) {
                MahoujinRenderer.renderCloth(matrix, buffer, renderCloth, v1, v2);
            }
            if (on) {
                RenderUtils.rotateQ((float)((double)ClientHandler.clientTickCounter * MTConfig.BOUNDARY_SPEED % 360.0), 0.0f, 1.0f, 0.0f, matrix);
            }
            RenderType type = MahoujinRenderType.createMahoujinRenderType(this.texLocation, 1, false);
            VertexConsumer b = buffer.m_6299_(type);
            b.m_85982_(positionMatrix, -0.5f, 0.0625f, 0.5f).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
            b.m_85982_(positionMatrix, 0.5f, 0.0625f, 0.5f).m_85950_(rr, gg, bb, aa).m_7421_(1.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
            b.m_85982_(positionMatrix, 0.5f, 0.0625f, -0.5f).m_85950_(rr, gg, bb, aa).m_7421_(1.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
            b.m_85982_(positionMatrix, -0.5f, 0.0625f, -0.5f).m_85950_(rr, gg, bb, aa).m_7421_(0.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
            matrix.m_85849_();
        }
    }
}

