/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffBeamMahoujinEntity;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderMysticStaffBeamMahoujinEntity
extends EntityRenderer<MysticStaffBeamMahoujinEntity> {
    private static final ResourceLocation mahoujin = new ResourceLocation("mahoutsukai:textures/block/mahoujin_casting.png");
    private static final ResourceLocation beam = new ResourceLocation("mahoutsukai:textures/block/white.png");
    private static final ResourceLocation beam_start = new ResourceLocation("mahoutsukai:textures/particles/white-circle.png");

    public RenderMysticStaffBeamMahoujinEntity(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(MysticStaffBeamMahoujinEntity entity) {
        return TextureAtlas.f_118259_;
    }

    public void render(MysticStaffBeamMahoujinEntity entity, float eyaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
    }

    public static void renderBeam(MysticStaffBeamMahoujinEntity entity, double x, double y, double z, PoseStack matrix, float partialTicks) {
        float m;
        float beam_len = entity.prev_beam_len + (entity.getBeamLength() - entity.prev_beam_len) * partialTicks;
        float beam_size = entity.prev_beam_size + (entity.getBeamSize() - entity.prev_beam_size) * partialTicks;
        float mini_speed = entity.getRotationSpeed();
        float mini_roll = entity.getRotationRoll();
        float sphere_size = entity.prev_sphere_size + (entity.getSphereSize() - entity.prev_sphere_size) * partialTicks;
        float size = entity.getCircleSize();
        entity.f_19859_ %= 360.0f;
        if (entity.f_19859_ < 0.0f) {
            entity.f_19859_ += 360.0f;
        }
        if (entity.f_19859_ > 360.0f) {
            entity.f_19859_ -= 360.0f;
        }
        if ((m = entity.getRotationYaw() - entity.f_19859_) > 180.0f) {
            m -= 360.0f;
        }
        if (m < -180.0f) {
            m += 360.0f;
        }
        float yaw = entity.f_19859_ + m * partialTicks;
        float pitch = entity.f_19860_ + (entity.getRotationPitch() - entity.f_19860_) * partialTicks;
        matrix.m_85836_();
        matrix.m_85837_(x, y, z);
        matrix.m_85841_(size, size, size);
        float[] colors = entity.getColor();
        float outeralpha = 0.3f;
        float beam_y_off = -0.7f;
        int lightmapX = 240;
        int lightmapY = 240;
        float smallsize = size * 0.25f;
        int smallcircles = 6;
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float a = colors[3];
        RenderMysticStaffBeamMahoujinEntity.rotate(0.0f, pitch, yaw, matrix);
        RenderMysticStaffBeamMahoujinEntity.circleRender(lightmapX, lightmapY, r, g, b, a, smallcircles + 1, matrix);
        RenderMysticStaffBeamMahoujinEntity.unrotate(0.0f, pitch, yaw, matrix);
        RenderMysticStaffBeamMahoujinEntity.rotate(entity.prev_mini_roll + partialTicks * (mini_roll - entity.prev_mini_roll), pitch, yaw, matrix);
        for (int i = 0; i < smallcircles; ++i) {
            if (entity.getDying() >= MysticStaffBeamMahoujinEntity.dyingticks + i * 2 || entity.getLife() <= i * 2) continue;
            float angle = 360.0f / (float)smallcircles;
            RenderUtils.rotateQ(angle, 0.0f, 1.0f, 0.0f, matrix);
            matrix.m_85837_((double)0.8f, 0.0, 0.0);
            matrix.m_85841_(smallsize / size, smallsize / size, smallsize / size);
            RenderMysticStaffBeamMahoujinEntity.circleRender(lightmapX, lightmapY, r, g, b, a, i, matrix);
            matrix.m_85841_(size / smallsize, size / smallsize, size / smallsize);
            matrix.m_85837_((double)-0.8f, 0.0, 0.0);
        }
        RenderMysticStaffBeamMahoujinEntity.unrotate(mini_roll - mini_speed + partialTicks * mini_speed, pitch, yaw, matrix);
        RenderMysticStaffBeamMahoujinEntity.rotate(0.0f, pitch, yaw, matrix);
        matrix.m_85837_(0.0, (double)beam_y_off, 0.0);
        CullWrappedRenderLayer beamtype1 = new CullWrappedRenderLayer(MahoujinRenderType.createBeamRenderType(beam, 0));
        CullWrappedRenderLayer beamtype2 = new CullWrappedRenderLayer(MahoujinRenderType.createBeamRenderType(beam, 1));
        CullWrappedRenderLayer spheretype1 = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(beam, 2));
        CullWrappedRenderLayer spheretype2 = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(beam, 3));
        MultiBufferSource.BufferSource buf = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, Math.max(sphere_size - 0.1f, 0.0f), 20, lightmapX, lightmapY, 1.0f, 1.0f, 1.0f, 0.99f, spheretype1);
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, Math.max(0.0f, beam_size - 0.1f), beam_len, 64, lightmapX, lightmapY, 1.0f, 1.0f, 1.0f, 0.99f, beamtype1);
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, beam_size, beam_len, 64, lightmapX, lightmapY, r, g, b, outeralpha, beamtype2);
        RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, sphere_size, 20, lightmapX, lightmapY, r, g, b, outeralpha, spheretype2);
        buf.m_109912_((RenderType)spheretype1);
        buf.m_109912_((RenderType)beamtype1);
        buf.m_109912_((RenderType)beamtype2);
        buf.m_109912_((RenderType)spheretype2);
        matrix.m_85849_();
    }

    public static void rotate(float yaw, float pitch, float roll, PoseStack matrix) {
        RenderUtils.rotateQ(roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pitch, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(yaw, 0.0f, 1.0f, 0.0f, matrix);
    }

    public static void unrotate(float yaw, float pitch, float roll, PoseStack matrix) {
        RenderUtils.rotateQ(-yaw, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(-pitch, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(-roll, 0.0f, 1.0f, 0.0f, matrix);
    }

    public static void circleRender(int lightmapX, int lightmapY, float r, float g, float b, float a, int index, PoseStack matrix) {
        CullWrappedRenderLayer type = new CullWrappedRenderLayer(MahoujinRenderType.createMahoujinRenderType(mahoujin, index, false));
        VertexConsumer buffer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_((RenderType)type);
        Matrix4f m = matrix.m_85850_().m_85861_();
        buffer.m_85982_(m, -0.5f, 0.0f, -0.5f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        buffer.m_85982_(m, -0.5f, 0.0f, 0.5f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        buffer.m_85982_(m, 0.5f, 0.0f, 0.5f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        buffer.m_85982_(m, 0.5f, 0.0f, -0.5f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        Minecraft.m_91087_().m_91269_().m_110104_().m_109912_((RenderType)type);
    }
}

