/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.ArrayList;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.capability.livingmahou.ILivingMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.mahoujin.AuthorityMahoujinEntity;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.networking.AuthorityPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.ScrollPotion;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class BorrowedAuthorityPotion
extends ScrollPotion {
    public static final UUID speedauthority = UUID.fromString("91AEAA56-376B-4498-935B-2F7F20090635");

    protected BorrowedAuthorityPotion() {
        super(ModEffects.getColorNumber(255, 255, 51));
    }

    public static void authorityPlayerTick(Player player) {
        Level world = player.f_19853_;
        if (!world.f_46443_) {
            if (player.m_21023_((MobEffect)ModEffects.BORROWED_AUTHORITY.get())) {
                if (!player.m_20163_()) {
                    AttributeModifier a = new AttributeModifier(speedauthority, "authority_speed", MTConfig.AUTHORITY_SPEED_MULTIPLIER, AttributeModifier.Operation.MULTIPLY_BASE);
                    if (!player.m_21051_(Attributes.f_22279_).m_22109_(a)) {
                        player.m_21051_(Attributes.f_22279_).m_22118_(a);
                    }
                } else {
                    player.m_21051_(Attributes.f_22279_).m_22120_(speedauthority);
                }
            } else {
                player.m_21051_(Attributes.f_22279_).m_22120_(speedauthority);
            }
        }
    }

    public static void authorityJump(LivingEntity living) {
    }

    public static void authorityLivingUpdate(LivingEntity entity) {
        ILivingMahou mahou;
        int offspeed = 5;
        if (entity != null && (mahou = Utils.getLivingMahou(entity)) != null && mahou.getAuthorityHit()) {
            Vec3 xyz = entity.m_20184_();
            if (!entity.f_19853_.f_46443_) {
                if (xyz.m_82556_() < (double)(offspeed * offspeed)) {
                    mahou.setAuthorityHit(false);
                    entity.f_19794_ = false;
                } else {
                    entity.f_19812_ = true;
                    entity.m_6853_(false);
                    entity.f_19794_ = true;
                    double factor1 = MTConfig.AUTHORITY_NORMAL_SLOW_DOWN_FACTOR;
                    xyz = xyz.m_82490_(factor1);
                    entity.m_20256_(xyz);
                    if (ServerHandler.tickCounter % 2L == 0L) {
                        AuthorityMahoujinEntity ame = new AuthorityMahoujinEntity(entity.f_19853_, entity, 1.0f, 1.0f, 0.2f, 0.95f, 4.0f);
                        ame.setRotationSpeed(0.2f);
                        entity.f_19853_.m_7967_((Entity)ame);
                    }
                    Vec3 epos = entity.m_20182_();
                    Vec3 motionV = entity.m_20184_();
                    int destroyed = 0;
                    ArrayList<BlockPos> affected = new ArrayList<BlockPos>();
                    int i = 0;
                    while ((double)i < motionV.m_82553_()) {
                        BlockPos nextTick = new BlockPos(epos.m_82549_(motionV.m_82541_().m_82490_((double)i)));
                        Stream poss = BlockPos.m_121990_((BlockPos)nextTick.m_7918_(-1, -1, -1), (BlockPos)nextTick.m_7918_(1, 1, 1));
                        poss.forEach(tmp -> {
                            BlockPos p = new BlockPos(tmp.m_123341_(), tmp.m_123342_(), tmp.m_123343_());
                            BlockState bs = entity.f_19853_.m_8055_(p);
                            if (!Utils.isBlockAir(entity.f_19853_, p) && (double)bs.m_60734_().getExplosionResistance(bs, (BlockGetter)entity.f_19853_, p, null) <= (double)MTConfig.AUTHORITY_BLOCK_RESISTANCE_LIMIT + 0.01 && entity.f_19853_.m_7702_(p) == null) {
                                affected.add(p);
                            } else if (!Utils.isBlockAir(entity.f_19853_, p)) {
                                entity.f_19794_ = false;
                            }
                        });
                        destroyed = affected.size();
                        ++i;
                    }
                    EffectUtil.tryFakeExplosion(affected, (Entity)entity, null, "borrowed_authority", MTConfig.AUTHORITY_DROPS_BLOCKS, new ArrayList<Entity>());
                    if (destroyed > 0) {
                        double factor = MTConfig.AUTHORITY_BREAK_SLOW_DOWN_FACTOR;
                        xyz.m_82490_(factor);
                    }
                    entity.m_20256_(xyz);
                }
            }
        }
    }

    public static void authorityAttackFromPlayer(Player player, Entity target) {
        double damage = MTConfig.AUTHORITY_DAMAGE_TO_OTHER;
        double damageToSelf = MTConfig.AUTHORITY_DAMAGE_TO_SELF;
        if (player.m_21023_((MobEffect)ModEffects.BORROWED_AUTHORITY.get()) && player.f_19853_ != null && !player.f_19853_.f_46443_ && target != null) {
            Vec3 pv = player.m_20182_();
            Vec3 look = pv.m_82546_(target.m_20182_());
            BorrowedAuthorityPotion.borrowedAuthorityBoop(target, 16.0f, look.f_82479_, look.f_82480_, look.f_82481_, 2.0);
            ILivingMahou targetMahou = Utils.getLivingMahou((LivingEntity)target);
            if (targetMahou != null && !EffectUtil.hasBuff((LivingEntity)target, ModEffects.BA_COOLDOWN)) {
                targetMahou.setAuthorityHit(true);
                target.m_6469_(DamageSource.m_19344_((Player)player), (float)damage);
                player.m_6469_(DamageSource.m_19344_((Player)player), (float)damageToSelf);
                AuthorityMahoujinEntity ame = new AuthorityMahoujinEntity(target.f_19853_, (LivingEntity)target, player.m_20299_(1.0f), player.m_20154_(), 1.0f, 1.0f, 0.2f, 0.95f, 4.0f);
                ame.setRotationSpeed(0.2f);
                target.f_19853_.m_7967_((Entity)ame);
                Vec3 epos = target.m_20182_();
                Vec3 motionV = target.m_20184_();
                BorrowedAuthorityPotion.makeHoleWithTarget(target.f_19853_, target, epos, motionV);
                EffectUtil.buff((LivingEntity)target, ModEffects.BA_COOLDOWN, false, 8);
            }
        }
    }

    public static void makeHoleWithTarget(Level world, Entity target, Vec3 epos, Vec3 motionV) {
        ArrayList<BlockPos> affected = new ArrayList<BlockPos>();
        int i = 0;
        while ((double)i < motionV.m_82553_()) {
            BlockPos nextTick = new BlockPos(epos.m_82549_(motionV.m_82541_().m_82490_((double)i)));
            Stream poss = BlockPos.m_121990_((BlockPos)nextTick.m_7918_(-1, -1, -1), (BlockPos)nextTick.m_7918_(1, 1, 1));
            poss.forEach(tmp -> {
                BlockPos p = new BlockPos(tmp.m_123341_(), tmp.m_123342_(), tmp.m_123343_());
                BlockState bs = world.m_8055_(p);
                if (!Utils.isBlockAir(world, p) && (double)bs.m_60734_().getExplosionResistance(bs, (BlockGetter)world, p, null) <= (double)MTConfig.AUTHORITY_BLOCK_RESISTANCE_LIMIT + 0.01 && target.f_19853_.m_7702_(p) == null) {
                    affected.add(p);
                }
            });
            ++i;
        }
        EffectUtil.tryFakeExplosion(affected, target, null, "borrowed_authority", MTConfig.AUTHORITY_DROPS_BLOCKS, new ArrayList<Entity>());
    }

    public static void borrowedAuthorityBoop(Entity entity, float strength, double x, double y, double z, double yboost) {
        entity.f_19812_ = true;
        float f = Mth.m_14116_((float)((float)(x * x + z * z + y * y)));
        Vec3 motion = entity.m_20184_();
        double motionX = motion.f_82479_;
        double motionY = motion.f_82480_;
        double motionZ = motion.f_82481_;
        motionX = 0.0;
        motionZ = 0.0;
        motionY = 0.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.f_19864_ = true;
        if (entity.m_20096_()) {
            motionY += yboost;
        }
        entity.m_20334_(motionX, motionY, motionZ);
    }

    public static void borrowedAuthorityLeftClickSpace(Player player) {
    }

    public static void borrowedAuthorityLeftClickBlock(Player player) {
    }

    public void m_6385_(LivingEntity entityLivingBaseIn, AttributeMap attributeMapIn, int amplifier) {
        BorrowedAuthorityPotion.notifyIfAuthority(entityLivingBaseIn);
        super.m_6385_(entityLivingBaseIn, attributeMapIn, amplifier);
    }

    public void m_6386_(LivingEntity entityLivingBaseIn, AttributeMap attributeMapIn, int amplifier) {
        BorrowedAuthorityPotion.notifyNotAuthority(entityLivingBaseIn);
        super.m_6386_(entityLivingBaseIn, attributeMapIn, amplifier);
    }

    public static void notifyIfAuthority(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        if (EffectUtil.hasBuff(e, ModEffects.BORROWED_AUTHORITY)) {
            BorrowedAuthorityPotion.notifyTracking(lst, true, e.f_19853_);
        }
    }

    public static void notifyNotAuthority(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        BorrowedAuthorityPotion.notifyTracking(lst, false, e.f_19853_);
    }

    public static void notifyTracking(ArrayList<LivingEntity> entities, boolean r, Level world) {
        if (world instanceof ServerLevel) {
            for (LivingEntity e : entities) {
                PacketHandler.sendTracking((Entity)e, new AuthorityPacket(e.m_19879_(), r));
            }
        }
    }
}

