/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;

public class ScryingEntityPacket {
    public double posX;
    public double posY;
    public double posZ;
    public CompoundTag entityTag;

    public ScryingEntityPacket() {
    }

    public ScryingEntityPacket(double posX, double posY, double posZ, CompoundTag tag) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.entityTag = tag;
    }

    public void fromBytes(FriendlyByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.entityTag = buf.readBoolean() ? buf.m_130261_() : null;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        if (this.entityTag == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.m_130079_(this.entityTag);
        }
    }

    public static void encode(ScryingEntityPacket msg, FriendlyByteBuf buf) {
        msg.toBytes(buf);
    }

    public static ScryingEntityPacket decode(FriendlyByteBuf buf) {
        ScryingEntityPacket msg = new ScryingEntityPacket();
        msg.fromBytes(buf);
        return msg;
    }

    public static void handle(ScryingEntityPacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.scryingHandler(message);
        context.get().setPacketHandled(true);
    }
}

