/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.world.ForgeChunkManager;

public class MobileChunkLoader {
    private Optional<Pair<Integer, Integer>> loadedChunk = Optional.empty();
    private Entity entity;

    public MobileChunkLoader(Entity entity) {
        this.entity = entity;
    }

    private Set<Pair<Integer, Integer>> getSurroundingChunks(Pair<Integer, Integer> chunk) {
        HashSet<Pair<Integer, Integer>> set = new HashSet<Pair<Integer, Integer>>();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                set.add((Pair<Integer, Integer>)new Pair((Object)((Integer)chunk.getFirst() + i), (Object)((Integer)chunk.getSecond() + j)));
            }
        }
        return set;
    }

    private void setChunkLoad(boolean add, Pair<Integer, Integer> chunk) {
        ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.entity.f_19853_), (String)"littlelogistics", (Entity)this.entity, (int)((Integer)chunk.getFirst()), (int)((Integer)chunk.getSecond()), (boolean)add, (boolean)false);
    }

    public void serverTick() {
        Pair currChunk = new Pair((Object)this.entity.m_146902_().f_45578_, (Object)this.entity.m_146902_().f_45579_);
        if (this.loadedChunk.isEmpty()) {
            this.getSurroundingChunks((Pair<Integer, Integer>)currChunk).forEach(c -> this.setChunkLoad(true, (Pair<Integer, Integer>)c));
            this.loadedChunk = Optional.of(currChunk);
        } else if (!currChunk.equals(this.loadedChunk.get())) {
            Set<Pair<Integer, Integer>> needsToBeLoaded = this.getSurroundingChunks((Pair<Integer, Integer>)currChunk);
            Set<Pair<Integer, Integer>> toUnload = this.getSurroundingChunks(this.loadedChunk.get());
            toUnload.removeAll(needsToBeLoaded);
            Set<Pair<Integer, Integer>> prevLoaded = this.getSurroundingChunks(this.loadedChunk.get());
            needsToBeLoaded.removeAll(prevLoaded);
            toUnload.forEach(c -> this.setChunkLoad(false, (Pair<Integer, Integer>)c));
            needsToBeLoaded.forEach(c -> this.setChunkLoad(true, (Pair<Integer, Integer>)c));
            this.loadedChunk = Optional.of(currChunk);
        }
    }

    public void addAdditionalSaveData(CompoundTag p_213281_1_) {
        if (this.loadedChunk.isPresent()) {
            p_213281_1_.m_128405_("xchunk", ((Integer)this.loadedChunk.get().getFirst()).intValue());
            p_213281_1_.m_128405_("zchunk", ((Integer)this.loadedChunk.get().getSecond()).intValue());
        }
    }

    public void readAdditionalSaveData(CompoundTag p_70037_1_) {
        if (p_70037_1_.m_128441_("xchunk")) {
            int x = p_70037_1_.m_128451_("xchunk");
            int z = p_70037_1_.m_128451_("zchunk");
            this.loadedChunk = Optional.of(new Pair((Object)x, (Object)z));
        }
    }

    public void remove() {
        this.loadedChunk.ifPresent(c -> this.getSurroundingChunks((Pair<Integer, Integer>)c).forEach(ch -> this.setChunkLoad(false, (Pair<Integer, Integer>)ch)));
    }
}

