/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryUtils {
    public static boolean mayMoveIntoInventory(Container target, Container source) {
        ItemStack stack;
        int i;
        if (source.m_7983_()) {
            return false;
        }
        HashMap<Item, ArrayList<ItemStack>> map = new HashMap<Item, ArrayList<ItemStack>>();
        ArrayList<Integer> airList = new ArrayList<Integer>();
        for (i = 0; i < target.m_6643_(); ++i) {
            stack = target.m_8020_(i);
            if ((stack.m_41619_() || stack.m_41720_().equals(Items.f_41852_)) && target.m_7013_(i, stack)) {
                airList.add(i);
                continue;
            }
            if (stack.m_41741_() == stack.m_41613_() || !target.m_7013_(i, stack)) continue;
            if (map.containsKey(stack.m_41720_())) {
                ((List)map.get(stack.m_41720_())).add(stack);
                continue;
            }
            map.put(stack.m_41720_(), new ArrayList<ItemStack>(Collections.singleton(stack)));
        }
        for (i = 0; i < source.m_6643_(); ++i) {
            Entity e;
            boolean validSlot;
            stack = source.m_8020_(i);
            if (!stack.m_41619_() && map.containsKey(stack.m_41720_())) {
                for (ItemStack targetStack : (List)map.get(stack.m_41720_())) {
                    if (!InventoryUtils.canMergeItems(targetStack, stack)) continue;
                    return true;
                }
                continue;
            }
            if (!(!airList.isEmpty() && target instanceof Entity ? (validSlot = (e = (Entity)target).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(itemHandler -> airList.stream().map(j -> itemHandler.isItemValid(j.intValue(), stack)).reduce(false, Boolean::logicalOr)).orElse(true).booleanValue()) : !airList.isEmpty())) continue;
            return true;
        }
        return false;
    }

    public static int findSlotFotItem(Container target, ItemStack itemStack) {
        for (int i = 0; i < target.m_6643_(); ++i) {
            ItemStack stack = target.m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_().equals(Items.f_41852_)) {
                return i;
            }
            if (!InventoryUtils.canMergeItems(stack, itemStack)) continue;
            return i;
        }
        return -1;
    }

    public static boolean canMergeItems(ItemStack p_145894_0_, ItemStack p_145894_1_) {
        if (p_145894_0_.m_41720_() != p_145894_1_.m_41720_()) {
            return false;
        }
        if (p_145894_0_.m_41773_() != p_145894_1_.m_41773_()) {
            return false;
        }
        if (p_145894_0_.m_41613_() > p_145894_0_.m_41741_()) {
            return false;
        }
        return ItemStack.m_41658_((ItemStack)p_145894_0_, (ItemStack)p_145894_1_);
    }

    @Nullable
    public static IEnergyStorage getEnergyCapabilityInSlot(int slot, ItemStackHandler handler) {
        Optional capabilityOpt;
        LazyOptional capabilityLazyOpt;
        ItemStack stack = handler.getStackInSlot(slot);
        if (!stack.m_41619_() && (capabilityLazyOpt = stack.getCapability(CapabilityEnergy.ENERGY)).isPresent() && (capabilityOpt = capabilityLazyOpt.resolve()).isPresent()) {
            return (IEnergyStorage)capabilityOpt.get();
        }
        return null;
    }
}

