/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.vessel.tug;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.capability.ReadWriteEnergyStorage;
import dev.murad.shipping.entity.accessor.EnergyHeadVehicleDataAccessor;
import dev.murad.shipping.entity.container.EnergyHeadVehicleContainer;
import dev.murad.shipping.entity.custom.vessel.tug.AbstractTugEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.util.InventoryUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class EnergyTugEntity
extends AbstractTugEntity {
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private static final int MAX_ENERGY = (Integer)ShippingConfig.Server.ENERGY_TUG_BASE_CAPACITY.get();
    private static final int MAX_TRANSFER = (Integer)ShippingConfig.Server.ENERGY_TUG_BASE_MAX_CHARGE_RATE.get();
    private static final int ENERGY_USAGE = (Integer)ShippingConfig.Server.ENERGY_TUG_BASE_ENERGY_USAGE.get();
    private final ReadWriteEnergyStorage internalBattery = new ReadWriteEnergyStorage(MAX_ENERGY, MAX_TRANSFER, Integer.MAX_VALUE);
    private final LazyOptional<IEnergyStorage> holder = LazyOptional.of(() -> this.internalBattery);

    public EnergyTugEntity(EntityType<? extends WaterAnimal> type, Level world) {
        super(type, world);
        this.internalBattery.setEnergy(0);
    }

    public EnergyTugEntity(Level worldIn, double x, double y, double z) {
        super((EntityType)ModEntityTypes.ENERGY_TUG.get(), worldIn, x, y, z);
        this.internalBattery.setEnergy(0);
    }

    @Override
    public Item getDropItem() {
        return (Item)ModItems.ENERGY_TUG.get();
    }

    @Override
    protected MenuProvider createContainerProvider() {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)"screen.littlelogistics.energy_tug");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player player) {
                return new EnergyHeadVehicleContainer(i, EnergyTugEntity.this.f_19853_, EnergyTugEntity.this.getDataAccessor(), playerInventory, player);
            }
        };
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.getCapability(CapabilityEnergy.ENERGY).isPresent();
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    protected void makeSmoke() {
    }

    @Override
    public boolean allowDockInterface() {
        return true;
    }

    @Override
    public EnergyHeadVehicleDataAccessor getDataAccessor() {
        return (EnergyHeadVehicleDataAccessor)new EnergyHeadVehicleDataAccessor.Builder().withEnergy(this.internalBattery::getEnergyStored).withCapacity(this.internalBattery::getMaxEnergyStored).withLit(() -> this.internalBattery.getEnergyStored() > 0).withId(this.m_19879_()).withVisitedSize(() -> this.nextStop).withOn(() -> this.engineOn).withCanMove(this.enrollmentHandler::mayMove).withRouteSize(() -> this.path != null ? this.path.size() : 0).build();
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        this.internalBattery.readAdditionalSaveData(compound.m_128469_("energy_storage"));
        if (compound.m_128441_("inv")) {
            ItemStackHandler old = new ItemStackHandler();
            old.deserializeNBT(compound.m_128469_("inv"));
            this.itemHandler.setStackInSlot(0, old.getStackInSlot(1));
        } else {
            this.itemHandler.deserializeNBT(compound.m_128469_("tugItemHandler"));
        }
        super.m_7378_(compound);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        CompoundTag energyNBT = new CompoundTag();
        this.internalBattery.addAdditionalSaveData(energyNBT);
        compound.m_128365_("energy_storage", (Tag)energyNBT);
        compound.m_128365_("tugItemHandler", (Tag)this.itemHandler.serializeNBT());
        super.m_7380_(compound);
    }

    @Override
    public void m_8119_() {
        IEnergyStorage capability;
        if (!this.f_19853_.f_46443_ && (capability = InventoryUtils.getEnergyCapabilityInSlot(0, this.itemHandler)) != null) {
            int toExtract = capability.extractEnergy(MAX_TRANSFER, true);
            toExtract = this.internalBattery.receiveEnergy(toExtract, false);
            capability.extractEnergy(toExtract, false);
        }
        super.m_8119_();
    }

    @Override
    protected boolean tickFuel() {
        return this.internalBattery.extractEnergy(ENERGY_USAGE, false) > 0;
    }

    public boolean m_7983_() {
        return this.itemHandler.getStackInSlot(0).m_41619_();
    }

    public ItemStack m_8020_(int p_70301_1_) {
        return this.itemHandler.getStackInSlot(p_70301_1_);
    }

    public void m_6836_(int p_70299_1_, ItemStack p_70299_2_) {
        if (!this.itemHandler.isItemValid(p_70299_1_, p_70299_2_)) {
            return;
        }
        this.itemHandler.insertItem(p_70299_1_, p_70299_2_, false);
        if (!p_70299_2_.m_41619_() && p_70299_2_.m_41613_() > this.m_6893_()) {
            p_70299_2_.m_41764_(this.m_6893_());
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.holder.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }
}

