/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.bindings.event.ServerEvents;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.server.DataExport;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.ExtraCodecs;

public class TagEventJS<T>
extends EventJS {
    private static final EventHandler.EventExceptionHandler TAG_EVENT_HANDLER = (event, container, ex) -> {
        if (ex instanceof IllegalStateException) {
            Throwable error = ex.getCause() == null ? ex : ex.getCause();
            ConsoleJS.SERVER.handleError(error, null, "IllegalStateException was thrown during tag event in script %s:%d, this is most likely due to a concurrency bug in Rhino!".formatted(container.source, container.line));
            ConsoleJS.SERVER.error("While we are working on a fix for this issue, you may manually work around it by reloading the server again (e.g. by using /reload command).");
            return null;
        }
        return ex;
    };
    public final String directory;
    private final Map<ResourceLocation, List<TagLoader.EntryWithSource>> map;
    private final Registry<T> registry;
    private Map<ResourceLocation, TagWrapper> tags;
    private int totalAdded;
    private int totalRemoved;

    public TagEventJS(String dir, Map<ResourceLocation, List<TagLoader.EntryWithSource>> m, Registry<T> r) {
        this.directory = dir;
        this.map = m;
        this.registry = r;
        this.totalAdded = 0;
        this.totalRemoved = 0;
    }

    public ResourceLocation getType() {
        return this.registry.m_123023_().m_135782_();
    }

    public void post() {
        Path dumpFile = KubeJSPaths.EXPORT.resolve("tags/" + this.getType().m_135827_() + "/" + this.getType().m_135815_() + ".txt");
        if (!Files.exists(dumpFile, new LinkOption[0])) {
            try {
                if (!Files.exists(dumpFile.getParent(), new LinkOption[0])) {
                    Files.createDirectories(dumpFile.getParent(), new FileAttribute[0]);
                }
                ArrayList<CallSite> lines = new ArrayList<CallSite>();
                this.map.forEach((tagId, entries) -> {
                    lines.add((CallSite)((Object)""));
                    lines.add((CallSite)((Object)("#" + tagId)));
                    entries.forEach(entry -> lines.add((CallSite)((Object)("- " + entry))));
                });
                lines.add(0, (CallSite)((Object)("To refresh this file, delete it and run /reload command again! Last updated: " + DateFormat.getDateTimeInstance().format(new Date()))));
                Files.write(dumpFile, lines, new OpenOption[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.tags = new HashMap<ResourceLocation, TagWrapper>();
        for (Map.Entry<ResourceLocation, List<TagLoader.EntryWithSource>> entry : this.map.entrySet()) {
            TagWrapper tagWrapper = new TagWrapper(entry.getKey(), entry.getValue());
            this.tags.put(entry.getKey(), tagWrapper);
            ConsoleJS.SERVER.debug("%s/#%s; %d".formatted(this.getType(), entry.getKey(), tagWrapper.entries.size()));
        }
        RegistryInfo types = RegistryInfo.MAP.get(this.registry.m_123023_());
        if (types != null) {
            for (BuilderBase<?> builderBase : types.objects.values()) {
                for (ResourceLocation s : builderBase.defaultTags) {
                    this.add(s, builderBase.id.toString());
                }
            }
        }
        ServerEvents.TAGS.post(this, (Object)this.registry.m_123023_(), TAG_EVENT_HANDLER);
        if (DataExport.export != null) {
            String string = "tags/" + this.getType().toString() + "/";
            for (Map.Entry<ResourceLocation, List<TagLoader.EntryWithSource>> entry : this.map.entrySet()) {
                ArrayList<String> list = new ArrayList<String>();
                for (TagLoader.EntryWithSource e : entry.getValue()) {
                    list.add(e.f_216042_().toString());
                }
                list.sort(String.CASE_INSENSITIVE_ORDER);
                JsonArray arr = new JsonArray();
                for (String e : list) {
                    arr.add(e);
                }
                DataExport.export.addJson(string + entry.getKey() + ".json", (JsonElement)arr);
            }
        }
        if (this.totalAdded > 0 || this.totalRemoved > 0 || ConsoleJS.SERVER.shouldPrintDebug()) {
            ConsoleJS.SERVER.info("[%s] Found %d tags, added %d objects, removed %d objects".formatted(this.getType(), this.tags.size(), this.totalAdded, this.totalRemoved));
        }
    }

    public TagWrapper get(ResourceLocation id) {
        TagWrapper t = this.tags.get(id);
        if (t == null) {
            t = new TagWrapper(id, new ArrayList<TagLoader.EntryWithSource>());
            this.tags.put(id, t);
            this.map.put(id, t.entries);
        }
        return t;
    }

    public TagWrapper add(ResourceLocation tag, String ... ids) {
        return this.get(tag).add(ids);
    }

    public TagWrapper remove(ResourceLocation tag, String ... ids) {
        return this.get(tag).remove(ids);
    }

    public TagWrapper removeAll(ResourceLocation tag) {
        return this.get(tag).removeAll();
    }

    public void removeAllTagsFrom(String ... ids) {
        for (String id : ids) {
            for (TagWrapper tagWrapper : this.tags.values()) {
                tagWrapper.entries.removeIf(proxy -> proxy.f_216042_().m_215924_().m_216202_().equals(id));
            }
        }
    }

    private Either<TagWrapper, List<Holder.Reference<T>>> gatherTargets(String target) {
        if (target.isEmpty()) {
            return Either.right(List.of());
        }
        String suffix = target.substring(1);
        return switch (target.charAt(0)) {
            case '#' -> Either.left((Object)this.get(new ResourceLocation(suffix)));
            case '@' -> Either.right(this.ofKeySet(id -> id.m_135782_().m_135827_().equals(suffix)));
            case '/' -> Either.right(this.ofKeySet(id -> UtilsJS.parseRegex(target).matcher(id.m_135782_().toString()).find()));
            default -> {
                ResourceKey id = ResourceKey.m_135785_((ResourceKey)this.registry.m_123023_(), (ResourceLocation)new ResourceLocation(target));
                yield (Either)UtilsJS.cast(Either.right(List.of(this.registry.m_206081_(id))));
            }
        };
    }

    private List<Holder.Reference<T>> ofKeySet(Predicate<ResourceKey<T>> predicate) {
        return this.registry.m_203611_().filter(ref -> ref.m_203425_(predicate)).toList();
    }

    public class TagWrapper {
        private final ResourceLocation id;
        private final List<TagLoader.EntryWithSource> entries;

        private TagWrapper(ResourceLocation i, List<TagLoader.EntryWithSource> t) {
            this.id = i;
            this.entries = t;
        }

        public String toString() {
            return "<%s / %s>".formatted(TagEventJS.this.getType(), this.id);
        }

        public TagWrapper add(String ... ids) {
            for (String stringId : ids) {
                TagEventJS.this.gatherTargets(stringId).ifLeft(wrapper -> {
                    this.entries.add(new TagLoader.EntryWithSource(TagEntry.m_215949_((ResourceLocation)wrapper.id), "KubeJS Custom Tags"));
                    TagEventJS.this.totalAdded += wrapper.entries.size();
                    if (ConsoleJS.SERVER.shouldPrintDebug()) {
                        ConsoleJS.SERVER.debug("+ %s // #%s".formatted(this, wrapper.id));
                    }
                }).ifRight(matches -> {
                    if (matches.isEmpty()) {
                        if (DevProperties.get().logSkippedTags) {
                            ConsoleJS.SERVER.warn("+ %s // %s [No matches found!]".formatted(this, stringId));
                        }
                        return;
                    }
                    TagEventJS.this.totalAdded += matches.size();
                    for (Holder.Reference holder : matches) {
                        ResourceLocation id = holder.m_205785_().m_135782_();
                        this.entries.add(new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)id), "KubeJS Custom Tags"));
                        if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                        if (id.toString().equals(stringId)) {
                            ConsoleJS.SERVER.debug("+ %s // %s".formatted(this, id));
                            continue;
                        }
                        ConsoleJS.SERVER.debug("+ %s // %s (via %s)".formatted(this, id, stringId));
                    }
                });
            }
            return this;
        }

        public TagWrapper remove(String ... ids) {
            for (String stringId : ids) {
                TagEventJS.this.gatherTargets(stringId).ifLeft(wrapper -> {
                    ResourceLocation entryId = wrapper.id;
                    int originalSize = this.entries.size();
                    this.entries.removeIf(proxy -> {
                        TagEntry proxyEntry = proxy.f_216042_();
                        return proxyEntry.f_215914_ && proxyEntry.f_215913_.equals((Object)entryId);
                    });
                    int removedCount = originalSize - this.entries.size();
                    if (removedCount == 0) {
                        if (DevProperties.get().logSkippedTags) {
                            ConsoleJS.SERVER.warn("- %s // #%s [No matches found!]".formatted(this, entryId));
                        }
                    } else {
                        TagEventJS.this.totalRemoved += removedCount;
                        if (ConsoleJS.SERVER.shouldPrintDebug()) {
                            ConsoleJS.SERVER.debug("- %s // %s".formatted(this, entryId));
                        }
                    }
                }).ifRight(matches -> {
                    int originalSize = this.entries.size();
                    block0: for (Holder.Reference holder : matches) {
                        ResourceLocation id = holder.m_205785_().m_135782_();
                        ListIterator<TagLoader.EntryWithSource> iterator = this.entries.listIterator();
                        while (iterator.hasNext()) {
                            TagLoader.EntryWithSource proxy = iterator.next();
                            if (!proxy.f_216042_().m_215924_().m_216202_().equals(id.toString())) continue;
                            iterator.remove();
                            if (!ConsoleJS.SERVER.shouldPrintDebug()) continue block0;
                            if (id.toString().equals(stringId)) {
                                ConsoleJS.SERVER.debug("- %s // %s".formatted(this, id));
                                continue block0;
                            }
                            ConsoleJS.SERVER.debug("- %s // %s (via %s)".formatted(this, id, stringId));
                            continue block0;
                        }
                    }
                    int removedCount = originalSize - this.entries.size();
                    if (removedCount == 0) {
                        if (DevProperties.get().logSkippedTags) {
                            ConsoleJS.SERVER.warn("- %s // %s [No matches found!]".formatted(this, stringId));
                        }
                    } else {
                        TagEventJS.this.totalRemoved += removedCount;
                    }
                });
            }
            return this;
        }

        public TagWrapper removeAll() {
            if (ConsoleJS.SERVER.shouldPrintDebug()) {
                ConsoleJS.SERVER.debug("- %s // (all)".formatted(this));
            }
            if (!this.entries.isEmpty()) {
                TagEventJS.this.totalRemoved += this.entries.size();
                this.entries.clear();
            } else if (DevProperties.get().logSkippedTags) {
                ConsoleJS.SERVER.warn("Tag " + this + " didn't contain any elements, skipped");
            }
            return this;
        }

        public Collection<ResourceLocation> getObjectIds() {
            LinkedHashSet<ResourceLocation> set = new LinkedHashSet<ResourceLocation>();
            for (TagLoader.EntryWithSource proxy : this.entries) {
                this.gatherIdsFor(set, proxy);
            }
            return set;
        }

        private void gatherIdsFor(Collection<ResourceLocation> collection, TagLoader.EntryWithSource entry) {
            ExtraCodecs.TagOrElementLocation id = entry.f_216042_().m_215924_();
            if (id.f_216196_()) {
                TagWrapper w = TagEventJS.this.tags.get(id.f_216195_());
                if (w != null && w != this) {
                    for (TagLoader.EntryWithSource proxy : w.entries) {
                        this.gatherIdsFor(collection, proxy);
                    }
                }
            } else {
                ResourceLocation entryId = id.f_216195_();
                if (TagEventJS.this.registry.m_7804_(entryId)) {
                    collection.add(entryId);
                }
            }
        }
    }
}

