/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt.network.clientbound;

import me.tepis.integratednbt.ByteMaskMaker;
import me.tepis.integratednbt.NBTExtractorOutputMode;
import me.tepis.integratednbt.NBTExtractorScreen;
import me.tepis.integratednbt.NBTPath;
import me.tepis.integratednbt.network.Message;
import me.tepis.integratednbt.network.MessageHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.NetworkEvent;

public class NBTExtractorUpdateClientMessage
implements Message {
    private static ByteMaskMaker maskMaker = new ByteMaskMaker();
    private static final byte MASK_NBT = maskMaker.nextMask();
    private static final byte MASK_ERROR_CODE = maskMaker.nextMask();
    private static final byte MASK_EXTRACTION_PATH = maskMaker.nextMask();
    private static final byte MASK_OUTPUT_MODE = maskMaker.nextMask();
    private static final byte MASK_ERROR_MESSAGE = maskMaker.nextMask();
    private static final byte MASK_AUTO_REFRESH = maskMaker.nextMask();
    private byte updated = 0;
    private ErrorCode errorCode;
    private Tag nbt;
    private NBTPath path;
    private NBTExtractorOutputMode outputMode;
    private Component errorMessage;
    private boolean autoRefresh;

    public void updateNBT(Tag nbt) {
        this.nbt = nbt;
        this.updated = (byte)(this.updated | MASK_NBT);
    }

    public void updateErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
        this.updated = (byte)(this.updated | MASK_ERROR_CODE);
    }

    public void updateExtractionPath(NBTPath path) {
        this.path = path;
        this.updated = (byte)(this.updated | MASK_EXTRACTION_PATH);
    }

    public void updateOutputMode(NBTExtractorOutputMode outputMode) {
        this.outputMode = outputMode;
        this.updated = (byte)(this.updated | MASK_OUTPUT_MODE);
    }

    public void updateErrorMessage(Component errorMessage) {
        this.errorMessage = errorMessage;
        this.updated = (byte)(this.updated | MASK_ERROR_MESSAGE);
    }

    public void updateAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
        this.updated = (byte)(this.updated | MASK_AUTO_REFRESH);
    }

    public boolean isEmpty() {
        return this.updated == 0;
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.updated = buf.readByte();
        if (this.isUpdated(MASK_NBT)) {
            CompoundTag compound = buf.m_130260_();
            assert (compound != null);
            this.nbt = compound.m_128423_("nbt");
        }
        if (this.isUpdated(MASK_ERROR_CODE)) {
            this.errorCode = ErrorCode.values()[buf.readByte()];
        }
        if (this.isUpdated(MASK_EXTRACTION_PATH)) {
            this.path = NBTPath.fromNBT((Tag)buf.m_130260_()).orElse(new NBTPath());
        }
        if (this.isUpdated(MASK_OUTPUT_MODE)) {
            this.outputMode = NBTExtractorOutputMode.values()[buf.readByte()];
        }
        if (this.isUpdated(MASK_ERROR_MESSAGE)) {
            this.errorMessage = buf.readBoolean() ? null : buf.m_130238_();
        }
        if (this.isUpdated(MASK_AUTO_REFRESH)) {
            this.autoRefresh = buf.readBoolean();
        }
    }

    private boolean isUpdated(byte mask) {
        return (this.updated & mask) > 0;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeByte((int)this.updated);
        if (this.isUpdated(MASK_NBT)) {
            CompoundTag compound = new CompoundTag();
            if (this.nbt != null) {
                compound.m_128365_("nbt", this.nbt);
            }
            buf.m_130079_(compound);
        }
        if (this.isUpdated(MASK_ERROR_CODE)) {
            buf.writeByte(this.errorCode.ordinal());
        }
        if (this.isUpdated(MASK_EXTRACTION_PATH)) {
            buf.m_130079_(this.path.toNBTCompound());
        }
        if (this.isUpdated(MASK_OUTPUT_MODE)) {
            buf.writeByte(this.outputMode.ordinal());
        }
        if (this.isUpdated(MASK_ERROR_MESSAGE)) {
            if (this.errorMessage == null) {
                buf.writeBoolean(true);
            } else {
                buf.writeBoolean(false);
                buf.m_130083_(this.errorMessage);
            }
        }
        if (this.isUpdated(MASK_AUTO_REFRESH)) {
            buf.writeBoolean(this.autoRefresh);
        }
    }

    public static enum ErrorCode {
        NO_ERROR,
        TYPE_ERROR,
        EVAL_ERROR,
        UNEXPECTED_ERROR;

    }

    public static class NBTExtractorUpdateClientMessageHandler
    extends MessageHandler<NBTExtractorUpdateClientMessage> {
        @Override
        protected Class<NBTExtractorUpdateClientMessage> getMessageClass() {
            return NBTExtractorUpdateClientMessage.class;
        }

        @Override
        public void onMessage(NBTExtractorUpdateClientMessage message, NetworkEvent.Context ctx) {
            ctx.enqueueWork(() -> {
                if (message.isUpdated(MASK_NBT)) {
                    NBTExtractorScreen.updateNBT(message.nbt);
                }
                if (message.isUpdated(MASK_ERROR_CODE)) {
                    NBTExtractorScreen.updateError(message.errorCode);
                }
                if (message.isUpdated(MASK_EXTRACTION_PATH)) {
                    NBTExtractorScreen.updateExtractionPath(message.path);
                }
                if (message.isUpdated(MASK_OUTPUT_MODE)) {
                    NBTExtractorScreen.updateOutputMode(message.outputMode);
                }
                if (message.isUpdated(MASK_ERROR_MESSAGE)) {
                    NBTExtractorScreen.updateErrorMessage(message.errorMessage);
                }
                if (message.isUpdated(MASK_AUTO_REFRESH)) {
                    NBTExtractorScreen.updateAutoRefresh(message.autoRefresh);
                }
            });
        }

        @Override
        protected NBTExtractorUpdateClientMessage createEmpty() {
            return new NBTExtractorUpdateClientMessage();
        }
    }
}

