/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.render;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WorkingAreaTESR
implements BlockEntityRenderer<IndustrialAreaWorkingTile> {
    private static RenderType AREA_TYPE = WorkingAreaTESR.createRenderType();

    public static RenderType createRenderType() {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172811_)).m_110685_(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }, () -> {
            RenderSystem.m_69461_();
            RenderSystem.m_69453_();
        })).m_110691_(true);
        return RenderType.m_173215_((String)"working_area_render", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)state);
    }

    public WorkingAreaTESR(BlockEntityRendererProvider.Context p_173540_) {
    }

    public void render(IndustrialAreaWorkingTile tileEntityIn, float p_225616_2_, PoseStack stack, MultiBufferSource renderTypeBuffer, int p_225616_5_, int p_225616_6_) {
        if (tileEntityIn == null || !tileEntityIn.isShowingArea()) {
            return;
        }
        VoxelShape shape = tileEntityIn.getWorkingArea();
        RenderSystem.m_69832_((float)Math.max(2.5f, (float)Minecraft.m_91087_().m_91268_().m_85441_() / 1920.0f * 2.5f));
        BlockPos blockpos = tileEntityIn.m_58899_();
        Color color = new Color(Math.abs(blockpos.m_123341_() % 255), Math.abs(blockpos.m_123342_() % 255), Math.abs(blockpos.m_123343_() % 255));
        VertexConsumer builder = renderTypeBuffer.m_6299_(RenderType.m_110504_());
        LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)builder, (AABB)shape.m_83215_().m_82386_((double)(-blockpos.m_123341_()), (double)(-blockpos.m_123342_()), (double)(-blockpos.m_123343_())), (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)0.5f);
        this.renderFaces(stack, renderTypeBuffer, shape.m_83215_(), -blockpos.m_123341_(), -blockpos.m_123342_(), -blockpos.m_123343_(), (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.3f);
    }

    public boolean shouldRenderOffScreen(IndustrialAreaWorkingTile te) {
        return true;
    }

    private void renderFaces(PoseStack stack, MultiBufferSource renderTypeBuffer, AABB pos, double x, double y, double z, float red, float green, float blue, float alpha) {
        float x1 = (float)(pos.f_82288_ + x);
        float x2 = (float)(pos.f_82291_ + x);
        float y1 = (float)(pos.f_82289_ + y);
        float y2 = (float)(pos.f_82292_ + y);
        float z1 = (float)(pos.f_82290_ + z);
        float z2 = (float)(pos.f_82293_ + z);
        Matrix4f matrix = stack.m_85850_().m_85861_();
        VertexConsumer buffer = renderTypeBuffer.m_6299_(AREA_TYPE);
        buffer.m_85982_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x1, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x2, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x2, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x1, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x2, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x1, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x2, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x2, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x1, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x1, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x1, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x2, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x1, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x1, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x1, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x2, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x2, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(matrix, x2, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
    }
}

