/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.component.custom;

import com.buuz135.industrial.api.conveyor.gui.PositionedGuiComponent;
import com.buuz135.industrial.gui.component.custom.ICanSendNetworkMessage;
import com.buuz135.industrial.proxy.block.filter.RegulatorFilter;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class RegulatorFilterGuiComponent
extends PositionedGuiComponent {
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("industrialforegoing", "textures/gui/conveyor.png");

    public RegulatorFilterGuiComponent(int x, int y, int xSize, int ySize) {
        super(x, y, xSize, ySize);
    }

    @Override
    public boolean handleClick(AbstractContainerScreen conveyor, int guiX, int guiY, double mouseX, double mouseY) {
        int pos = 0;
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                if (mouseX > (double)(posX + 1) && mouseX < (double)(posX + 1 + 16) && mouseY > (double)(posY + 1) && mouseY < (double)(posY + 1 + 16)) {
                    if (conveyor instanceof ICanSendNetworkMessage) {
                        ((ICanSendNetworkMessage)conveyor).sendMessage(pos, Minecraft.m_91087_().f_91074_.f_36096_.m_142621_().serializeNBT());
                    }
                    return true;
                }
                ++pos;
            }
        }
        return false;
    }

    @Override
    public boolean onScrolled(AbstractContainerScreen conveyor, int guiX, int guiY, double mouseX, double mouseY, double delta) {
        int pos = 0;
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                if (mouseX > (double)(posX + 1) && mouseX < (double)(posX + 1 + 16) && mouseY > (double)(posY + 1) && mouseY < (double)(posY + 1 + 16)) {
                    if (conveyor instanceof ICanSendNetworkMessage) {
                        CompoundTag compoundNBT = new CompoundTag();
                        int amount = (int)delta;
                        if (Screen.m_96638_()) {
                            amount *= this.getFilter().getSmallMultiplier();
                        }
                        if (Screen.m_96637_()) {
                            amount *= this.getFilter().getBigMultiplier();
                        }
                        compoundNBT.m_128405_("Amount", amount);
                        ((ICanSendNetworkMessage)conveyor).sendMessage(pos, compoundNBT);
                    }
                    return true;
                }
                ++pos;
            }
        }
        return false;
    }

    @Override
    public void drawGuiBackgroundLayer(PoseStack stack, int guiX, int guiY, double mouseX, double mouseY) {
        int pos = 0;
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                RenderSystem.m_157456_((int)0, (ResourceLocation)BG_TEXTURE);
                Minecraft.m_91087_().f_91080_.m_93228_(stack, posX, posY, 176, 0, 18, 18);
                if (!this.getFilter().getFilter()[pos].getStack().m_41619_()) {
                    Minecraft.m_91087_().m_91291_().m_115123_(this.getFilter().getFilter()[pos].getStack(), posX + 1, posY + 1);
                    if (this.isRegulator()) {
                        stack.m_85836_();
                        stack.m_85837_(0.0, 0.0, 260.0);
                        stack.m_85841_(0.5f, 0.5f, 0.5f);
                        String amount = "" + this.getFilter().getFilter()[pos].getAmount();
                        Minecraft.m_91087_().f_91062_.m_92883_(stack, ChatFormatting.WHITE + amount, ((float)(posX + 17) - (float)Minecraft.m_91087_().f_91062_.m_92895_(amount) / 2.0f) * 2.0f, (float)((posY + 13) * 2), 0xFFFFFF);
                        stack.m_85849_();
                    }
                }
                ++pos;
            }
        }
    }

    @Override
    public void drawGuiForegroundLayer(PoseStack stack, int guiX, int guiY, double mouseX, double mouseY) {
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                if (!(mouseX > (double)(posX + 1)) || !(mouseX < (double)(posX + 1 + 16)) || !(mouseY > (double)(posY + 1)) || !(mouseY < (double)(posY + 1 + 16))) continue;
                AssetUtil.drawSelectingOverlay((PoseStack)stack, (int)(posX + 1 - guiX), (int)(posY + 1 - guiY), (int)(posX + 17 - guiX), (int)(posY + 17 - guiY));
                return;
            }
        }
    }

    @Override
    public boolean isInside(double mouseX, double mouseY) {
        return mouseX > (double)this.getXPos() && mouseX < (double)(this.getXPos() + this.getXSize() * 18) && mouseY > (double)this.getYPos() && mouseY < (double)(this.getYPos() + this.getYSize() * 18);
    }

    public abstract RegulatorFilter getFilter();

    public abstract boolean isRegulator();

    @Override
    @Nullable
    public List<Component> getTooltip(int guiX, int guiY, double mouseX, double mouseY) {
        int pos = 0;
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                if (mouseX > (double)(posX + 1) && mouseX < (double)(posX + 1 + 16) && mouseY > (double)(posY + 1) && mouseY < (double)(posY + 1 + 16) && !this.getFilter().getFilter()[pos].getStack().m_41619_()) {
                    List strings = Minecraft.m_91087_().f_91080_.m_96555_(this.getFilter().getFilter()[pos].getStack());
                    if (this.isRegulator()) {
                        strings.add(Component.m_237113_((String)(ChatFormatting.DARK_GRAY + "*Use Scroll Wheel to change*")));
                    }
                    return strings;
                }
                ++pos;
            }
        }
        return null;
    }
}

