/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CrowWhitelistSyncToServer {
    int sourceId;
    List<ResourceLocation> whitelist;

    public CrowWhitelistSyncToServer(Entity entity, List<Block> whitelist) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        this.sourceId = entity.m_19879_();
        for (Block block : whitelist) {
            list.add(ForgeRegistries.BLOCKS.getKey((Object)block));
        }
        this.whitelist = list;
    }

    public CrowWhitelistSyncToServer(FriendlyByteBuf buf) {
        this.sourceId = buf.readInt();
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            list.add(buf.m_130281_());
        }
        this.whitelist = list;
    }

    public static void encode(CrowWhitelistSyncToServer object, FriendlyByteBuf buffer) {
        buffer.writeInt(object.sourceId);
        buffer.writeInt(object.whitelist.size());
        for (int i = 0; i < object.whitelist.size(); ++i) {
            buffer.m_130085_(object.whitelist.get(i));
        }
    }

    public static CrowWhitelistSyncToServer decode(FriendlyByteBuf buffer) {
        return new CrowWhitelistSyncToServer(buffer);
    }

    public static void consume(CrowWhitelistSyncToServer packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level world;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                world = Hexerei.proxy.getLevel();
            } else {
                if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                    return;
                }
                world = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_;
            }
            Entity patt2387$temp = world.m_6815_(packet.sourceId);
            if (patt2387$temp instanceof CrowEntity) {
                CrowEntity crowEntity = (CrowEntity)patt2387$temp;
                ArrayList<Block> blockList = new ArrayList<Block>();
                for (int i = 0; i < packet.whitelist.size(); ++i) {
                    blockList.add((Block)ForgeRegistries.BLOCKS.getValue(packet.whitelist.get(i)));
                }
                crowEntity.harvestWhitelist = blockList;
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

