/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.item.custom.BroomItem;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class BroomStandTile
extends RandomizableContainerBlockEntity
implements Clearable,
MenuProvider {
    public final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);

    public BroomStandTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                BroomStandTile.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.m_41720_() instanceof BroomItem;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public CompoundTag m_5995_() {
        return this.save(new CompoundTag());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, tag -> this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.deserializeNBT(pkt.m_131708_());
    }

    public void m_6596_() {
        super.m_6596_();
        this.sync();
    }

    public void sync() {
        if (this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_) {
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new TESyncPacket(this.f_58858_, this.save(new CompoundTag())));
            }
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
            }
        }
    }

    public CompoundTag save(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        return tag;
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.itemHandler.deserializeNBT(compoundTag.m_128469_("inv"));
    }

    public int interact(Player player, InteractionHand handIn) {
        if (this.itemHandler.getStackInSlot(0).m_41619_()) {
            if (!player.m_21120_(handIn).m_41619_()) {
                Random rand = new Random();
                if (this.itemHandler.getStackInSlot(0).m_41619_() && this.itemHandler.isItemValid(0, player.m_21120_(handIn))) {
                    this.itemHandler.setStackInSlot(0, player.m_21120_(handIn));
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
                    player.m_21008_(handIn, ItemStack.f_41583_);
                    this.m_6596_();
                    return 1;
                }
            }
        } else if (!this.itemHandler.getStackInSlot(0).m_41619_()) {
            if (player.m_21205_().m_41619_()) {
                player.m_21008_(InteractionHand.MAIN_HAND, this.itemHandler.getStackInSlot(0).m_41777_());
            } else {
                player.f_36093_.m_150079_(this.itemHandler.getStackInSlot(0).m_41777_());
            }
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 1.0f);
            this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
            this.m_6596_();
            return 1;
        }
        return 0;
    }

    public void requestModelDataUpdate() {
        super.requestModelDataUpdate();
    }

    @NotNull
    public ModelData getModelData() {
        return super.getModelData();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public void onLoad() {
        super.onLoad();
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }

    public CompoundTag serializeNBT() {
        return super.serializeNBT();
    }

    protected Component m_6820_() {
        return null;
    }

    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return null;
    }

    protected NonNullList<ItemStack> m_7086_() {
        NonNullList items = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            items.set(i, (Object)this.itemHandler.getStackInSlot(i));
        }
        return items;
    }

    public ItemStack m_7407_(int p_59613_, int p_59614_) {
        ItemStack itemstack;
        this.m_59640_(null);
        ItemStack itemStack = itemstack = p_59613_ >= 0 && p_59613_ < this.itemHandler.getSlots() && !this.itemHandler.getStackInSlot(p_59613_).m_41619_() && p_59614_ > 0 ? ((ItemStack)this.m_7086_().get(p_59613_)).m_41620_(p_59614_) : ItemStack.f_41583_;
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int p_59630_) {
        this.m_59640_(null);
        if (p_59630_ >= 0 && p_59630_ < this.itemHandler.getSlots()) {
            this.itemHandler.setStackInSlot(p_59630_, ItemStack.f_41583_);
            return this.itemHandler.getStackInSlot(p_59630_);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8020_(int p_59611_) {
        this.m_59640_(null);
        return this.itemHandler.getStackInSlot(p_59611_);
    }

    public void m_6836_(int p_59616_, ItemStack p_59617_) {
        this.m_59640_(null);
        this.itemHandler.setStackInSlot(p_59616_, p_59617_);
        if (p_59617_.m_41613_() > this.m_6893_()) {
            p_59617_.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        for (int i = 0; i < Math.min(itemsIn.size(), this.itemHandler.getSlots()); ++i) {
            this.itemHandler.setStackInSlot(i, (ItemStack)itemsIn.get(i));
        }
    }

    public void m_6211_() {
        super.m_6211_();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public BroomStandTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.BROOM_STAND_TILE.get(), blockPos, blockState);
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82377_(5.0, 5.0, 5.0);
    }

    public float getAngle(Vec3 pos) {
        float angle = (float)Math.toDegrees(Math.atan2(pos.m_7094_() - (double)this.f_58858_.m_123343_() - 0.5, pos.m_7096_() - (double)this.f_58858_.m_123341_() - 0.5));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public void tick() {
    }

    public int m_6643_() {
        return 1;
    }
}

