/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.network;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.mod.HexStatistics;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.casting.ControllerInfo;
import at.petrak.hexcasting.api.spell.casting.ResolvedPattern;
import at.petrak.hexcasting.api.spell.casting.ResolvedPatternType;
import at.petrak.hexcasting.api.spell.iota.PatternIota;
import at.petrak.hexcasting.api.spell.math.HexCoord;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.common.network.IMessage;
import at.petrak.hexcasting.common.network.MsgNewSpellPatternAck;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import kotlin.Triple;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public record MsgNewSpellPatternSyn(InteractionHand handUsed, HexPattern pattern, List<ResolvedPattern> resolvedPatterns) implements IMessage
{
    public static final ResourceLocation ID = HexAPI.modLoc("pat_cs");

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    public static MsgNewSpellPatternSyn deserialize(ByteBuf buffer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
        InteractionHand hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        HexPattern pattern = HexPattern.fromNBT(buf.m_130260_());
        int resolvedPatternsLen = buf.readInt();
        ArrayList<ResolvedPattern> resolvedPatterns = new ArrayList<ResolvedPattern>(resolvedPatternsLen);
        for (int i = 0; i < resolvedPatternsLen; ++i) {
            resolvedPatterns.add(ResolvedPattern.fromNBT(buf.m_130260_()));
        }
        return new MsgNewSpellPatternSyn(hand, pattern, resolvedPatterns);
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.handUsed);
        buf.m_130079_(this.pattern.serializeToNBT());
        buf.writeInt(this.resolvedPatterns.size());
        for (ResolvedPattern pat : this.resolvedPatterns) {
            buf.m_130079_(pat.serializeToNBT());
        }
    }

    public void handle(MinecraftServer server, ServerPlayer sender) {
        server.execute(() -> {
            ItemStack held = sender.m_21120_(this.handUsed);
            if (held.m_204117_(HexTags.Items.STAVES)) {
                ControllerInfo clientInfo;
                boolean autoFail = false;
                if (!this.resolvedPatterns.isEmpty()) {
                    ArrayList<HexCoord> allPoints = new ArrayList<HexCoord>();
                    for (int i = 0; i < this.resolvedPatterns.size() - 1; ++i) {
                        ResolvedPattern pat = this.resolvedPatterns.get(i);
                        allPoints.addAll(pat.getPattern().positions(pat.getOrigin()));
                    }
                    ResolvedPattern currentResolvedPattern = this.resolvedPatterns.get(this.resolvedPatterns.size() - 1);
                    List<HexCoord> currentSpellPoints = currentResolvedPattern.getPattern().positions(currentResolvedPattern.getOrigin());
                    if (currentSpellPoints.stream().anyMatch(allPoints::contains)) {
                        autoFail = true;
                    }
                }
                sender.m_36220_(HexStatistics.PATTERNS_DRAWN);
                CastingHarness harness = IXplatAbstractions.INSTANCE.getHarness(sender, this.handUsed);
                if (autoFail) {
                    Triple<List<CompoundTag>, List<CompoundTag>, CompoundTag> descs = harness.generateDescs();
                    clientInfo = new ControllerInfo(harness.getStack().isEmpty(), ResolvedPatternType.INVALID, (List)descs.getFirst(), (List)descs.getSecond(), (CompoundTag)descs.getThird(), harness.getParenCount());
                } else {
                    clientInfo = harness.executeIota(new PatternIota(this.pattern), sender.m_9236_());
                }
                if (clientInfo.isStackClear()) {
                    IXplatAbstractions.INSTANCE.setHarness(sender, null);
                    IXplatAbstractions.INSTANCE.setPatterns(sender, List.of());
                } else {
                    IXplatAbstractions.INSTANCE.setHarness(sender, harness);
                    if (!this.resolvedPatterns.isEmpty()) {
                        this.resolvedPatterns.get(this.resolvedPatterns.size() - 1).setType(clientInfo.getResolutionType());
                    }
                    IXplatAbstractions.INSTANCE.setPatterns(sender, this.resolvedPatterns);
                }
                IXplatAbstractions.INSTANCE.sendPacketToPlayer(sender, new MsgNewSpellPatternAck(clientInfo, this.resolvedPatterns.size() - 1));
            }
        });
    }
}

