/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.operators.spells.great;

import at.petrak.hexcasting.api.player.FlightAbility;
import at.petrak.hexcasting.api.spell.OperationResult;
import at.petrak.hexcasting.api.spell.OperatorUtils;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.api.spell.RenderedSpell;
import at.petrak.hexcasting.api.spell.SpellAction;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.eval.SpellContinuation;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\u001b"}, d2={"Lat/petrak/hexcasting/common/casting/operators/spells/great/OpFlight;", "Lat/petrak/hexcasting/api/spell/SpellAction;", "()V", "argc", "", "getArgc", "()I", "isGreat", "", "()Z", "execute", "Lkotlin/Triple;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "", "Lat/petrak/hexcasting/api/spell/ParticleSpray;", "args", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "tickAllPlayers", "", "world", "Lnet/minecraft/server/level/ServerLevel;", "tickDownFlight", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "Spell", "hexcasting-forge-1.19.2"})
public final class OpFlight
implements SpellAction {
    @NotNull
    public static final OpFlight INSTANCE = new OpFlight();
    private static final int argc = 3;
    private static final boolean isGreat = true;

    private OpFlight() {
    }

    @Override
    public int getArgc() {
        return argc;
    }

    @Override
    public boolean isGreat() {
        return isGreat;
    }

    @Override
    @NotNull
    public Triple<RenderedSpell, Integer, List<ParticleSpray>> execute(@NotNull List<? extends Iota> args, @NotNull CastingContext ctx) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ServerPlayer target = OperatorUtils.getPlayer(args, 0, this.getArgc());
        double timeRaw = OperatorUtils.getPositiveDouble(args, 1, this.getArgc());
        double radiusRaw = OperatorUtils.getPositiveDouble(args, 2, this.getArgc());
        ctx.assertEntityInRange((Entity)target);
        int time = MathKt.roundToInt((double)(timeRaw * 20.0));
        Spell spell = new Spell(target, time, radiusRaw, ctx.getPosition());
        Integer n = MathKt.roundToInt((double)(2500.0 * (timeRaw * radiusRaw + 1.0)));
        Vec3 vec3 = target.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"target.position()");
        return new Triple((Object)spell, (Object)n, (Object)CollectionsKt.listOf((Object)new ParticleSpray(vec3, new Vec3(0.0, 2.0, 0.0), 0.0, 0.1, 0, 16, null)));
    }

    public final void tickDownFlight(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        FlightAbility flight = IXplatAbstractions.INSTANCE.getFlight((ServerPlayer)entity);
        if (flight.allowed()) {
            int flightTime = flight.timeLeft() - 1;
            if (flightTime < 0 || flight.origin().m_82557_(entity.m_20182_()) > flight.radius() * flight.radius() || !Intrinsics.areEqual(flight.dimension(), (Object)entity.f_19853_.m_46472_())) {
                if (!((ServerPlayer)entity).m_20096_()) {
                    entity.f_19789_ = 1000000.0f;
                }
                IXplatAbstractions.INSTANCE.setFlight((ServerPlayer)entity, FlightAbility.deny());
                if (!((ServerPlayer)entity).m_7500_() && !((ServerPlayer)entity).m_5833_()) {
                    Abilities abilities = ((ServerPlayer)entity).m_150110_();
                    abilities.f_35935_ = false;
                    abilities.f_35936_ = false;
                    ((ServerPlayer)entity).m_6885_();
                }
            } else {
                if (!((ServerPlayer)entity).m_150110_().f_35936_) {
                    ((ServerPlayer)entity).m_150110_().f_35936_ = true;
                    ((ServerPlayer)entity).m_6885_();
                }
                IXplatAbstractions.INSTANCE.setFlight((ServerPlayer)entity, new FlightAbility(true, flightTime, flight.dimension(), flight.origin(), flight.radius()));
            }
        }
    }

    public final void tickAllPlayers(@NotNull ServerLevel world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        for (ServerPlayer player : world.m_6907_()) {
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
            this.tickDownFlight((LivingEntity)player);
        }
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingContext ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingContext ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull SpellContinuation continuation, @NotNull List<Iota> stack, @Nullable Iota ravenmind, @NotNull CastingContext ctx) {
        return SpellAction.DefaultImpls.operate(this, continuation, stack, ravenmind, ctx);
    }

    @Override
    public boolean getAlwaysProcessGreatSpell() {
        return SpellAction.DefaultImpls.getAlwaysProcessGreatSpell(this);
    }

    @Override
    public boolean getCausesBlindDiversion() {
        return SpellAction.DefaultImpls.getCausesBlindDiversion(this);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return SpellAction.DefaultImpls.getDisplayName(this);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J1\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020\u0005H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lat/petrak/hexcasting/common/casting/operators/spells/great/OpFlight$Spell;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "target", "Lnet/minecraft/server/level/ServerPlayer;", "time", "", "radius", "", "origin", "Lnet/minecraft/world/phys/Vec3;", "(Lnet/minecraft/server/level/ServerPlayer;IDLnet/minecraft/world/phys/Vec3;)V", "getOrigin", "()Lnet/minecraft/world/phys/Vec3;", "getRadius", "()D", "getTarget", "()Lnet/minecraft/server/level/ServerPlayer;", "getTime", "()I", "cast", "", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "", "hexcasting-forge-1.19.2"})
    public static final class Spell
    implements RenderedSpell {
        @NotNull
        private final ServerPlayer target;
        private final int time;
        private final double radius;
        @NotNull
        private final Vec3 origin;

        public Spell(@NotNull ServerPlayer target, int time, double radius, @NotNull Vec3 origin) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            this.target = target;
            this.time = time;
            this.radius = radius;
            this.origin = origin;
        }

        @NotNull
        public final ServerPlayer getTarget() {
            return this.target;
        }

        public final int getTime() {
            return this.time;
        }

        public final double getRadius() {
            return this.radius;
        }

        @NotNull
        public final Vec3 getOrigin() {
            return this.origin;
        }

        @Override
        public void cast(@NotNull CastingContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (this.target.m_150110_().f_35936_) {
                return;
            }
            IXplatAbstractions.INSTANCE.setFlight(this.target, new FlightAbility(true, this.time, (ResourceKey<Level>)this.target.f_19853_.m_46472_(), this.origin, this.radius));
            this.target.m_150110_().f_35936_ = true;
            this.target.m_150110_().f_35935_ = true;
            this.target.m_6885_();
            this.target.m_5997_(0.0, 1.0, 0.0);
            this.target.f_19864_ = true;
        }

        @NotNull
        public final ServerPlayer component1() {
            return this.target;
        }

        public final int component2() {
            return this.time;
        }

        public final double component3() {
            return this.radius;
        }

        @NotNull
        public final Vec3 component4() {
            return this.origin;
        }

        @NotNull
        public final Spell copy(@NotNull ServerPlayer target, int time, double radius, @NotNull Vec3 origin) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            return new Spell(target, time, radius, origin);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, ServerPlayer serverPlayer, int n, double d, Vec3 vec3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                serverPlayer = spell.target;
            }
            if ((n2 & 2) != 0) {
                n = spell.time;
            }
            if ((n2 & 4) != 0) {
                d = spell.radius;
            }
            if ((n2 & 8) != 0) {
                vec3 = spell.origin;
            }
            return spell.copy(serverPlayer, n, d, vec3);
        }

        @NotNull
        public String toString() {
            return "Spell(target=" + this.target + ", time=" + this.time + ", radius=" + this.radius + ", origin=" + this.origin + ")";
        }

        public int hashCode() {
            int result = this.target.hashCode();
            result = result * 31 + Integer.hashCode(this.time);
            result = result * 31 + Double.hashCode(this.radius);
            result = result * 31 + this.origin.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.target, (Object)spell.target)) {
                return false;
            }
            if (this.time != spell.time) {
                return false;
            }
            if (Double.compare(this.radius, spell.radius) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.origin, (Object)spell.origin);
        }
    }
}

