/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.spell.casting.eval;

import at.petrak.hexcasting.api.spell.SpellList;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.casting.ResolvedPatternType;
import at.petrak.hexcasting.api.spell.casting.eval.ContinuationFrame;
import at.petrak.hexcasting.api.spell.casting.eval.SpellContinuation;
import at.petrak.hexcasting.api.spell.casting.sideeffects.EvalSound;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.api.utils.NBTBuilder;
import at.petrak.hexcasting.api.utils.NbtCompoundBuilder;
import at.petrak.hexcasting.common.lib.hex.HexEvalSounds;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\b\u0010\u001f\u001a\u00020 H\u0016J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006#"}, d2={"Lat/petrak/hexcasting/api/spell/casting/eval/FrameEvaluate;", "Lat/petrak/hexcasting/api/spell/casting/eval/ContinuationFrame;", "list", "Lat/petrak/hexcasting/api/spell/SpellList;", "isMetacasting", "", "(Lat/petrak/hexcasting/api/spell/SpellList;Z)V", "()Z", "getList", "()Lat/petrak/hexcasting/api/spell/SpellList;", "breakDownwards", "Lkotlin/Pair;", "", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "stack", "component1", "component2", "copy", "equals", "other", "", "evaluate", "Lat/petrak/hexcasting/api/spell/casting/CastingHarness$CastResult;", "continuation", "Lat/petrak/hexcasting/api/spell/casting/eval/SpellContinuation;", "level", "Lnet/minecraft/server/level/ServerLevel;", "harness", "Lat/petrak/hexcasting/api/spell/casting/CastingHarness;", "hashCode", "", "serializeToNBT", "Lnet/minecraft/nbt/CompoundTag;", "toString", "", "hexcasting-forge-1.19.2"})
public final class FrameEvaluate
implements ContinuationFrame {
    @NotNull
    private final SpellList list;
    private final boolean isMetacasting;

    public FrameEvaluate(@NotNull SpellList list, boolean isMetacasting) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        this.list = list;
        this.isMetacasting = isMetacasting;
    }

    @NotNull
    public final SpellList getList() {
        return this.list;
    }

    public final boolean isMetacasting() {
        return this.isMetacasting;
    }

    @Override
    @NotNull
    public Pair<Boolean, List<Iota>> breakDownwards(@NotNull List<? extends Iota> stack) {
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        return TuplesKt.to((Object)false, stack);
    }

    @Override
    @NotNull
    public CastingHarness.CastResult evaluate(@NotNull SpellContinuation continuation, @NotNull ServerLevel level, @NotNull CastingHarness harness) {
        CastingHarness.CastResult castResult;
        Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)harness, (String)"harness");
        if (this.list.getNonEmpty()) {
            SpellContinuation newCont = this.list.getCdr().getNonEmpty() ? continuation.pushFrame(new FrameEvaluate(this.list.getCdr(), this.isMetacasting)) : continuation;
            CastingHarness.CastResult update = harness.getUpdate(this.list.getCar(), level, newCont);
            if (this.isMetacasting && !Intrinsics.areEqual((Object)update.getSound(), (Object)HexEvalSounds.MISHAP)) {
                EvalSound evalSound = HexEvalSounds.HERMES;
                Intrinsics.checkNotNullExpressionValue((Object)evalSound, (String)"HERMES");
                castResult = CastingHarness.CastResult.copy$default(update, null, null, null, null, evalSound, 15, null);
            } else {
                castResult = update;
            }
        } else {
            List list = CollectionsKt.emptyList();
            EvalSound evalSound = HexEvalSounds.HERMES;
            Intrinsics.checkNotNullExpressionValue((Object)evalSound, (String)"HERMES");
            castResult = new CastingHarness.CastResult(continuation, null, ResolvedPatternType.EVALUATED, list, evalSound);
        }
        return castResult;
    }

    @Override
    @NotNull
    public CompoundTag serializeToNBT() {
        String $this$remAssign$iv;
        CompoundTag compoundTag;
        NBTBuilder this_$iv = NBTBuilder.INSTANCE;
        boolean $i$f$invoke = false;
        NBTBuilder this_$iv$iv = this_$iv;
        boolean $i$f$compound = false;
        CompoundTag $this$serializeToNBT_u24lambda_u240 = compoundTag = NbtCompoundBuilder.constructor-impl(new CompoundTag());
        boolean bl = false;
        String string = "type";
        String str$iv = "evaluate";
        boolean bl2 = false;
        boolean bl3 = false;
        StringTag stringTag = StringTag.m_129297_((String)str$iv);
        Intrinsics.checkNotNullExpressionValue((Object)stringTag, (String)"valueOf(value)");
        $this$serializeToNBT_u24lambda_u240.m_128365_($this$remAssign$iv, (Tag)stringTag);
        $this$remAssign$iv = "patterns";
        Tag nbt$iv = HexUtils.serializeToNBT(this.list);
        bl2 = false;
        $this$serializeToNBT_u24lambda_u240.m_128365_($this$remAssign$iv, nbt$iv);
        $this$remAssign$iv = "isMetacasting";
        boolean bool$iv = this.isMetacasting;
        bl2 = false;
        boolean value$iv$iv = bool$iv;
        boolean bl4 = false;
        ByteTag byteTag = ByteTag.m_128266_((byte)((byte)(value$iv$iv ? 1 : 0)));
        Intrinsics.checkNotNullExpressionValue((Object)byteTag, (String)"valueOf(value.toByte())");
        $this$serializeToNBT_u24lambda_u240.m_128365_($this$remAssign$iv, (Tag)byteTag);
        return compoundTag;
    }

    @NotNull
    public final SpellList component1() {
        return this.list;
    }

    public final boolean component2() {
        return this.isMetacasting;
    }

    @NotNull
    public final FrameEvaluate copy(@NotNull SpellList list, boolean isMetacasting) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        return new FrameEvaluate(list, isMetacasting);
    }

    public static /* synthetic */ FrameEvaluate copy$default(FrameEvaluate frameEvaluate, SpellList spellList, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            spellList = frameEvaluate.list;
        }
        if ((n & 2) != 0) {
            bl = frameEvaluate.isMetacasting;
        }
        return frameEvaluate.copy(spellList, bl);
    }

    @NotNull
    public String toString() {
        return "FrameEvaluate(list=" + this.list + ", isMetacasting=" + this.isMetacasting + ")";
    }

    public int hashCode() {
        int result = this.list.hashCode();
        int n = this.isMetacasting ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FrameEvaluate)) {
            return false;
        }
        FrameEvaluate frameEvaluate = (FrameEvaluate)other;
        if (!Intrinsics.areEqual((Object)this.list, (Object)frameEvaluate.list)) {
            return false;
        }
        return this.isMetacasting == frameEvaluate.isMetacasting;
    }
}

