/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.forge.eventhandlers;

import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.iota.NullIota;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import ram.talia.hexal.api.everbook.Everbook;
import ram.talia.hexal.common.network.MsgRemoveEverbookAck;
import ram.talia.hexal.common.network.MsgSendEverbookSyn;
import ram.talia.hexal.common.network.MsgSetEverbookAck;
import ram.talia.hexal.common.network.MsgToggleMacroAck;
import ram.talia.hexal.forge.network.ForgePacketHandler;
import ram.talia.hexal.xplat.IXplatAbstractions;

public class EverbookEventHandler {
    private static final Map<UUID, Everbook> everbooks = new HashMap<UUID, Everbook>();
    public static Everbook localEverbook;
    private static boolean syncedLocalToServer;

    public static Everbook getEverbook(Player player) {
        return everbooks.get(player.m_20148_());
    }

    public static void setEverbook(Player player, Everbook everbook) {
        everbooks.put(player.m_20148_(), everbook);
    }

    public static Iota getIota(ServerPlayer player, HexPattern key) {
        if (everbooks.get(player.m_20148_()) == null) {
            return new NullIota();
        }
        return everbooks.get(player.m_20148_()).getIota(key, player.m_9236_());
    }

    public static void setIota(ServerPlayer player, HexPattern key, Iota iota) {
        if (everbooks.get(player.m_20148_()) == null) {
            return;
        }
        everbooks.get(player.m_20148_()).setIota(key, iota);
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(player, new MsgSetEverbookAck(key, HexIotaTypes.serialize((Iota)iota)));
    }

    public static void removeIota(ServerPlayer player, HexPattern key) {
        if (everbooks.get(player.m_20148_()) == null) {
            return;
        }
        everbooks.get(player.m_20148_()).removeIota(key);
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(player, new MsgRemoveEverbookAck(key));
    }

    public static List<Iota> getMacro(ServerPlayer player, HexPattern key) {
        if (everbooks.get(player.m_20148_()) == null) {
            return List.of();
        }
        return everbooks.get(player.m_20148_()).getMacro(key, player.m_9236_());
    }

    public static void toggleMacro(ServerPlayer player, HexPattern key) {
        if (everbooks.get(player.m_20148_()) == null) {
            return;
        }
        everbooks.get(player.m_20148_()).toggleMacro(key);
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(player, new MsgToggleMacroAck(key));
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (!everbooks.containsKey(player.m_20148_())) {
            everbooks.put(player.m_20148_(), new Everbook(player.m_20148_()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player == null || event.side == LogicalSide.SERVER || syncedLocalToServer) {
            return;
        }
        syncedLocalToServer = true;
        localEverbook = Everbook.fromDisk(event.player.m_20148_());
        ForgePacketHandler.getNetwork().sendToServer((Object)new MsgSendEverbookSyn(localEverbook));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientPlayerLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        if (localEverbook != null) {
            localEverbook.saveToDisk();
        }
        localEverbook = null;
        syncedLocalToServer = false;
    }

    static {
        syncedLocalToServer = false;
    }
}

