/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.harvestwithease.api.event;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import org.jetbrains.annotations.Nullable;

public abstract class HarvestWithEaseEvent<P extends Player, L extends Level>
extends PlayerEvent {
    protected final L level;
    protected final BlockState target;
    protected final BlockPos pos;
    protected final InteractionHand hand;
    protected final boolean first;

    public HarvestWithEaseEvent(L level, BlockState target, BlockPos pos, P player, InteractionHand hand, boolean first) {
        super(player);
        this.level = level;
        this.target = target;
        this.pos = pos;
        this.hand = hand;
        this.first = first;
    }

    public P getEntity() {
        return (P)super.getEntity();
    }

    public L getLevel() {
        return this.level;
    }

    public BlockState getTargetBlock() {
        return this.target;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public static class AfterHarvest
    extends HarvestWithEaseServerEvent {
        public AfterHarvest(ServerLevel level, BlockState target, BlockPos pos, Direction face, @Nullable BlockHitResult hitResult, ServerPlayer player, InteractionHand hand) {
            super(level, target, pos, face, hitResult, player, hand);
        }
    }

    @Cancelable
    public static class HarvestDrops
    extends HarvestWithEaseServerEvent {
        public final List<ItemStack> drops;
        private final List<ItemStack> defaultDrops = this.initDrops();

        public HarvestDrops(ServerLevel level, BlockState target, BlockPos pos, Direction face, @Nullable BlockHitResult hitResult, ServerPlayer player, InteractionHand hand) {
            super(level, target, pos, face, hitResult, player, hand);
            this.drops = new ArrayList<ItemStack>(this.defaultDrops.stream().map(item -> item.m_41777_()).toList());
        }

        public boolean haveDropsChanged() {
            if (this.defaultDrops.size() == this.drops.size()) {
                for (int c = 0; c < this.defaultDrops.size(); ++c) {
                    if (ItemStack.m_41728_((ItemStack)this.defaultDrops.get(c), (ItemStack)this.drops.get(c))) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        private List<ItemStack> initDrops() {
            List drops = Block.m_49874_((BlockState)this.target, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.pos, (BlockEntity)(this.target.m_155947_() ? ((ServerLevel)this.level).m_7702_(this.pos) : null), this.getEntity(), (ItemStack)((ServerPlayer)this.getEntity()).m_21120_(this.hand));
            boolean seedRemoved = false;
            for (ItemStack stack : drops) {
                if (seedRemoved || !stack.m_41656_(this.target.m_60734_().getCloneItemStack(this.target, (HitResult)this.hitResult, (BlockGetter)this.level, this.pos, this.getEntity()))) continue;
                stack.m_41774_(1);
                seedRemoved = true;
            }
            return drops;
        }
    }

    public static class BeforeHarvest
    extends HarvestWithEaseServerEvent {
        public BeforeHarvest(ServerLevel level, BlockState target, BlockPos pos, Direction face, @Nullable BlockHitResult hitResult, ServerPlayer player, InteractionHand hand) {
            super(level, target, pos, face, hitResult, player, hand);
        }
    }

    @Cancelable
    public static class RightClickHarvestCheck
    extends HarvestWithEaseEvent<Player, Level> {
        private boolean canHarvest;

        public RightClickHarvestCheck(Level level, BlockState target, BlockPos pos, Player player, InteractionHand hand, boolean canHarvest, boolean first) {
            super(level, target, pos, player, hand, first);
            this.canHarvest = canHarvest;
        }

        public boolean canHarvest() {
            return this.canHarvest;
        }

        public void setCanHarvest(boolean canHarvest) {
            this.canHarvest = canHarvest;
        }
    }

    public static abstract class HarvestWithEaseServerEvent
    extends HarvestWithEaseEvent<ServerPlayer, ServerLevel> {
        protected final Direction face;
        @Nullable
        protected final BlockHitResult hitResult;

        public HarvestWithEaseServerEvent(ServerLevel level, BlockState target, BlockPos pos, Direction face, @Nullable BlockHitResult hitResult, ServerPlayer player, InteractionHand hand) {
            super(level, target, pos, player, hand, hitResult != null);
            this.face = face;
            this.hitResult = hitResult;
        }

        public Direction getFace() {
            return this.face;
        }

        @Nullable
        public BlockHitResult getHitVec() {
            return this.hitResult;
        }
    }
}

