/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.predicate;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.predicate.FusionPredicateRegistry;
import com.supermartijn642.fusion.api.util.Serializer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class OrConnectionPredicate
implements ConnectionPredicate {
    public static final Serializer<OrConnectionPredicate> SERIALIZER = new Serializer<OrConnectionPredicate>(){

        @Override
        public OrConnectionPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!json.has("predicates") || !json.get("predicates").isJsonArray()) {
                throw new JsonParseException("Or-predicate must have array property 'predicates'!");
            }
            ArrayList<ConnectionPredicate> predicates = new ArrayList<ConnectionPredicate>();
            JsonArray array = json.getAsJsonArray("predicates");
            for (JsonElement element : array) {
                if (!element.isJsonObject()) {
                    throw new JsonParseException("Property 'predicates' must only contain objects!");
                }
                ConnectionPredicate predicate = FusionPredicateRegistry.deserializeConnectionPredicate(element.getAsJsonObject());
                predicates.add(predicate);
            }
            return new OrConnectionPredicate(predicates);
        }

        @Override
        public JsonObject serialize(OrConnectionPredicate value) {
            JsonObject json = new JsonObject();
            JsonArray predicatesJson = new JsonArray();
            for (ConnectionPredicate predicate : value.predicates) {
                predicatesJson.add((JsonElement)FusionPredicateRegistry.serializeConnectionPredicate(predicate));
            }
            json.add("predicates", (JsonElement)predicatesJson);
            return json;
        }
    };
    private final List<ConnectionPredicate> predicates;

    public OrConnectionPredicate(List<ConnectionPredicate> predicates) {
        this.predicates = predicates;
    }

    @Override
    public boolean shouldConnect(Direction side, @Nullable BlockState ownState, BlockState otherState, BlockState blockInFront, ConnectionDirection direction) {
        return this.predicates.stream().anyMatch(predicate -> predicate.shouldConnect(side, ownState, otherState, blockInFront, direction));
    }

    @Override
    public Serializer<? extends ConnectionPredicate> getSerializer() {
        return SERIALIZER;
    }
}

