/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.supermartijn642.fusion.api.texture.SpriteCreationContext;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public class SpriteCreationContextImpl
implements SpriteCreationContext,
AutoCloseable {
    private final TextureAtlasSprite original;
    private final int textureWidth;
    private final int textureHeight;
    private final ResourceLocation identifier;
    private final NativeImage[] images;
    private final int atlasWidth;
    private final int atlasHeight;
    private final TextureAtlas atlas;
    private final int spriteX;
    private final int spriteY;
    private final int spriteWidth;
    private final int spriteHeight;
    private final int mipmapLevels;
    private boolean originalRequested = false;
    private boolean imagesRequested = false;

    public SpriteCreationContextImpl(TextureAtlasSprite original) {
        this.original = original;
        this.textureWidth = original.f_118342_[0].m_84982_();
        this.textureHeight = original.f_118342_[0].m_85084_();
        this.identifier = original.m_118413_();
        this.images = original.f_118342_;
        this.atlasWidth = Math.round((float)(original.m_174743_() + original.m_118405_()) / original.m_118410_());
        this.atlasHeight = Math.round((float)(original.m_174744_() + original.m_118408_()) / original.m_118412_());
        this.atlas = original.m_118414_();
        this.spriteX = original.m_174743_();
        this.spriteY = original.m_174744_();
        this.spriteWidth = original.m_118405_();
        this.spriteHeight = original.m_118408_();
        this.mipmapLevels = original.f_118342_.length - 1;
    }

    private void closeUnusedResources() {
        if (!this.originalRequested) {
            if (!this.imagesRequested) {
                this.original.close();
            } else if (this.original.f_174725_ != null) {
                this.original.f_174725_.close();
            }
        }
    }

    @Override
    public TextureAtlasSprite createOriginalSprite() {
        this.originalRequested = true;
        return this.original;
    }

    @Override
    public int getTextureWidth() {
        return this.textureWidth;
    }

    @Override
    public int getTextureHeight() {
        return this.textureHeight;
    }

    @Override
    public ResourceLocation getTextureIdentifier() {
        return this.identifier;
    }

    @Override
    public NativeImage[] getTextureBuffers() {
        this.imagesRequested = true;
        return this.images;
    }

    @Override
    public int getAtlasWidth() {
        return this.atlasWidth;
    }

    @Override
    public int getAtlasHeight() {
        return this.atlasHeight;
    }

    @Override
    public TextureAtlas getAtlas() {
        return this.atlas;
    }

    @Override
    public int getSpritePositionX() {
        return this.spriteX;
    }

    @Override
    public int getSpritePositionY() {
        return this.spriteY;
    }

    @Override
    public int getSpriteWidth() {
        return this.spriteWidth;
    }

    @Override
    public int getSpriteHeight() {
        return this.spriteHeight;
    }

    @Override
    public int getMipmapLevels() {
        return this.mipmapLevels;
    }

    @Override
    public void close() {
        this.closeUnusedResources();
    }
}

