/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Transformation;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.SpriteHelper;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureLayout;
import com.supermartijn642.fusion.model.WrappedBakedModel;
import com.supermartijn642.fusion.model.types.connecting.SurroundingBlockData;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectingBakedModel
extends WrappedBakedModel {
    private static final int BLOCK_VERTEX_DATA_UV_OFFSET = ConnectingBakedModel.findUVOffset(DefaultVertexFormat.f_85811_);
    private static final ModelProperty<SurroundingBlockData> SURROUNDING_BLOCK_DATA_MODEL_PROPERTY = new ModelProperty();
    private final Transformation modelRotation;
    private final List<ConnectionPredicate> predicates;
    private final Map<Direction, Map<Integer, List<BakedQuad>>> quadCache = new HashMap<Direction, Map<Integer, List<BakedQuad>>>();
    private final Map<Integer, List<BakedQuad>> directionlessQuadCache = new HashMap<Integer, List<BakedQuad>>();

    public ConnectingBakedModel(BakedModel original, Transformation modelRotation, List<ConnectionPredicate> predicates) {
        super(original);
        this.modelRotation = modelRotation;
        this.predicates = predicates;
        for (Direction direction : Direction.values()) {
            this.quadCache.put(direction, new HashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource random, @NotNull ModelData modelData, @Nullable RenderType renderType) {
        Map<Integer, List<BakedQuad>> cache;
        SurroundingBlockData data = modelData.has(SURROUNDING_BLOCK_DATA_MODEL_PROPERTY) ? (SurroundingBlockData)modelData.get(SURROUNDING_BLOCK_DATA_MODEL_PROPERTY) : null;
        int hashCode = data == null ? 0 : data.hashCode();
        Map<Integer, List<BakedQuad>> map = cache = side == null ? this.directionlessQuadCache : this.quadCache.get(side);
        if (!cache.containsKey(hashCode)) {
            Map<Integer, List<BakedQuad>> map2 = cache;
            synchronized (map2) {
                if (!cache.containsKey(hashCode)) {
                    cache.put(hashCode, this.remapQuads(this.original.m_213637_(state, side, random), data));
                }
            }
        }
        return cache.get(hashCode);
    }

    private List<BakedQuad> remapQuads(List<BakedQuad> originalQuads, SurroundingBlockData surroundingBlocks) {
        if (surroundingBlocks == null) {
            return originalQuads;
        }
        return originalQuads.stream().map(quad -> this.remapQuad((BakedQuad)quad, surroundingBlocks)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected BakedQuad remapQuad(BakedQuad quad, SurroundingBlockData surroundingBlocks) {
        TextureAtlasSprite sprite = quad.m_173410_();
        if (SpriteHelper.getTextureType(sprite) != DefaultTextureTypes.CONNECTING) {
            return quad;
        }
        ConnectingTextureLayout layout = ((ConnectingTextureSprite)sprite).getLayout();
        int[] vertexData = quad.m_111303_();
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        SurroundingBlockData.SideConnections connections = surroundingBlocks.getConnections(quad.m_111306_());
        int[] uv = ConnectingTextureType.getStatePosition(layout, connections.top, connections.topRight, connections.right, connections.bottomRight, connections.bottom, connections.bottomLeft, connections.left, connections.topLeft);
        ConnectingBakedModel.adjustVertexDataUV(vertexData, uv[0], uv[1], sprite);
        return new BakedQuad(vertexData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    private static int[] adjustVertexDataUV(int[] vertexData, int newU, int newV, TextureAtlasSprite sprite) {
        int vertexSize = DefaultVertexFormat.f_85811_.m_86017_();
        int vertices = vertexData.length / vertexSize;
        int uvOffset = BLOCK_VERTEX_DATA_UV_OFFSET / 4;
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize + uvOffset;
            float width = sprite.m_118410_() - sprite.m_118409_();
            float u = Float.intBitsToFloat(vertexData[offset]) + width * (float)newU;
            vertexData[offset] = Float.floatToRawIntBits(u);
            float height = sprite.m_118412_() - sprite.m_118411_();
            float v = Float.intBitsToFloat(vertexData[offset + 1]) + height * (float)newV;
            vertexData[offset + 1] = Float.floatToRawIntBits(v);
        }
        return vertexData;
    }

    private static int findUVOffset(VertexFormat vertexFormat) {
        int index;
        VertexFormatElement element = null;
        for (index = 0; index < vertexFormat.m_86023_().size(); ++index) {
            VertexFormatElement el = (VertexFormatElement)vertexFormat.m_86023_().get(index);
            if (el.m_86048_() != VertexFormatElement.Usage.UV) continue;
            element = el;
            break;
        }
        if (index == vertexFormat.m_86023_().size() || element == null) {
            throw new RuntimeException("Expected vertex format to have a UV attribute");
        }
        if (element.m_86041_() != VertexFormatElement.Type.FLOAT) {
            throw new RuntimeException("Expected UV attribute to have data type FLOAT");
        }
        if (element.m_86050_() < 4) {
            throw new RuntimeException("Expected UV attribute to have at least 4 dimensions");
        }
        return vertexFormat.f_86013_.getInt(index);
    }

    public SurroundingBlockData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        return SurroundingBlockData.create(level, pos, this.modelRotation, this.predicates);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        return ModelData.builder().with(SURROUNDING_BLOCK_DATA_MODEL_PROPERTY, (Object)this.getModelData(level, pos, state)).build();
    }

    @Override
    public boolean m_7521_() {
        return super.m_7521_();
    }

    @Override
    public ItemTransforms m_7442_() {
        return super.m_7442_();
    }

    @Override
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

