/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftbranks.FTBRanks;
import dev.ftb.mods.ftbranks.PlayerNameFormatting;
import dev.ftb.mods.ftbranks.api.FTBRanksAPI;
import dev.ftb.mods.ftbranks.api.PermissionValue;
import dev.ftb.mods.ftbranks.api.Rank;
import dev.ftb.mods.ftbranks.api.RankCondition;
import dev.ftb.mods.ftbranks.api.RankConditionFactory;
import dev.ftb.mods.ftbranks.api.RankManager;
import dev.ftb.mods.ftbranks.api.event.RankCreatedEvent;
import dev.ftb.mods.ftbranks.api.event.RankDeletedEvent;
import dev.ftb.mods.ftbranks.api.event.RankEvent;
import dev.ftb.mods.ftbranks.api.event.RanksReloadedEvent;
import dev.ftb.mods.ftbranks.impl.BooleanPermissionValue;
import dev.ftb.mods.ftbranks.impl.FTBRanksCommandManager;
import dev.ftb.mods.ftbranks.impl.NumberPermissionValue;
import dev.ftb.mods.ftbranks.impl.PlayerRankData;
import dev.ftb.mods.ftbranks.impl.RankCommandPredicate;
import dev.ftb.mods.ftbranks.impl.RankImpl;
import dev.ftb.mods.ftbranks.impl.StringPermissionValue;
import dev.ftb.mods.ftbranks.impl.condition.AlwaysActiveCondition;
import dev.ftb.mods.ftbranks.impl.condition.OPCondition;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.Nullable;

public class RankManagerImpl
implements RankManager {
    public static final LevelResource FOLDER_NAME = new LevelResource("serverconfig/ftbranks");
    public final MinecraftServer server;
    private Path directory;
    private Path rankFile;
    private Path playerFile;
    private final Path defaultRankFile = ConfigUtil.DEFAULT_CONFIG_DIR.resolve("ftbranks").resolve("ranks.snbt");
    boolean shouldSaveRanks;
    boolean shouldSavePlayers;
    private Map<String, RankImpl> ranks;
    private List<RankImpl> sortedRanks;
    private final Map<String, RankConditionFactory> conditions;
    Map<UUID, PlayerRankData> playerData;

    public RankManagerImpl(MinecraftServer s) {
        this.server = s;
        this.conditions = new HashMap<String, RankConditionFactory>();
    }

    void load() throws Exception {
        this.directory = this.server.m_129843_(FOLDER_NAME);
        if (Files.notExists(this.directory, new LinkOption[0])) {
            Files.createDirectories(this.directory, new FileAttribute[0]);
        }
        this.rankFile = this.directory.resolve("ranks.snbt");
        this.playerFile = this.directory.resolve("players.snbt");
        Path oldRankFile = this.directory.resolve("ranks.json");
        Path oldPlayerFile = this.directory.resolve("players.json");
        boolean oldRankFileLoaded = false;
        boolean oldPlayerFileLoaded = false;
        if (Files.exists(oldRankFile, new LinkOption[0])) {
            Files.move(oldRankFile, this.rankFile, new CopyOption[0]);
            oldRankFileLoaded = true;
        }
        if (Files.exists(oldPlayerFile, new LinkOption[0])) {
            Files.move(oldPlayerFile, this.playerFile, new CopyOption[0]);
            oldPlayerFileLoaded = true;
        }
        if (oldRankFileLoaded || oldPlayerFileLoaded || Files.notExists(this.directory.resolve("README.txt"), new LinkOption[0])) {
            this.refreshReadme();
        }
        this.reload();
        if (oldRankFileLoaded) {
            this.saveRanks();
            this.saveRanksNow();
        }
        if (oldPlayerFileLoaded) {
            this.savePlayers();
            this.savePlayersNow();
        }
    }

    public void refreshReadme() throws IOException {
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add("=== FTB Ranks ===");
        lines.add("");
        lines.add("Last README file update: " + new Date());
        lines.add("Wiki: https://www.notion.so/feedthebeast/FTB-Mod-Documentation-da2e359bad2449459d58d787edda3168");
        lines.add("To refresh this file, run /ftbranks refresh_readme");
        lines.add("");
        lines.add("= All available command nodes =");
        lines.add("command");
        HashSet<String> set = new HashSet<String>();
        for (RankCommandPredicate predicate : FTBRanksCommandManager.INSTANCE.commands.values()) {
            set.add(predicate.getNode());
        }
        ArrayList commandList = new ArrayList(set);
        commandList.sort(null);
        lines.addAll(commandList);
        Files.write(this.directory.resolve("README.txt"), lines, new OpenOption[0]);
    }

    @Override
    public void saveRanks() {
        this.shouldSaveRanks = true;
    }

    @Override
    public void savePlayers() {
        this.shouldSavePlayers = true;
    }

    @Override
    public List<Rank> getAllRanks() {
        return this.sortedRanks;
    }

    @Override
    public Optional<Rank> getRank(String id) {
        return Optional.ofNullable((Rank)this.ranks.get(id));
    }

    @Override
    public RankImpl createRank(String id) {
        this.deleteRank(id);
        RankImpl r = new RankImpl(this, id);
        this.ranks.put(id, r);
        this.sortedRanks = new ArrayList<RankImpl>(this.ranks.values());
        this.sortedRanks.sort(null);
        this.saveRanks();
        ((Consumer)RankEvent.CREATED.invoker()).accept(new RankCreatedEvent(this, (Rank)r));
        return r;
    }

    public RankImpl createRank(String id, String name) {
        RankImpl rank = this.createRank(id);
        rank.name = name;
        this.saveRanks();
        return rank;
    }

    @Override
    @Nullable
    public RankImpl deleteRank(String id) {
        RankImpl r = this.ranks.get(id);
        if (r != null) {
            for (PlayerRankData rankData : this.playerData.values()) {
                if (rankData.added.remove(r) == null) continue;
                this.savePlayers();
            }
            this.ranks.remove(id);
            this.sortedRanks = new ArrayList<RankImpl>(this.ranks.values());
            this.sortedRanks.sort(null);
            ((Consumer)RankEvent.DELETED.invoker()).accept(new RankDeletedEvent(this, (Rank)r));
            this.saveRanks();
        }
        return r;
    }

    public PlayerRankData getPlayerData(GameProfile profile) {
        PlayerRankData data = this.playerData.get(profile.getId());
        if (data == null) {
            data = new PlayerRankData(this, profile.getId());
            data.name = profile.getName();
            this.playerData.put(data.uuid, data);
            this.saveRanks();
        }
        return data;
    }

    @Override
    public Set<Rank> getAddedRanks(GameProfile profile) {
        return this.getPlayerData((GameProfile)profile).added.keySet();
    }

    @Override
    public void registerCondition(String predicate, RankConditionFactory conditionFactory) {
        this.conditions.put(predicate, conditionFactory);
    }

    @Override
    public RankCondition createCondition(Rank rank, @Nullable Tag tag) throws Exception {
        SNBTCompoundTag compoundTag = new SNBTCompoundTag();
        if (tag instanceof StringTag) {
            compoundTag.m_128359_("type", tag.m_7916_());
        } else if (tag instanceof SNBTCompoundTag) {
            SNBTCompoundTag c;
            compoundTag = c = (SNBTCompoundTag)tag;
        }
        String key = compoundTag.m_128461_("type");
        if (!this.conditions.containsKey(key)) {
            throw new IllegalArgumentException("Can't create condition from tag " + tag);
        }
        return this.conditions.get(key).create(rank, compoundTag);
    }

    @Override
    public PermissionValue getPermissionValue(ServerPlayer player, String node) {
        if (node.isEmpty() || this.sortedRanks == null || this.sortedRanks.isEmpty()) {
            return PermissionValue.DEFAULT;
        }
        try {
            ArrayList<RankImpl> list = new ArrayList<RankImpl>();
            for (RankImpl rank : this.sortedRanks) {
                if (!rank.isActive(player)) continue;
                list.add(rank);
            }
            return this.getPermissionValue(this.getPlayerData(player.m_36316_()), list, node);
        }
        catch (Exception ex) {
            FTBRanks.LOGGER.error("Error getting permission value for node " + node + "!");
            ex.printStackTrace();
            return PermissionValue.DEFAULT;
        }
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    private PermissionValue getPermissionValue(PlayerRankData data, List<RankImpl> ranks, String node) {
        if (node.isEmpty()) {
            return PermissionValue.DEFAULT;
        }
        PermissionValue pvalue = data.permissions.get(node);
        if (pvalue != null) {
            return pvalue;
        }
        for (RankImpl rank : ranks) {
            PermissionValue value = rank.permissions.get(node);
            if (value == null) continue;
            return value;
        }
        int i = node.lastIndexOf(46);
        return i == -1 ? PermissionValue.DEFAULT : this.getPermissionValue(data, ranks, node.substring(0, i));
    }

    public void reload() throws Exception {
        SNBTCompoundTag playerFileTag;
        SNBTCompoundTag o;
        this.shouldSaveRanks = false;
        if (Files.notExists(this.rankFile, new LinkOption[0])) {
            if (Files.exists(this.defaultRankFile, new LinkOption[0])) {
                Files.copy(this.defaultRankFile, this.rankFile, new CopyOption[0]);
            } else {
                this.ranks = new LinkedHashMap<String, RankImpl>();
                RankImpl memberRank = new RankImpl(this, "member");
                memberRank.setPermission("name", StringPermissionValue.of("Member"));
                memberRank.setPermission("power", NumberPermissionValue.of(1));
                memberRank.condition = AlwaysActiveCondition.INSTANCE;
                this.ranks.put("member", memberRank);
                RankImpl vipRank = new RankImpl(this, "vip");
                vipRank.setPermission("name", StringPermissionValue.of("VIP"));
                vipRank.setPermission("power", NumberPermissionValue.of(50));
                vipRank.setPermission("ftbranks.name_format", StringPermissionValue.of("&bVIP {name}"));
                this.ranks.put("vip", vipRank);
                RankImpl adminRank = new RankImpl(this, "admin");
                adminRank.setPermission("name", StringPermissionValue.of("Admin"));
                adminRank.setPermission("power", NumberPermissionValue.of(1000));
                adminRank.setPermission("ftbranks.name_format", StringPermissionValue.of("&2{name}"));
                adminRank.condition = new OPCondition();
                this.ranks.put("admin", adminRank);
                this.saveRanks();
                this.saveRanksNow();
            }
        }
        if (Files.notExists(this.playerFile, new LinkOption[0])) {
            this.playerData = new HashMap<UUID, PlayerRankData>();
            this.savePlayers();
            this.savePlayersNow();
        }
        LinkedHashMap<String, RankImpl> tempRanks = new LinkedHashMap<String, RankImpl>();
        LinkedHashMap<UUID, PlayerRankData> tempPlayerData = new LinkedHashMap<UUID, PlayerRankData>();
        SNBTCompoundTag rankFileTag = SNBT.read((Path)this.rankFile);
        if (rankFileTag != null) {
            for (String key : rankFileTag.m_128431_()) {
                RankImpl rank = new RankImpl(this, key);
                o = rankFileTag.getCompound(key);
                rank.name = o.m_128461_("name");
                rank.power = o.m_128451_("power");
                if (o.m_128441_("condition")) {
                    try {
                        rank.condition = this.createCondition(rank, o.m_128423_("condition"));
                    }
                    catch (Exception ex) {
                        FTBRanks.LOGGER.error("Failed to parse condition for " + rank.id + ": " + ex);
                    }
                }
                o.m_128473_("name");
                o.m_128473_("power");
                o.m_128473_("condition");
                for (String pkey : o.m_128431_()) {
                    while (pkey.endsWith(".*")) {
                        pkey = pkey.substring(0, pkey.length() - 2);
                        this.saveRanks();
                    }
                    if (pkey.isEmpty()) continue;
                    rank.permissions.put(pkey, RankManagerImpl.ofTag(o, pkey));
                }
                if (rank.name.isEmpty()) {
                    rank.name = rank.id;
                    this.saveRanks();
                }
                tempRanks.put(rank.id, rank);
            }
            if (tempRanks.isEmpty()) {
                FTBRanks.LOGGER.warn("No ranks found!");
            }
        }
        if ((playerFileTag = SNBT.read((Path)this.playerFile)) != null) {
            for (String key : playerFileTag.m_128431_()) {
                o = playerFileTag.getCompound(key);
                PlayerRankData data = new PlayerRankData(this, UUID.fromString(key));
                data.name = o.m_128461_("name");
                SNBTCompoundTag ranksTag = o.getCompound("ranks");
                for (String rkey : ranksTag.m_128431_()) {
                    RankImpl rank = (RankImpl)tempRanks.get(rkey);
                    if (rank == null) continue;
                    data.added.put(rank, Instant.parse(ranksTag.m_128461_(rkey)));
                }
                if (o.m_128441_("permissions")) {
                    SNBTCompoundTag ptag = o.getCompound("permissions");
                    for (String pkey : ptag.m_128431_()) {
                        while (pkey.endsWith(".*")) {
                            pkey = pkey.substring(0, pkey.length() - 2);
                            this.savePlayers();
                        }
                        if (pkey.isEmpty()) continue;
                        data.permissions.put(key, RankManagerImpl.ofTag(ptag, pkey));
                    }
                }
                tempPlayerData.put(data.uuid, data);
            }
        }
        this.ranks = new LinkedHashMap<String, RankImpl>(tempRanks);
        this.playerData = new LinkedHashMap<UUID, PlayerRankData>(tempPlayerData);
        this.sortedRanks = new ArrayList<RankImpl>(this.ranks.values());
        this.sortedRanks.sort(null);
        ((Consumer)RankEvent.RELOADED.invoker()).accept(new RanksReloadedEvent(FTBRanksAPI.INSTANCE.getManager()));
        PlayerNameFormatting.refreshPlayerNames();
        FTBRanks.LOGGER.info("Loaded " + this.ranks.size() + " ranks");
    }

    public void saveRanksNow() {
        if (!this.shouldSaveRanks) {
            return;
        }
        this.shouldSaveRanks = false;
        SNBTCompoundTag tag = new SNBTCompoundTag();
        for (RankImpl rank : this.ranks.values()) {
            SNBTCompoundTag o = new SNBTCompoundTag();
            o.m_128359_("name", rank.getName());
            o.m_128405_("power", rank.getPower());
            if (!rank.condition.isDefaultCondition()) {
                if (rank.condition.isSimple()) {
                    o.m_128359_("condition", rank.condition.getType());
                } else {
                    SNBTCompoundTag c = new SNBTCompoundTag();
                    c.m_128359_("type", rank.condition.getType());
                    rank.condition.save(c);
                    o.m_128365_("condition", (Tag)c);
                }
            }
            for (Map.Entry<String, PermissionValue> entry : rank.permissions.entrySet()) {
                PermissionValue v = entry.getValue();
                if (v.isDefaultValue()) {
                    o.putNull(entry.getKey());
                    continue;
                }
                if (v instanceof BooleanPermissionValue) {
                    o.m_128379_(entry.getKey(), ((BooleanPermissionValue)entry.getValue()).value);
                    continue;
                }
                if (v instanceof StringPermissionValue) {
                    o.m_128359_(entry.getKey(), ((StringPermissionValue)entry.getValue()).value);
                    continue;
                }
                if (v instanceof NumberPermissionValue) {
                    o.putNumber(entry.getKey(), ((NumberPermissionValue)entry.getValue()).value);
                    continue;
                }
                o.m_128359_(entry.getKey(), entry.getValue().asString().orElse(""));
            }
            tag.m_128365_(rank.id, (Tag)o);
        }
        if (!SNBT.write((Path)this.rankFile, (CompoundTag)tag)) {
            FTBRanks.LOGGER.warn("Failed to save ranks.snbt!");
        }
    }

    public void savePlayersNow() {
        if (!this.shouldSavePlayers) {
            return;
        }
        this.shouldSavePlayers = false;
        SNBTCompoundTag playerJson = new SNBTCompoundTag();
        for (PlayerRankData data : this.playerData.values()) {
            SNBTCompoundTag o = new SNBTCompoundTag();
            o.m_128359_("name", data.name);
            SNBTCompoundTag r = new SNBTCompoundTag();
            for (Map.Entry<Rank, Instant> entry : data.added.entrySet()) {
                if (!entry.getKey().getCondition().isDefaultCondition()) continue;
                r.m_128359_(entry.getKey().getId(), entry.getValue().toString());
            }
            o.m_128365_("ranks", (Tag)r);
            if (!data.permissions.isEmpty()) {
                SNBTCompoundTag p = new SNBTCompoundTag();
                for (Map.Entry<String, PermissionValue> entry : data.permissions.entrySet()) {
                    PermissionValue v = entry.getValue();
                    if (v.isDefaultValue()) {
                        p.putNull(entry.getKey());
                        continue;
                    }
                    if (v instanceof BooleanPermissionValue) {
                        p.m_128379_(entry.getKey(), ((BooleanPermissionValue)entry.getValue()).value);
                        continue;
                    }
                    if (v instanceof StringPermissionValue) {
                        p.m_128359_(entry.getKey(), ((StringPermissionValue)entry.getValue()).value);
                        continue;
                    }
                    if (v instanceof NumberPermissionValue) {
                        p.putNumber(entry.getKey(), ((NumberPermissionValue)entry.getValue()).value);
                        continue;
                    }
                    p.m_128359_(entry.getKey(), entry.getValue().asString().orElse(""));
                }
                o.m_128365_("permissions", (Tag)p);
            }
            playerJson.m_128365_(data.uuid.toString(), (Tag)o);
        }
        if (!SNBT.write((Path)this.playerFile, (CompoundTag)playerJson)) {
            FTBRanks.LOGGER.warn("Failed to save players.snbt!");
        }
    }

    private static PermissionValue ofTag(SNBTCompoundTag tag, String key) {
        if (tag.isBoolean(key)) {
            return BooleanPermissionValue.of(tag.m_128471_(key));
        }
        Tag v = tag.m_128423_(key);
        if (v == null || v instanceof EndTag) {
            return PermissionValue.DEFAULT;
        }
        if (v instanceof NumericTag) {
            return NumberPermissionValue.of(((NumericTag)v).m_8103_());
        }
        if (v instanceof StringTag) {
            return StringPermissionValue.of(v.m_7916_());
        }
        return StringPermissionValue.of(v.toString());
    }

    public void migrateOldNameFormats() {
        boolean[] changesMade = new boolean[]{false};
        this.ranks.forEach((name, rank) -> {
            String newFormat;
            String format = rank.getPermission("ftbranks.name_format").asString().orElse("");
            if (!format.isEmpty() && !format.equals(newFormat = format.replaceAll("^<", "").replaceAll("(&r)?>$", ""))) {
                rank.setPermission("ftbranks.name_format", StringPermissionValue.of(newFormat));
                changesMade[0] = true;
                FTBRanks.LOGGER.info("migrated old ftbranks.name_format node for rank {}: '{}' -> '{}'", rank, (Object)format, (Object)newFormat);
            }
        });
        if (changesMade[0]) {
            this.saveRanks();
            this.saveRanksNow();
        }
    }
}

