/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftbranks.PlayerNameFormatting;
import dev.ftb.mods.ftbranks.api.PermissionValue;
import dev.ftb.mods.ftbranks.api.Rank;
import dev.ftb.mods.ftbranks.api.RankCondition;
import dev.ftb.mods.ftbranks.api.RankManager;
import dev.ftb.mods.ftbranks.api.event.ConditionChangedEvent;
import dev.ftb.mods.ftbranks.api.event.PermissionNodeChangedEvent;
import dev.ftb.mods.ftbranks.api.event.PlayerAddedToRankEvent;
import dev.ftb.mods.ftbranks.api.event.PlayerRemovedFromRankEvent;
import dev.ftb.mods.ftbranks.api.event.RankEvent;
import dev.ftb.mods.ftbranks.impl.PlayerRankData;
import dev.ftb.mods.ftbranks.impl.RankManagerImpl;
import dev.ftb.mods.ftbranks.impl.condition.DefaultCondition;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class RankImpl
implements Rank,
Comparable<RankImpl> {
    public final RankManagerImpl manager;
    public final String id;
    public final Map<String, PermissionValue> permissions;
    public String name;
    public int power;
    public RankCondition condition;

    public RankImpl(RankManagerImpl m, String s) {
        this.manager = m;
        this.id = s;
        this.permissions = new LinkedHashMap<String, PermissionValue>();
        this.name = "";
        this.power = 50;
        this.condition = new DefaultCondition(this);
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Rank && this.id.equals(((Rank)o).getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public RankManager getManager() {
        return this.manager;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public void setPermission(String node, PermissionValue value) {
        if (node.equals("condition")) {
            throw new IllegalArgumentException("use '/ftbranks condition' to set conditions");
        }
        PermissionValue oldValue = this.getPermission(node);
        if (!oldValue.equals(value)) {
            if (value != null) {
                this.permissions.put(node, value);
            } else {
                this.permissions.remove(node);
            }
            ((Consumer)RankEvent.PERMISSION_CHANGED.invoker()).accept(new PermissionNodeChangedEvent(this.manager, this, node, oldValue, value));
            if (node.equals("ftbranks.name_format")) {
                PlayerNameFormatting.refreshPlayerNames();
            }
            this.manager.saveRanks();
        }
    }

    @Override
    public PermissionValue getPermission(String node) {
        return this.permissions.getOrDefault(node, PermissionValue.DEFAULT);
    }

    @Override
    public RankCondition getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(RankCondition condition) {
        RankCondition oldCondition = this.condition;
        this.condition = condition;
        ((Consumer)RankEvent.CONDITION_CHANGED.invoker()).accept(new ConditionChangedEvent(this.manager, this, oldCondition, condition));
        PlayerNameFormatting.refreshPlayerNames();
        this.manager.saveRanks();
    }

    @Override
    public boolean add(GameProfile profile) {
        PlayerRankData data = this.manager.getPlayerData(profile);
        if (!data.added.containsKey(this)) {
            data.added.put(this, Instant.now());
            this.manager.savePlayers();
            ((Consumer)RankEvent.ADD_PLAYER.invoker()).accept(new PlayerAddedToRankEvent(this.manager, this, profile));
            PlayerNameFormatting.refreshPlayerNames();
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(GameProfile profile) {
        PlayerRankData data = this.manager.getPlayerData(profile);
        if (data.added.remove(this) != null) {
            this.manager.savePlayers();
            ((Consumer)RankEvent.REMOVE_PLAYER.invoker()).accept(new PlayerRemovedFromRankEvent(this.manager, (Rank)this, profile));
            PlayerNameFormatting.refreshPlayerNames();
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(RankImpl o) {
        return o.getPower() - this.getPower();
    }

    @Override
    public Collection<String> getPermissions() {
        HashSet<String> nodes = new HashSet<String>(this.permissions.keySet());
        nodes.remove("name");
        nodes.remove("power");
        return nodes;
    }
}

