/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import dev.ftb.mods.ftbic.screen.ElectricBlockMenu;
import dev.ftb.mods.ftbic.screen.sync.SyncedData;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

public class ElectricBlockScreen<T extends ElectricBlockMenu<?>>
extends AbstractContainerScreen<T> {
    public static final ResourceLocation BASE_TEXTURE = new ResourceLocation("ftbic", "textures/gui/base.png");
    public int energyX = -1;
    public int energyY = -1;

    public ElectricBlockScreen(T m, Inventory inv, Component c) {
        super(m, inv, c);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, delta);
        this.renderExtra(poseStack, mouseX, mouseY, delta);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void renderExtra(PoseStack poseStack, int mouseX, int mouseY, float delta) {
    }

    public static boolean isIn(int mx, int my, int x, int y, int w, int h) {
        return mx >= x && mx < x + w && my >= y && my < y + h;
    }

    protected void m_7025_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7025_(poseStack, mouseX, mouseY);
        if (this.energyX != -1 && this.energyY != -1 && ElectricBlockScreen.isIn(mouseX, mouseY, this.f_97735_ + this.energyX, this.f_97736_ + this.energyY, 14, 14) && ((ElectricBlockMenu)this.f_97732_).m_142621_().m_41619_()) {
            double capacity = ((ElectricBlockMenu)this.f_97732_).data.get(SyncedData.ENERGY_CAPACITY);
            double energy = ((ElectricBlockMenu)this.f_97732_).data.get(SyncedData.ENERGY);
            this.m_169388_(poseStack, Collections.singletonList(Component.m_237113_((String)"").m_7220_((Component)FTBICUtils.formatEnergy(energy).m_130940_(ChatFormatting.GRAY)).m_130946_(" / ").m_7220_((Component)FTBICUtils.formatEnergy(capacity).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY)), Optional.empty(), mouseX, mouseY);
        }
    }

    public void drawArrow(PoseStack poseStack, int x, int y, int progress) {
        if (progress < 24) {
            this.m_93228_(poseStack, x + progress, y, 87 + progress, 167, 24 - progress, 17);
        }
        if (progress > 0) {
            this.m_93228_(poseStack, x, y, 87, 185, progress, 17);
        }
    }

    public int getEnergyType() {
        return 0;
    }

    public void drawEnergy(PoseStack poseStack, int x, int y, int energy) {
        switch (this.getEnergyType()) {
            case 1: {
                if (energy < 14) {
                    this.m_93228_(poseStack, x + energy, y, 91 + energy, 240, 14 - energy, 14);
                }
                if (energy <= 0) break;
                this.m_93228_(poseStack, x, y, 106, 240, energy, 14);
                break;
            }
            case 2: {
                if (energy < 14) {
                    this.m_93228_(poseStack, x + energy, y, 121 + energy, 240, 14 - energy, 14);
                }
                if (energy <= 0) break;
                this.m_93228_(poseStack, x, y, 136, 240, energy, 14);
                break;
            }
            default: {
                if (energy < 14) {
                    this.m_93228_(poseStack, x, y, 1, 240, 14, 14 - energy);
                }
                if (energy <= 0) break;
                this.m_93228_(poseStack, x, y + (14 - energy), 16, 240 + (14 - energy), 14, energy);
            }
        }
    }

    public void drawFuel(PoseStack poseStack, int x, int y, int fuel) {
        if (fuel < 14) {
            this.m_93228_(poseStack, x, y, 31, 240, 14, 14 - fuel);
        }
        if (fuel > 0) {
            this.m_93228_(poseStack, x, y + (14 - fuel), 46, 240 + (14 - fuel), 14, fuel);
        }
    }

    public void drawSun(PoseStack poseStack, int x, int y, int fuel) {
        if (fuel < 14) {
            this.m_93228_(poseStack, x, y, 61, 240, 14, 14 - fuel);
        }
        if (fuel > 0) {
            this.m_93228_(poseStack, x, y + (14 - fuel), 76, 240 + (14 - fuel), 14, fuel);
        }
    }

    public void drawSlot(PoseStack poseStack, int x, int y) {
        this.m_93228_(poseStack, x, y, 1, 167, 18, 18);
    }

    public void drawLockedSlot(PoseStack poseStack, int x, int y) {
        this.m_93228_(poseStack, x, y, 20, 167, 18, 18);
    }

    public void drawLargeSlot(PoseStack poseStack, int x, int y) {
        this.m_93228_(poseStack, x, y, 1, 186, 26, 26);
    }

    public void drawCombinedSlot(PoseStack poseStack, int x, int y) {
        this.m_93228_(poseStack, x, y, 1, 213, 47, 26);
    }

    public void drawTank(PoseStack poseStack, int x, int y, FluidStack fluid, int capacity) {
        this.m_93228_(poseStack, x, y, 49, 167, 18, 54);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        double d = (double)fluid.getAmount() / (double)capacity;
        int h = Mth.m_14165_((double)(d * 52.0));
        if (h > 0) {
            IClientFluidTypeExtensions renderProps = IClientFluidTypeExtensions.of((FluidType)fluid.getFluid().getFluidType());
            TextureAtlasSprite sprite = (TextureAtlasSprite)this.f_96541_.m_91258_(TextureAtlas.f_118259_).apply(renderProps.getStillTexture(fluid));
            int color = renderProps.getTintColor(fluid);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color >> 0 & 0xFF;
            float u0 = sprite.m_118409_();
            float v0 = sprite.m_118411_();
            float u1 = sprite.m_118410_();
            float v1 = sprite.m_118412_();
            Matrix4f m = poseStack.m_85850_().m_85861_();
            BufferBuilder lv = Tesselator.m_85913_().m_85915_();
            RenderSystem.m_157427_(GameRenderer::m_172814_);
            lv.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            lv.m_85982_(m, (float)x + 1.0f, (float)y + 53.0f - (float)h, 0.0f).m_6122_(r, g, b, 255).m_7421_(u0, v0).m_5752_();
            lv.m_85982_(m, (float)x + 1.0f, (float)y + 53.0f, 0.0f).m_6122_(r, g, b, 255).m_7421_(u0, v1).m_5752_();
            lv.m_85982_(m, (float)x + 17.0f, (float)y + 53.0f, 0.0f).m_6122_(r, g, b, 255).m_7421_(u1, v1).m_5752_();
            lv.m_85982_(m, (float)x + 17.0f, (float)y + 53.0f - (float)h, 0.0f).m_6122_(r, g, b, 255).m_7421_(u1, v0).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)lv.m_231175_());
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)BASE_TEXTURE);
        this.m_93228_(poseStack, x, y, 68, 167, 18, 54);
    }

    public void drawFluidSlot(PoseStack poseStack, int x, int y, FluidStack fluid) {
        this.drawSlot(poseStack, x, y);
        if (!fluid.isEmpty()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            IClientFluidTypeExtensions renderProps = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
            TextureAtlasSprite sprite = (TextureAtlasSprite)this.f_96541_.m_91258_(TextureAtlas.f_118259_).apply(renderProps.getStillTexture(fluid));
            int color = renderProps.getTintColor(fluid);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color >> 0 & 0xFF;
            float u0 = sprite.m_118409_();
            float v0 = sprite.m_118411_();
            float u1 = sprite.m_118410_();
            float v1 = sprite.m_118412_();
            Matrix4f m = poseStack.m_85850_().m_85861_();
            BufferBuilder lv = Tesselator.m_85913_().m_85915_();
            RenderSystem.m_157427_(GameRenderer::m_172814_);
            lv.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            lv.m_85982_(m, (float)x + 1.0f, (float)y + 1.0f, 0.0f).m_6122_(r, g, b, 255).m_7421_(u0, v0).m_5752_();
            lv.m_85982_(m, (float)x + 1.0f, (float)y + 17.0f, 0.0f).m_6122_(r, g, b, 255).m_7421_(u0, v1).m_5752_();
            lv.m_85982_(m, (float)x + 17.0f, (float)y + 17.0f, 0.0f).m_6122_(r, g, b, 255).m_7421_(u1, v1).m_5752_();
            lv.m_85982_(m, (float)x + 17.0f, (float)y + 1.0f, 0.0f).m_6122_(r, g, b, 255).m_7421_(u1, v0).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)lv.m_231175_());
            RenderSystem.m_157456_((int)0, (ResourceLocation)BASE_TEXTURE);
        }
    }

    public void drawProgressBar(PoseStack poseStack, int x, int y, int progress) {
        if (progress < 26) {
            this.m_93228_(poseStack, x + progress, y, 87 + progress, 203, 26 - progress, 3);
        }
        if (progress > 0) {
            this.m_93228_(poseStack, x, y, 87, 207, progress, 3);
        }
    }

    public void drawArrowDown(PoseStack poseStack, int x, int y) {
        this.m_93228_(poseStack, x, y, 112, 186, 14, 14);
    }

    public void drawButtonPause(PoseStack poseStack, int x, int y) {
        this.m_93228_(poseStack, x, y, 112, 167, 18, 18);
    }

    public void drawButtonStart(PoseStack poseStack, int x, int y) {
        this.m_93228_(poseStack, x, y, 131, 167, 18, 18);
    }

    public void drawButtonFrame(PoseStack poseStack, int x, int y) {
        this.m_93228_(poseStack, x, y, 150, 167, 18, 18);
    }

    public void drawPauseButton(PoseStack poseStack, int x, int y, int mouseX, int mouseY, boolean paused) {
        if (paused) {
            this.drawButtonStart(poseStack, x, y);
        } else {
            this.drawButtonPause(poseStack, x, y);
        }
        if (ElectricBlockScreen.isIn(mouseX, mouseY, x, y, 18, 18)) {
            this.drawButtonFrame(poseStack, x, y);
        }
    }

    public void drawSmallButtonPause(PoseStack poseStack, int x, int y) {
        this.m_93228_(poseStack, x, y, 114, 201, 9, 10);
    }

    public void drawSmallButtonStart(PoseStack poseStack, int x, int y) {
        this.m_93228_(poseStack, x, y, 124, 201, 9, 10);
    }

    public void drawSmallButtonFrame(PoseStack poseStack, int x, int y) {
        this.m_93228_(poseStack, x, y, 134, 201, 9, 10);
    }

    public void drawSmallButtonQuestion(PoseStack poseStack, int x, int y) {
        this.m_93228_(poseStack, x, y, 144, 201, 9, 10);
    }

    public void drawSmallButtonRedstoneDisabled(PoseStack poseStack, int x, int y) {
        this.m_93228_(poseStack, x, y, 154, 201, 9, 10);
    }

    public void drawSmallButtonRedstoneEnabled(PoseStack poseStack, int x, int y) {
        this.m_93228_(poseStack, x, y, 164, 201, 9, 10);
    }

    public void drawSmallPauseButton(PoseStack poseStack, int x, int y, int mouseX, int mouseY, boolean paused) {
        if (paused) {
            this.drawSmallButtonStart(poseStack, x, y);
        } else {
            this.drawSmallButtonPause(poseStack, x, y);
        }
        if (ElectricBlockScreen.isIn(mouseX, mouseY, x, y, 9, 10)) {
            this.drawSmallButtonFrame(poseStack, x, y);
        }
    }

    public void drawSmallRedstoneButton(PoseStack poseStack, int x, int y, int mouseX, int mouseY, boolean allowRedstoneControl) {
        if (allowRedstoneControl) {
            this.drawSmallButtonRedstoneEnabled(poseStack, x, y);
        } else {
            this.drawSmallButtonRedstoneDisabled(poseStack, x, y);
        }
        if (ElectricBlockScreen.isIn(mouseX, mouseY, x, y, 9, 10)) {
            this.drawSmallButtonFrame(poseStack, x, y);
        }
    }

    public void drawSmallQuestionButton(PoseStack poseStack, int x, int y, int mouseX, int mouseY) {
        this.drawSmallButtonQuestion(poseStack, x, y);
        if (ElectricBlockScreen.isIn(mouseX, mouseY, x, y, 9, 10)) {
            this.drawSmallButtonFrame(poseStack, x, y);
        }
    }

    public void drawNuclearBar(PoseStack poseStack, int x, int y, boolean active) {
        this.m_93228_(poseStack, x, y, 87, 218, 54, 10);
        if (active) {
            this.m_93228_(poseStack, x, y, 87, 229, 54, 10);
        }
    }

    public void drawHeatBar(PoseStack poseStack, int x, int y, float heat) {
        this.m_93228_(poseStack, x, y, 142, 218, 54, 10);
        if (heat > 0.0f) {
            this.m_93228_(poseStack, x + 1, y, 143, 229, Mth.m_14167_((float)(heat * 52.0f)), 10);
        }
    }

    public ResourceLocation getScreenTexture() {
        return BASE_TEXTURE;
    }

    protected void m_7286_(PoseStack poseStack, float delta, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69453_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getScreenTexture());
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BASE_TEXTURE);
        if (this.energyX != -1 && this.energyY != -1) {
            int e = Mth.m_14165_((double)(((ElectricBlockMenu)this.f_97732_).data.get(SyncedData.ENERGY) * 14.0 / ((ElectricBlockMenu)this.f_97732_).data.get(SyncedData.ENERGY_CAPACITY)));
            this.drawEnergy(poseStack, this.f_97735_ + this.energyX, this.f_97736_ + this.energyY, e);
        }
    }
}

