/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import dev.ftb.mods.ftbic.block.ElectricBlock;
import dev.ftb.mods.ftbic.block.entity.machine.DiggingBaseBlockEntity;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;

public class DiggingBlockRenderer
implements BlockEntityRenderer<DiggingBaseBlockEntity> {
    private static final ResourceLocation QUARRY_FRAME_TEXTURE = new ResourceLocation("ftbic", "textures/block/quarry_frame.png");
    private static final ResourceLocation QUARRY_MODEL_LIGHT_TEXTURE = new ResourceLocation("ftbic", "textures/block/quarry_model_light.png");
    private static final ResourceLocation QUARRY_MODEL_DARK_TEXTURE = new ResourceLocation("ftbic", "textures/block/quarry_model_dark.png");
    private final ModelPart quarryFrameWE;
    private final ModelPart quarryFrameSN;
    private final ModelPart quarryFrameW;
    private final ModelPart quarryFrameE;
    private final ModelPart quarryFrameS;
    private final ModelPart quarryFrameN;
    private final ModelPart quarryBar;
    private final ModelPart quarryBarEnd;
    private final ModelPart quarryHead;

    private static ModelPart make(BlockEntityRendererProvider.Context context, int tw, int th, int tx, int ty, float x, float y, float z, float w, float h, float d) {
        return new ModelPart(List.of(new ModelPart.Cube(tx, ty, x, y, z, w, h, d, 0.0f, 0.0f, 0.0f, false, (float)tw, (float)th)), Collections.emptyMap());
    }

    public DiggingBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.quarryFrameWE = DiggingBlockRenderer.make(context, 64, 32, 0, 0, -8.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f);
        this.quarryFrameSN = DiggingBlockRenderer.make(context, 64, 32, 22, 2, -1.0f, -1.0f, -8.0f, 2.0f, 2.0f, 16.0f);
        this.quarryFrameW = DiggingBlockRenderer.make(context, 64, 32, 0, 10, -8.0f, -1.0f, -1.0f, 7.0f, 2.0f, 2.0f);
        this.quarryFrameE = DiggingBlockRenderer.make(context, 64, 32, 0, 5, 1.0f, -1.0f, -1.0f, 7.0f, 2.0f, 2.0f);
        this.quarryFrameS = DiggingBlockRenderer.make(context, 64, 32, 19, 5, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, 7.0f);
        this.quarryFrameN = DiggingBlockRenderer.make(context, 64, 32, 44, 5, -1.0f, -1.0f, -8.0f, 2.0f, 2.0f, 7.0f);
        this.quarryBar = DiggingBlockRenderer.make(context, 64, 16, 0, 0, -8.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f);
        this.quarryBarEnd = DiggingBlockRenderer.make(context, 64, 16, 0, 10, -1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f);
        this.quarryHead = DiggingBlockRenderer.make(context, 64, 16, 32, 0, -4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);
    }

    private int getLight(DiggingBaseBlockEntity entity, BlockPos.MutableBlockPos pos, double x, double y, double z) {
        Level level = entity.m_58904_();
        if (level == null) {
            return 0;
        }
        pos.m_122169_((double)entity.m_58899_().m_123341_() + x, (double)entity.m_58899_().m_123342_() + y, (double)entity.m_58899_().m_123343_() + z);
        return LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    public void render(DiggingBaseBlockEntity entity, float delta, PoseStack matrices, MultiBufferSource source, int light1, int overlay) {
        VertexConsumer frameConsumer = source.m_6299_(RenderType.m_110452_((ResourceLocation)QUARRY_FRAME_TEXTURE));
        BlockPos.MutableBlockPos lpos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < entity.sizeX; ++x) {
            matrices.m_85836_();
            matrices.m_85837_((double)(entity.offsetX + x) + 0.5, 0.5, (double)entity.offsetZ - 0.5);
            this.quarryFrameWE.m_104301_(matrices, frameConsumer, this.getLight(entity, lpos, entity.offsetX + x, 0.5, (double)entity.offsetZ - 0.5), overlay);
            matrices.m_85849_();
            matrices.m_85836_();
            matrices.m_85837_((double)(entity.offsetX + x) + 0.5, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ);
            this.quarryFrameWE.m_104301_(matrices, frameConsumer, this.getLight(entity, lpos, entity.offsetX + x, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ), overlay);
            matrices.m_85849_();
        }
        for (int z = 0; z < entity.sizeZ; ++z) {
            matrices.m_85836_();
            matrices.m_85837_((double)entity.offsetX - 0.5, 0.5, (double)(entity.offsetZ + z) + 0.5);
            this.quarryFrameSN.m_104301_(matrices, frameConsumer, this.getLight(entity, lpos, (double)entity.offsetX - 0.5, 0.5, entity.offsetZ + z), overlay);
            matrices.m_85849_();
            matrices.m_85836_();
            matrices.m_85837_((double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, (double)(entity.offsetZ + z) + 0.5);
            this.quarryFrameSN.m_104301_(matrices, frameConsumer, this.getLight(entity, lpos, (double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, entity.offsetZ + z), overlay);
            matrices.m_85849_();
        }
        int lightNW = this.getLight(entity, lpos, (double)entity.offsetX - 0.5, 0.5, (double)entity.offsetZ - 0.5);
        int lightNE = this.getLight(entity, lpos, (double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, (double)entity.offsetZ - 0.5);
        int lightSW = this.getLight(entity, lpos, (double)entity.offsetX - 0.5, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ);
        int lightSE = this.getLight(entity, lpos, (double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ);
        matrices.m_85836_();
        matrices.m_85837_((double)entity.offsetX - 0.5, 0.5, (double)entity.offsetZ - 0.5);
        this.quarryFrameS.m_104301_(matrices, frameConsumer, lightNW, overlay);
        this.quarryFrameE.m_104301_(matrices, frameConsumer, lightNW, overlay);
        matrices.m_85849_();
        matrices.m_85836_();
        matrices.m_85837_((double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, (double)entity.offsetZ - 0.5);
        this.quarryFrameS.m_104301_(matrices, frameConsumer, lightNE, overlay);
        this.quarryFrameW.m_104301_(matrices, frameConsumer, lightNE, overlay);
        matrices.m_85849_();
        matrices.m_85836_();
        matrices.m_85837_((double)entity.offsetX - 0.5, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ);
        this.quarryFrameN.m_104301_(matrices, frameConsumer, lightSW, overlay);
        this.quarryFrameE.m_104301_(matrices, frameConsumer, lightSW, overlay);
        matrices.m_85849_();
        matrices.m_85836_();
        matrices.m_85837_((double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ);
        this.quarryFrameN.m_104301_(matrices, frameConsumer, lightSE, overlay);
        this.quarryFrameW.m_104301_(matrices, frameConsumer, lightSE, overlay);
        matrices.m_85849_();
        VertexConsumer modelConsumer = source.m_6299_(RenderType.m_110452_((ResourceLocation)((Boolean)entity.m_58900_().m_61143_((Property)ElectricBlock.DARK) != false ? QUARRY_MODEL_DARK_TEXTURE : QUARRY_MODEL_LIGHT_TEXTURE)));
        matrices.m_85836_();
        matrices.m_85837_((double)entity.offsetX - 0.5, 0.5, (double)entity.offsetZ - 0.5);
        this.quarryBarEnd.m_104301_(matrices, frameConsumer, lightNW, overlay);
        matrices.m_85849_();
        matrices.m_85836_();
        matrices.m_85837_((double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, (double)entity.offsetZ - 0.5);
        this.quarryBarEnd.m_104301_(matrices, frameConsumer, lightNE, overlay);
        matrices.m_85849_();
        matrices.m_85836_();
        matrices.m_85837_((double)entity.offsetX - 0.5, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ);
        this.quarryBarEnd.m_104301_(matrices, frameConsumer, lightSW, overlay);
        matrices.m_85849_();
        matrices.m_85836_();
        matrices.m_85837_((double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ);
        this.quarryBarEnd.m_104301_(matrices, frameConsumer, lightSE, overlay);
        matrices.m_85849_();
        float lx = Mth.m_14179_((float)delta, (float)entity.prevLaserX, (float)entity.laserX);
        float ly = entity.laserY - entity.m_58899_().m_123342_();
        float lz = Mth.m_14179_((float)delta, (float)entity.prevLaserZ, (float)entity.laserZ);
        int headLight = this.getLight(entity, lpos, lx, 0.5, lz);
        matrices.m_85836_();
        matrices.m_85837_((double)lx, 0.5, (double)lz);
        this.quarryHead.m_104301_(matrices, modelConsumer, headLight, overlay);
        matrices.m_85849_();
        this.quarryBar.f_104204_ = 0.0f;
        for (int x = 0; x <= entity.sizeX; ++x) {
            matrices.m_85836_();
            matrices.m_85837_((double)(entity.offsetX + x), 0.5, (double)lz);
            this.quarryBar.m_104301_(matrices, modelConsumer, headLight, overlay);
            matrices.m_85849_();
        }
        this.quarryBar.f_104204_ = 1.5707964f;
        for (int z = 0; z <= entity.sizeZ; ++z) {
            matrices.m_85836_();
            matrices.m_85837_((double)lx, 0.5, (double)(entity.offsetZ + z));
            this.quarryBar.m_104301_(matrices, modelConsumer, headLight, overlay);
            matrices.m_85849_();
        }
        matrices.m_85836_();
        matrices.m_85837_((double)entity.offsetX - 0.5, 0.5, (double)lz);
        this.quarryBarEnd.m_104301_(matrices, modelConsumer, this.getLight(entity, lpos, (double)entity.offsetX - 0.5, 0.5, lz), overlay);
        matrices.m_85849_();
        matrices.m_85836_();
        matrices.m_85837_((double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, (double)lz);
        this.quarryBarEnd.m_104301_(matrices, modelConsumer, this.getLight(entity, lpos, (double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, lz), overlay);
        matrices.m_85849_();
        matrices.m_85836_();
        matrices.m_85837_((double)lx, 0.5, (double)entity.offsetZ - 0.5);
        this.quarryBarEnd.m_104301_(matrices, modelConsumer, this.getLight(entity, lpos, lx, 0.5, (double)entity.offsetZ - 0.5), overlay);
        matrices.m_85849_();
        matrices.m_85836_();
        matrices.m_85837_((double)lx, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ);
        this.quarryBarEnd.m_104301_(matrices, modelConsumer, this.getLight(entity, lpos, lx, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ), overlay);
        matrices.m_85849_();
        if (!entity.paused) {
            matrices.m_85836_();
            matrices.m_85837_((double)lx, (double)ly, (double)lz);
            DiggingBlockRenderer.renderBeaconBeam(matrices, source, delta, 1.0f, entity.m_58904_().m_46467_(), 0, -ly + 0.5f, entity.getLaserColor(), 0.2f, 0.25f);
            matrices.m_85849_();
        }
    }

    public static void renderBeaconBeam(PoseStack matrices, MultiBufferSource source, float delta, float g, long tick, int y, float height, float[] color, float h, float k) {
        float m = (float)y + height;
        matrices.m_85836_();
        float n = (float)Math.floorMod(-tick, 40L) + delta;
        float p = Mth.m_14187_((float)(n * 0.2f - (float)Mth.m_14143_((float)(n * 0.1f))));
        float q = color[0];
        float r = color[1];
        float s = color[2];
        matrices.m_85836_();
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(45.0f));
        float aj = -h;
        float aa = -h;
        float ap = -1.0f + p;
        float aq = height * g * (0.5f / h) + ap;
        DiggingBlockRenderer.renderPart(matrices, source.m_6299_(RenderType.m_110460_((ResourceLocation)BeaconRenderer.f_112102_, (boolean)false)), q, r, s, 1.0f, y, m, 0.0f, h, h, 0.0f, aj, 0.0f, 0.0f, aa, 0.0f, 1.0f, aq, ap);
        matrices.m_85849_();
        float af = -k;
        float ag = -k;
        float ai = -k;
        aj = -k;
        ap = -1.0f + p;
        aq = height * g + ap;
        DiggingBlockRenderer.renderPart(matrices, source.m_6299_(RenderType.m_110460_((ResourceLocation)BeaconRenderer.f_112102_, (boolean)true)), q, r, s, 0.125f, y, m, af, ag, k, ai, aj, k, k, k, 0.0f, 1.0f, aq, ap);
        matrices.m_85849_();
    }

    private static void renderPart(PoseStack matrices, VertexConsumer consumer, float f, float g, float h, float i, float j, float k, float l, float m, float n, float o, float p, float q, float r, float s, float t, float u, float v, float w) {
        PoseStack.Pose lv = matrices.m_85850_();
        Matrix4f mp = lv.m_85861_();
        Matrix3f mn = lv.m_85864_();
        DiggingBlockRenderer.renderQuad(mp, mn, consumer, f, g, h, i, j, k, l, m, n, o, t, u, v, w);
        DiggingBlockRenderer.renderQuad(mp, mn, consumer, f, g, h, i, j, k, r, s, p, q, t, u, v, w);
        DiggingBlockRenderer.renderQuad(mp, mn, consumer, f, g, h, i, j, k, n, o, r, s, t, u, v, w);
        DiggingBlockRenderer.renderQuad(mp, mn, consumer, f, g, h, i, j, k, p, q, l, m, t, u, v, w);
    }

    private static void renderQuad(Matrix4f mp, Matrix3f mn, VertexConsumer consumer, float f, float g, float h, float i, float j, float k, float l, float m, float n, float o, float p, float q, float r, float s) {
        DiggingBlockRenderer.addVertex(mp, mn, consumer, f, g, h, i, k, l, m, q, r);
        DiggingBlockRenderer.addVertex(mp, mn, consumer, f, g, h, i, j, l, m, q, s);
        DiggingBlockRenderer.addVertex(mp, mn, consumer, f, g, h, i, j, n, o, p, s);
        DiggingBlockRenderer.addVertex(mp, mn, consumer, f, g, h, i, k, n, o, p, r);
    }

    private static void addVertex(Matrix4f arg, Matrix3f arg2, VertexConsumer arg3, float f, float g, float h, float i, float j, float k, float l, float m, float n) {
        arg3.m_85982_(arg, k, j, l).m_85950_(f, g, h, i).m_7421_(m, n).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(arg2, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public boolean shouldRenderOffScreen(DiggingBaseBlockEntity entity) {
        return true;
    }

    public int m_142163_() {
        return 256;
    }
}

