/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbchunks.client.EntityIcons;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.MapType;
import dev.ftb.mods.ftbchunks.integration.MapIcon;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class EntityMapIcon
extends MapIcon {
    public final Entity entity;
    public final Icon icon;

    public EntityMapIcon(Entity e, Icon i) {
        this.entity = e;
        this.icon = i;
    }

    @Override
    public Vec3 getPos(float delta) {
        if (delta >= 1.0f) {
            return this.entity.m_20182_();
        }
        return this.entity.m_20318_(delta);
    }

    @Override
    public boolean isVisible(MapType mapType, double distanceToPlayer, boolean outsideVisibleArea) {
        return !mapType.isWorldIcon() && (this.entity instanceof AbstractClientPlayer || !outsideVisibleArea);
    }

    @Override
    public double getIconScale(MapType mapType) {
        return this.entity instanceof AbstractClientPlayer || !mapType.isMinimap() || (Boolean)FTBChunksClientConfig.MINIMAP_LARGE_ENTITIES.get() != false ? 1.0 : 0.6666666666666666;
    }

    @Override
    public boolean isZoomDependant(MapType mapType) {
        return !(this.entity instanceof AbstractClientPlayer);
    }

    @Override
    public int getPriority() {
        return this.entity instanceof LocalPlayer ? 150 : (this.entity instanceof AbstractClientPlayer ? 100 : 0);
    }

    @Override
    public void addTooltip(TooltipList list) {
        list.add(this.entity.m_7755_());
    }

    @Override
    public boolean keyPressed(LargeMapScreen screen, Key key) {
        if (this.entity instanceof LocalPlayer) {
            return false;
        }
        return super.keyPressed(screen, key);
    }

    @Override
    public void draw(MapType mapType, PoseStack stack, int x, int y, int w, int h, boolean outsideVisibleArea, int iconAlpha) {
        if (this.icon instanceof ImageIcon) {
            TextureManager manager = Minecraft.m_91087_().m_91097_();
            AbstractTexture tex = manager.m_118506_(((ImageIcon)this.icon).texture);
            if (tex == null) {
                tex = new SimpleTexture(((ImageIcon)this.icon).texture);
                manager.m_118495_(((ImageIcon)this.icon).texture, tex);
            }
            RenderSystem.m_157184_((int)tex.m_117963_());
            RenderSystem.m_69937_((int)3553, (int)10241, (int)(w > 4 ? 9728 : 9729));
            RenderSystem.m_69937_((int)3553, (int)10240, (int)(w > 4 ? 9728 : 9729));
        }
        if (!(this.entity instanceof AbstractClientPlayer) || mapType.isMinimap() || w < 4 || this.icon == EntityIcons.NORMAL || this.icon == EntityIcons.HOSTILE) {
            this.icon.draw(stack, x, y, w, h);
        } else {
            stack.m_85836_();
            stack.m_85837_((double)x, (double)y, 0.0);
            stack.m_85841_((float)w / 18.0f, (float)h / 18.0f, 1.0f);
            Color4I.BLACK.draw(stack, 0, 0, 18, 18);
            this.icon.draw(stack, 1, 1, 16, 16);
            stack.m_85849_();
        }
    }
}

