/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.mixins;

import com.leobeliik.extremesoundmuffler.CommonConfig;
import com.leobeliik.extremesoundmuffler.gui.MufflerScreen;
import com.leobeliik.extremesoundmuffler.gui.buttons.PlaySoundButton;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SoundEngine.class})
public abstract class SoundMixin
implements ISoundLists {
    @Unique
    @Nullable
    private SoundInstance esmSound;

    @Inject(at={@At(value="HEAD")}, method={"calculateVolume(Lnet/minecraft/client/resources/sounds/SoundInstance;)F"})
    private void esm_captureSoundVolume(SoundInstance sound, CallbackInfoReturnable<Float> cir) {
        this.esmSound = sound;
    }

    @Inject(at={@At(value="HEAD")}, method={"play"})
    private void esm_captureTickableSoundVolume(SoundInstance sound, CallbackInfo ci) {
        this.esmSound = sound;
    }

    @ModifyArg(index=0, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(FFF)F"), method={"calculateVolume(FLnet/minecraft/sounds/SoundSource;)F"})
    private float esm_setVolume(float volume) {
        SoundInstance tempSound = this.esmSound;
        if (tempSound != null && !SoundMixin.esm_isForbidden(tempSound) && !PlaySoundButton.isFromPSB()) {
            recentSoundsList.add(tempSound.m_7904_());
            if (MufflerScreen.isMuffling()) {
                Anchor anchor;
                if (muffledSounds.containsKey(tempSound.m_7904_())) {
                    return (float)((double)tempSound.m_7769_() * (Double)muffledSounds.get(tempSound.m_7904_()));
                }
                if (!(CommonConfig.get() != null && CommonConfig.get().disableAnchors().get().booleanValue() || (anchor = Anchor.getAnchor(tempSound)) == null)) {
                    return (float)((double)tempSound.m_7769_() * (Double)anchor.getMuffledSounds().get(tempSound.m_7904_()));
                }
            }
        }
        return volume;
    }

    @Inject(at={@At(value="RETURN")}, method={"calculateVolume(Lnet/minecraft/client/resources/sounds/SoundInstance;)F"})
    private void esm_clearTickableSound(SoundInstance sound, CallbackInfoReturnable<Float> cir) {
        this.esmSound = null;
    }

    @Inject(at={@At(value="RETURN")}, method={"play"})
    private void esm_clearSound(SoundInstance sound, CallbackInfo ci) {
        this.esmSound = null;
    }

    @Unique
    private static boolean esm_isForbidden(SoundInstance sound) {
        return forbiddenSounds.stream().anyMatch(fs -> sound.m_7904_().toString().contains((CharSequence)fs));
    }
}

