/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.network.packets;

import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.meter.MeterEntity;
import com.github.almostreliable.energymeter.network.ClientToServerPacket;
import com.github.almostreliable.energymeter.util.TypeEnums;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;

public class IOUpdatePacket
extends ClientToServerPacket<IOUpdatePacket> {
    private TypeEnums.BLOCK_SIDE side;
    private TypeEnums.IO_SETTING setting;

    public IOUpdatePacket(TypeEnums.BLOCK_SIDE side, TypeEnums.IO_SETTING setting) {
        this.side = side;
        this.setting = setting;
    }

    public IOUpdatePacket() {
    }

    @Override
    public void encode(IOUpdatePacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.side.ordinal());
        buffer.writeInt(packet.setting.ordinal());
    }

    @Override
    public IOUpdatePacket decode(FriendlyByteBuf buffer) {
        return new IOUpdatePacket(TypeEnums.BLOCK_SIDE.values()[buffer.readInt()], TypeEnums.IO_SETTING.values()[buffer.readInt()]);
    }

    @Override
    public void handlePacket(IOUpdatePacket packet, @Nullable ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.f_36096_) instanceof MeterContainer) {
            MeterContainer menu = (MeterContainer)abstractContainerMenu;
            MeterEntity entity = menu.getEntity();
            Level level = entity.m_58904_();
            if (level == null || !level.m_46749_(entity.m_58899_())) {
                return;
            }
            entity.getSideConfig().set(packet.side, packet.setting);
            entity.updateNeighbors();
            entity.updateCache(entity.getSideConfig().getDirectionFromSide(packet.side));
            entity.syncData(1);
            entity.m_6596_();
        }
    }
}

