/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.theoneprobe;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.core.client.GuiFunctions;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class OneProbeDataProvider
implements IProbeInfoProvider {
    static final OneProbeDataProvider INSTANCE = new OneProbeDataProvider();
    private static final ResourceLocation INFO_PROVIDER_ID = new ResourceLocation("endertanks", "default");
    private static final ResourceLocation ELEMENT_ID = new ResourceLocation("endertanks", "element");

    public ResourceLocation getID() {
        return INFO_PROVIDER_ID;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        BlockEntity tile;
        if (blockState.m_60734_() instanceof BlockEnderTank && (tile = world.m_7702_(data.getPos())) instanceof TileEntityEnderTank) {
            probeInfo.element((IElement)new ElementTankInfo((TileEntityEnderTank)tile, !mode.equals((Object)ProbeMode.NORMAL)));
        }
    }

    private static class ElementTankInfo
    implements IElement {
        static final ResourceLocation COMPARATOR = new ResourceLocation("textures/item/comparator.png");
        final CompoundTag data;
        final List<Component> lines = new ArrayList<Component>();
        private boolean renderIcon;

        private ElementTankInfo(TileEntityEnderTank tank, boolean showDetails) {
            this.data = new CompoundTag();
            this.data.m_128365_("basic", (Tag)TankInfoHelper.packHUDBasic(tank));
            if (showDetails) {
                this.data.m_128365_("contents", (Tag)TankInfoHelper.packHUDContents(tank));
                this.data.m_128365_("status", (Tag)TankInfoHelper.packHUDStatus(tank));
            }
        }

        private ElementTankInfo(CompoundTag data) {
            if (data == null || data.m_128456_()) {
                this.data = new CompoundTag();
                return;
            }
            this.data = data;
            if (data.m_128441_("basic")) {
                TankInfoHelper.unpackHUDInfo(this.lines, data.m_128437_("basic", 8));
            }
            if (data.m_128441_("contents")) {
                TankInfoHelper.unpackHUDInfo(this.lines, data.m_128437_("contents", 8));
            }
            if (data.m_128441_("status")) {
                this.renderIcon = true;
                TankInfoHelper.unpackHUDInfo(this.lines, data.m_128437_("status", 8));
            }
        }

        public void render(PoseStack matrixStack, int x, int y) {
            int indent = this.lines.size() - 1;
            int counter = 0;
            for (Component line : this.lines) {
                ElementTextRender.render((Component)line, (PoseStack)matrixStack, (int)(counter < indent ? x : x + 10), (int)y);
                y += 10;
                ++counter;
            }
            if (this.renderIcon) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)COMPARATOR);
                GuiFunctions.drawTextureScaled((PoseStack)matrixStack, (double)(x + 3), (double)(y - 10), (int)0, (int)0, (int)16, (int)16, (double)0.5, (float)1.0f, (int[])new int[]{16, 16});
            }
        }

        public int getWidth() {
            int width = 0;
            for (Component line : this.lines) {
                width = Math.max(width, ElementTextRender.getWidth((Component)line));
            }
            return width;
        }

        public int getHeight() {
            return 10 + (this.lines.size() - 1) * 10;
        }

        public void toBytes(FriendlyByteBuf buffer) {
            buffer.m_130079_(this.data);
        }

        public ResourceLocation getID() {
            return ELEMENT_ID;
        }
    }

    static class ElementFactoryTankInfo
    implements IElementFactory {
        ElementFactoryTankInfo() {
        }

        public IElement createElement(FriendlyByteBuf buffer) {
            return new ElementTankInfo(buffer.m_130260_());
        }

        public ResourceLocation getId() {
            return ELEMENT_ID;
        }
    }
}

