/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Function;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.item.ItemEnderBucket;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class EventHandler {
    @SubscribeEvent
    public void worldSave(LevelEvent.Save event) {
        TankHelper.INSTANCE.saveTankData(event);
    }

    @SubscribeEvent
    public void tagsUpdatedEvent(TagsUpdatedEvent event) {
        Configuration.CAN_PROCESS_TAGS = true;
        Configuration.processTagLists();
    }

    @SubscribeEvent
    public void playerRightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack;
        BlockEntity blockEntity;
        Player player = event.getEntity();
        if (player == null || !player.m_6047_()) {
            return;
        }
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if (player.m_21205_().m_41619_() && player.m_21206_().m_150930_(Items.f_42351_) && (blockEntity = level.m_7702_(pos)) instanceof TileEntityEnderTank) {
            TileEntityEnderTank tile = (TileEntityEnderTank)blockEntity;
            if (!level.m_5776_() && tile.lastClick <= System.currentTimeMillis()) {
                tile.lastClick = System.currentTimeMillis() + 200L;
                if (tile.compareNextHandler(player)) {
                    level.m_46672_(tile.m_58899_(), tile.m_58900_().m_60734_());
                    Function.syncTile((BlockEntity)tile);
                }
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
        if ((stack = event.getItemStack()).m_41619_() || stack.m_41720_() instanceof ItemEnderBucket) {
            return;
        }
        BlockState state = level.m_8055_(event.getPos());
        Block block = state.m_60734_();
        if (block instanceof BlockEnderTank && this.isUpgrade(stack.m_41720_()) && ((BlockEnderTank)block).onBlockActivated(state, level, pos, player, event.getHand(), stack, event.getFace()) == InteractionResult.SUCCESS) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    private boolean isUpgrade(Item item) {
        return Values.listPersonal.contains(item) || Values.listTeam.contains(item) || Values.listSmallCap_Single.contains(item) || Values.listSmallCap_Multi.contains(item) || Values.listLargeCap_Single.contains(item) || Values.listLargeCap_Multi.contains(item) || Values.listPump_Single.contains(item) || Values.listPump_Multi.contains(item) || DyeHelper.getDyeColor((Item)item) != null;
    }
}

