/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import shetiphian.endertanks.Roster;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.mixins.EnderTanks_Accessor;

public class CauldronHelper {
    public static void register() {
        CauldronInteraction.f_175606_.put((Item)Roster.Items.ENDERBUCKET.get(), (state, world, pos, player, hand, stack) -> CauldronHelper.fillCauldron(state, world, pos, player, stack, CauldronHelper.getTank(stack, world)));
        CauldronInteraction.f_175607_.put((Item)Roster.Items.ENDERBUCKET.get(), (state, world, pos, player, hand, stack) -> CauldronHelper.drainCauldron(state, world, pos, player, stack, CauldronHelper.getTank(stack, world), (Fluid)Fluids.f_76193_, (TagKey<Fluid>)FluidTags.f_13131_, Blocks.f_50256_.m_49966_(), cauldron -> cauldron.m_61138_((Property)LayeredCauldronBlock.f_153514_) && (Integer)cauldron.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3));
        CauldronInteraction.f_175608_.put((Item)Roster.Items.ENDERBUCKET.get(), (state, world, pos, player, hand, stack) -> CauldronHelper.drainCauldron(state, world, pos, player, stack, CauldronHelper.getTank(stack, world), (Fluid)Fluids.f_76195_, (TagKey<Fluid>)FluidTags.f_13132_, Blocks.f_50256_.m_49966_(), cauldron -> cauldron.m_60734_() == Blocks.f_152477_));
    }

    public static IFluidHandler getTank(ItemStack stack, Level world) {
        return TankHelper.getTank(world, StackHelper.getOwnerID(stack), StackHelper.getCode(stack)).getTankFor(IFluidHandler.class);
    }

    public static void drainCauldron(BlockState cauldron, Level world, BlockPos pos, IFluidHandler eTankHandler) {
        Block block = cauldron.m_60734_();
        if (block instanceof EnderTanks_Accessor) {
            EnderTanks_Accessor block2 = (EnderTanks_Accessor)block;
            Map<Item, CauldronInteraction> map = block2.getInteractions();
            if (CauldronInteraction.f_175607_.equals(map)) {
                CauldronHelper.drainCauldron(cauldron, world, pos, null, ItemStack.f_41583_, eTankHandler, (Fluid)Fluids.f_76193_, (TagKey<Fluid>)FluidTags.f_13131_, Blocks.f_50256_.m_49966_(), state -> state.m_61138_((Property)LayeredCauldronBlock.f_153514_) && (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3);
            } else if (CauldronInteraction.f_175608_.equals(map)) {
                CauldronHelper.drainCauldron(cauldron, world, pos, null, ItemStack.f_41583_, eTankHandler, (Fluid)Fluids.f_76195_, (TagKey<Fluid>)FluidTags.f_13132_, Blocks.f_50256_.m_49966_(), state -> state.m_60734_() == Blocks.f_152477_);
            }
        }
    }

    public static InteractionResult drainCauldron(BlockState cauldron, Level world, BlockPos pos, Player player, ItemStack stack, IFluidHandler eTankHandler, Fluid fluid, TagKey<Fluid> tag, BlockState emptyCauldron, Predicate<BlockState> isCauldronFull) {
        if (isCauldronFull.test(cauldron) && eTankHandler != null && emptyCauldron != null) {
            FluidStack fluidInTank = eTankHandler.getFluidInTank(0);
            if (eTankHandler.getTankCapacity(0) - fluidInTank.getAmount() >= 1000 && tag != null && (fluidInTank.isEmpty() || fluidInTank.getFluid().m_205067_(tag))) {
                Fluid fluid2 = fluid = !fluidInTank.isEmpty() ? fluidInTank.getFluid() : fluid;
                if (fluid != null) {
                    if (!world.m_5776_()) {
                        FluidStack fillFluid = new FluidStack(fluid, 1000);
                        world.m_46597_(pos, emptyCauldron);
                        if (player != null) {
                            player.m_36220_(Stats.f_12944_);
                            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                            world.m_5594_(null, pos, fluid.getFluidType().getSound(SoundActions.BUCKET_FILL), SoundSource.BLOCKS, 1.0f, 1.0f);
                            world.m_142346_(null, GameEvent.f_157816_, pos);
                        }
                        if (player == null || !player.m_150110_().f_35937_) {
                            eTankHandler.fill(fillFluid, IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public static void fillCauldron(BlockState cauldron, Level world, BlockPos pos, IFluidHandler eTankHandler) {
        CauldronHelper.fillCauldron(cauldron, world, pos, null, ItemStack.f_41583_, eTankHandler);
    }

    public static InteractionResult fillCauldron(BlockState cauldron, Level world, BlockPos pos, Player player, ItemStack stack, IFluidHandler eTankHandler) {
        BlockState filledCauldron;
        FluidStack fluidInTank;
        if (cauldron != null && eTankHandler != null && !(fluidInTank = eTankHandler.getFluidInTank(0)).isEmpty() && fluidInTank.getAmount() >= 1000 && (filledCauldron = CauldronHelper.getFilledCauldron(cauldron, fluidInTank.getFluid())) != null) {
            if (!world.m_5776_()) {
                world.m_46597_(pos, filledCauldron);
                if (player != null) {
                    player.m_36220_(Stats.f_12943_);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                    world.m_5594_(null, pos, fluidInTank.getFluid().getFluidType().getSound(SoundActions.BUCKET_EMPTY), SoundSource.BLOCKS, 1.0f, 1.0f);
                    world.m_142346_(null, GameEvent.f_157769_, pos);
                }
                if (player == null || !player.m_150110_().f_35937_) {
                    eTankHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static BlockState getFilledCauldron(BlockState emptyCauldron, Fluid fluid) {
        if (emptyCauldron.m_60734_() == Blocks.f_50256_) {
            if (fluid.m_205067_(FluidTags.f_13131_)) {
                return (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3));
            }
            if (fluid.m_205067_(FluidTags.f_13132_)) {
                return Blocks.f_152477_.m_49966_();
            }
        }
        return null;
    }
}

