/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.misc;

import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.player.Player;
import shetiphian.core.common.NameHelper;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class ChestInfoHelper {
    private static final Style GOLD = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GOLD));
    private static final Style GREEN = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN));
    private static final Style AQUA = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.AQUA));
    private static final Style BOLD_RED = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)).m_131136_(Boolean.valueOf(true));
    private static final MutableComponent DUMMY = Component.m_237113_((String)"");

    public static void unpackHUDInfo(List<Component> lines, ListTag listNBT) {
        listNBT.forEach(tag -> lines.add((Component)Component.Serializer.m_130701_((String)tag.m_7916_())));
    }

    public static StringTag toTag(Component entry) {
        return StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)entry));
    }

    public static ListTag packHUDBasic(TileEntityEnderChest tile) {
        ListTag listNBT = new ListTag();
        listNBT.add((Object)ChestInfoHelper.toTag((Component)ChestInfoHelper.infoChestOwner(tile.getOwnerName(), true)));
        listNBT.add((Object)ChestInfoHelper.toTag((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"info.enderchests.chest.code")).m_7220_((Component)Component.m_237113_((String)(" " + tile.getCode())))));
        return listNBT;
    }

    public static void sendCapacityInfo(Player player, TileEntityEnderChest chestTile) {
        ChestInfoHelper.sendInfo(player, Component.m_237115_((String)"info.enderchests.chest.capacity").m_130946_(" " + ChestHelper.getCapacity(player.m_9236_(), chestTile.getOwnerID(), chestTile.getCode())));
    }

    public static void sendLinkError(Player player, int error) {
        ChestInfoHelper.sendInfo(player, Component.m_237115_((String)("error.enderchests.bag.nolink" + error)).m_6270_(BOLD_RED));
    }

    public static void sendError(Player player, String error) {
        ChestInfoHelper.sendInfo(player, Component.m_237115_((String)("error." + error)).m_6270_(BOLD_RED));
    }

    public static MutableComponent infoChestOwner(String owner, boolean displayPublic) {
        if (Strings.isNullOrEmpty((String)owner) || owner.equalsIgnoreCase("all")) {
            if (displayPublic) {
                String color = "\u00a76";
                return Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)(color + "[-"))).m_7220_((Component)Component.m_237115_((String)"info.enderchests.chest.public").m_6270_(GOLD)).m_7220_((Component)Component.m_237113_((String)(color + "-]")));
            }
            return DUMMY;
        }
        boolean isTeam = owner.startsWith("#");
        String color = isTeam ? "\u00a7a" : "\u00a7b";
        return Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)(color + "[-"))).m_7220_((Component)Component.m_237113_((String)owner.substring(isTeam ? 1 : 0)).m_6270_(isTeam ? GREEN : AQUA)).m_7220_((Component)Component.m_237113_((String)(color + "-]")));
    }

    @Nullable
    public static MutableComponent formatChestOwner(String owner) {
        MutableComponent component = ChestInfoHelper.infoChestOwner(owner, false);
        return component != DUMMY ? component : null;
    }

    public static void sendInfo(Player player, MutableComponent message) {
        if (player != null) {
            player.m_5661_((Component)message, true);
        }
    }

    public static String getDisplayNameFromOwnerID(String ownerID) {
        if (Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all")) {
            return "all";
        }
        if (ownerID.startsWith("#")) {
            return "#" + NameHelper.getDisplayNameFor((String)ownerID.substring(1));
        }
        return NameHelper.getDisplayNameFor((String)ownerID);
    }
}

