/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests;

import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.client.gui.GuiEnderChest;
import shetiphian.enderchests.common.block.BlockEnderChest;
import shetiphian.enderchests.common.crafting.EnderRecipe;
import shetiphian.enderchests.common.inventory.ContainerEnderChest;
import shetiphian.enderchests.common.item.ItemBlockEnderChest;
import shetiphian.enderchests.common.item.ItemEnderBag;
import shetiphian.enderchests.common.item.ItemEnderPouch;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class Roster {
    static void setup(IEventBus eventBus) {
        Blocks.REGISTRY.register(eventBus);
        Tiles.REGISTRY.register(eventBus);
        Items.REGISTRY.register(eventBus);
        Recipes.REGISTRY.register(eventBus);
        RecipeSerializers.REGISTRY.register(eventBus);
        Containers.REGISTRY.register(eventBus);
    }

    static void process() {
        Values.tabEnderChests.setIcon(new Object[]{Blocks.ENDERCHEST.get()});
    }

    @OnlyIn(value=Dist.CLIENT)
    static void registerScreenFactories() {
        MenuScreens.m_96206_((MenuType)((MenuType)Containers.ENDER_BAG.get()), GuiEnderChest::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Containers.ENDER_CHEST.get()), GuiEnderChest::new);
    }

    public static class Blocks {
        private static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"enderchests");
        public static final RegistryObject<Block> ENDERCHEST = REGISTRY.register("ender_chest", BlockEnderChest::new);
    }

    public static class Tiles {
        private static final DeferredRegister<BlockEntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"enderchests");
        public static final RegistryObject<BlockEntityType<TileEntityEnderChest>> ENDERCHEST = REGISTRY.register("ender_chest.tile", () -> BlockEntityType.Builder.m_155273_(TileEntityEnderChest::new, (Block[])new Block[]{(Block)Blocks.ENDERCHEST.get()}).m_58966_(null));
    }

    public static class Items {
        private static final DeferredRegister<Item> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"enderchests");
        public static final RegistryObject<BlockItem> ENDERCHEST = REGISTRY.register("ender_chest", () -> new ItemBlockEnderChest((Block)Blocks.ENDERCHEST.get(), Items.stackable()));
        public static final RegistryObject<Item> ENDERBAG = REGISTRY.register("ender_bag", () -> new ItemEnderBag(Items.stackable()));
        public static final RegistryObject<Item> ENDERPOUCH = REGISTRY.register("ender_pouch", () -> new ItemEnderPouch(Items.stackable()));

        private static Item.Properties stackable() {
            return new Item.Properties().m_41491_((CreativeModeTab)Values.tabEnderChests);
        }

        private static Item.Properties singleton() {
            return Items.stackable().m_41487_(1);
        }
    }

    public static class Recipes {
        private static final DeferredRegister<RecipeType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"enderchests");
        public static final RegistryObject<RecipeType<EnderRecipe>> CRAFTING = REGISTRY.register("crafting", () -> RecipeType.simple((ResourceLocation)new ResourceLocation("enderchests:crafting")));
    }

    public static class RecipeSerializers {
        private static final DeferredRegister<RecipeSerializer<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"enderchests");
        public static final RegistryObject<RecipeSerializer<EnderRecipe>> CRAFTING = REGISTRY.register("crafting", EnderRecipe.Serializer::new);
    }

    public static class Containers {
        private static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"enderchests");
        public static final RegistryObject<MenuType<ContainerEnderChest>> ENDER_BAG = REGISTRY.register("ender_bag", () -> IForgeMenuType.create((windowId, invPlayer, data) -> {
            Level world = invPlayer.f_35978_.m_9236_();
            InventoryInternal chest = null;
            try {
                chest = ChestHelper.getChest(world, data.m_130277_(), data.m_130277_());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return chest != null ? new ContainerEnderChest(windowId, invPlayer, chest, data.m_130277_()) : null;
        }));
        public static final RegistryObject<MenuType<ContainerEnderChest>> ENDER_CHEST = REGISTRY.register("ender_chest", () -> IForgeMenuType.create((windowId, invPlayer, data) -> {
            BlockPos pos = data.m_130135_();
            Level world = invPlayer.f_35978_.m_9236_();
            BlockEntity tile = world.m_7702_(pos);
            return tile instanceof TileEntityEnderChest ? new ContainerEnderChest(windowId, invPlayer, (TileEntityEnderChest)tile) : null;
        }));
    }
}

