/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.growth;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.IPlantable;
import sirttas.elementalcraft.ElementalCraftUtils;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.tag.ECTags;

public class GrowthShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<ShrineProperties> PROPERTIES_KEY = GrowthShrineBlockEntity.createKey("growthshrine");
    private static final int MAX_TRYS = 100;
    private boolean hasStemPollination = false;

    public GrowthShrineBlockEntity(BlockPos pos, BlockState state) {
        super(ECBlockEntityTypes.GROWTH_SHRINE, pos, state, PROPERTIES_KEY);
    }

    private Optional<BlockPos> findGrowable() {
        List<BlockPos> positions = this.getBlocksInRange().filter(this::canGrow).toList();
        return positions.isEmpty() ? Optional.empty() : Optional.of(positions.get(this.f_58857_.f_46441_.m_188503_(positions.size())));
    }

    private boolean stemCanGrow(StemBlock stem, BlockPos pos) {
        if (this.hasStemPollination) {
            StemGrownBlock crop = stem.m_57056_();
            return Direction.Plane.HORIZONTAL.m_122557_().map(d -> this.f_58857_.m_8055_(pos.m_121945_(d))).noneMatch(arg_0 -> GrowthShrineBlockEntity.lambda$stemCanGrow$1((Block)crop, arg_0));
        }
        return false;
    }

    private boolean canGrow(BlockPos pos) {
        BlockState state = this.f_58857_.m_8055_(pos);
        if (this.isInBlacklist(state)) {
            return false;
        }
        Block block = state.m_60734_();
        if (block instanceof BonemealableBlock) {
            StemBlock stem;
            BonemealableBlock growable = (BonemealableBlock)block;
            return growable.m_7370_((BlockGetter)this.f_58857_, pos, state, this.f_58857_.f_46443_) && growable.m_214167_(this.f_58857_, this.f_58857_.f_46441_, pos, state) || block instanceof StemBlock && this.stemCanGrow(stem = (StemBlock)block, pos);
        }
        return false;
    }

    private boolean isInBlacklist(BlockState state) {
        return state.m_204336_(ECTags.Blocks.SHRINES_GROWTH_BLACKLIST);
    }

    private void addGrowthParticles(BlockPos pos) {
        this.f_58857_.m_46796_(2005, pos, 0);
    }

    @Override
    public AABB getRangeBoundingBox() {
        if (this.hasUpgrade(ShrineUpgrades.CRYSTAL_GROWTH)) {
            return super.getRangeBoundingBox();
        }
        float range = this.getRange();
        return ElementalCraftUtils.stitchAABB(new AABB(this.getTargetPos()).m_82377_((double)range, 0.0, (double)range).m_82363_(0.0, 2.0, 0.0));
    }

    private boolean growBoneless() {
        int consumeAmount = this.getConsumeAmount();
        List<BlockPos> positions = this.getBlocksInRange().toList();
        for (BlockPos pos : positions) {
            Block block;
            BlockState state = this.f_58857_.m_8055_(pos);
            if (this.isInBlacklist(state) || !((block = state.m_60734_()) instanceof BonemealableBlock) && !(block instanceof IPlantable) || block instanceof StemBlock || !block.m_6724_(state) || this.elementStorage.getElementAmount() < consumeAmount) continue;
            state.m_222972_((ServerLevel)this.f_58857_, pos, this.f_58857_.f_46441_);
            BlockState newState = this.f_58857_.m_8055_(pos);
            if (newState == state) continue;
            this.consumeElement(consumeAmount);
            this.addGrowthParticles(pos);
        }
        return false;
    }

    private boolean growStandard() {
        return this.findGrowable().map(p -> {
            BlockState blockstate = this.f_58857_.m_8055_(p);
            ((BonemealableBlock)blockstate.m_60734_()).m_214148_((ServerLevel)this.f_58857_, this.f_58857_.f_46441_, p, blockstate);
            this.addGrowthParticles((BlockPos)p);
            return true;
        }).orElse(false);
    }

    private boolean canClusterGrowAtState(BlockState s) {
        return BuddingAmethystBlock.m_152734_((BlockState)s) || s.m_204336_(ECTags.Blocks.BUDS);
    }

    private boolean canGrowCrystal(BlockPos pos) {
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_204336_(ECTags.Blocks.BUDDING) && state.m_60823_()) {
            for (Direction direction : Direction.values()) {
                BlockPos offset = pos.m_121945_(direction);
                BlockState s = this.f_58857_.m_8055_(offset);
                if (!this.canClusterGrowAtState(s)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean growCrystals() {
        List<BlockPos> positions = this.getBlocksInRange().filter(this::canGrowCrystal).toList();
        if (positions.isEmpty()) {
            return false;
        }
        BlockPos pos = positions.get(this.f_58857_.f_46441_.m_188503_(positions.size()));
        BlockState state = this.f_58857_.m_8055_(pos);
        EnumMap<Direction, BlockState> map = new EnumMap<Direction, BlockState>(Direction.class);
        for (Direction direction : Direction.values()) {
            BlockPos offset = pos.m_121945_(direction);
            BlockState s = this.f_58857_.m_8055_(offset);
            if (!this.canClusterGrowAtState(s)) continue;
            map.put(direction, s);
        }
        for (int tryCount = 0; tryCount < 100; ++tryCount) {
            state.m_222972_((ServerLevel)this.f_58857_, pos, this.f_58857_.f_46441_);
            for (Map.Entry e : map.entrySet()) {
                BlockPos offset = pos.m_121945_((Direction)e.getKey());
                if (this.f_58857_.m_8055_(offset) == e.getValue()) continue;
                this.addGrowthParticles(offset);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean doPeriod() {
        if (this.f_58857_ instanceof ServerLevel) {
            this.hasStemPollination = this.hasUpgrade(ShrineUpgrades.STEM_POLLINATION);
            if (this.hasUpgrade(ShrineUpgrades.CRYSTAL_GROWTH)) {
                return this.growCrystals();
            }
            if (this.hasUpgrade(ShrineUpgrades.BONELESS_GROWTH)) {
                return this.growBoneless();
            }
            return this.growStandard();
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$stemCanGrow$1(Block crop, BlockState state) {
        return state.m_60713_(crop);
    }
}

