/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.container;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorage;
import sirttas.elementalcraft.block.AbstractECEntityBlock;
import sirttas.elementalcraft.block.ITooltipImageBlock;
import sirttas.elementalcraft.block.container.ElementContainerBlockEntity;
import sirttas.elementalcraft.block.container.IElementContainer;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.gui.GuiHelper;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.tag.ECTags;

public abstract class AbstractElementContainerBlock
extends AbstractECEntityBlock
implements ITooltipImageBlock {
    protected AbstractElementContainerBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60978_(2.0f).m_60918_(SoundType.f_56743_).m_60999_().m_60955_());
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new ElementContainerBlockEntity(pos, state);
    }

    @Deprecated
    public boolean m_7278_(@Nonnull BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6782_(@Nonnull BlockState blockState, @Nonnull Level level, @Nonnull BlockPos pos) {
        return this.getElementStorage(level, pos).map(storage -> storage.getElementAmount() * 15 / storage.getElementCapacity()).orElse(0);
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        this.getElementStorage(level, pos).filter(t -> !t.isEmpty()).ifPresent(t -> ParticleHelper.createSourceParticle(t.getElementType(), level, Vec3.m_82512_((Vec3i)pos).m_82520_(0.0, 0.2, 0.0), rand));
    }

    private Optional<ISingleElementStorage> getElementStorage(Level level, BlockPos pos) {
        return BlockEntityHelper.getBlockEntityAs((BlockGetter)level, pos, IElementContainer.class).map(IElementContainer::getElementStorage);
    }

    @Override
    @Nonnull
    public Optional<TooltipComponent> getTooltipImage(@Nonnull ItemStack stack) {
        CompoundTag elementStorageNbt = this.getElementStorageTag(stack);
        if (elementStorageNbt != null) {
            ElementType elementType = ElementType.byName(elementStorageNbt.m_128461_("element_type"));
            int amount = elementStorageNbt.m_128451_("element_amount");
            int capacity = elementStorageNbt.m_128451_("element_capacity");
            if (amount > 0) {
                return Optional.of(new Tooltip(elementType, amount, capacity));
            }
        }
        return Optional.empty();
    }

    public CompoundTag getElementStorageTag(@Nonnull ItemStack stack) {
        CompoundTag blockNbt;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("BlockEntityTag") && (blockNbt = tag.m_128469_("BlockEntityTag")).m_128441_("element_storage")) {
            return blockNbt.m_128469_("element_storage");
        }
        return null;
    }

    @Override
    @Deprecated
    public void m_6810_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos up;
        if (!state.m_60713_(newState.m_60734_()) && level.m_8055_(up = pos.m_7494_()).m_204336_(ECTags.Blocks.CONTAINER_TOOLS)) {
            level.m_46961_(up, true);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_49811_(@Nonnull CreativeModeTab group, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((ItemLike)this.m_5456_()));
        for (ElementType type : ElementType.ALL_VALID) {
            ItemStack stack = new ItemStack((ItemLike)this.m_5456_());
            CompoundTag tag = stack.m_41698_("BlockEntityTag");
            tag.m_128365_("element_storage", (Tag)new SingleElementStorage(type, this.getDefaultCapacity(), this.getDefaultCapacity()).serializeNBT());
            items.add((Object)stack);
        }
    }

    protected abstract int getDefaultCapacity();

    public record Tooltip(ElementType elementType, int amount, int capacity) implements TooltipComponent
    {
    }

    public record ClientTooltip(ElementType elementType, int amount, int capacity) implements ClientTooltipComponent
    {
        public ClientTooltip(Tooltip tooltip) {
            this(tooltip.elementType, tooltip.amount, tooltip.capacity);
        }

        public int m_142103_() {
            return 18;
        }

        public int m_142069_(@Nonnull Font font) {
            return 16;
        }

        public void m_183452_(@Nonnull Font font, int x, int y, @Nonnull PoseStack poseStack, @Nonnull ItemRenderer itemRenderer, int blitOffset) {
            GuiHelper.renderElementGauge(poseStack, x, y, this.amount, this.capacity, this.elementType, false);
        }
    }
}

