/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.stair;

import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.models.block.BlockModelJson;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.StairsShape;
import org.jetbrains.annotations.NotNull;

public class StairsBlockModelProvider
implements DataProvider {
    private final DataGenerator generator;

    public StairsBlockModelProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(@NotNull CachedOutput cache) throws IOException {
        HashSet<String> uniqueValues = new HashSet<String>();
        for (StairsShape stairsShape : StairsShape.values()) {
            String shapeName = StairsBlockModelProvider.getTypeFromShape(stairsShape);
            if (!uniqueValues.add(shapeName)) continue;
            BlockModelJson modelJson = new BlockModelJson();
            modelJson.setLoader("domum_ornamentum:" + "materially_textured".toString());
            modelJson.setParent(new ResourceLocation("domum_ornamentum", "block/stairs/" + shapeName + "_spec").toString());
            String name = shapeName + ".json";
            Path saveFile = this.generator.m_123916_().resolve("assets/domum_ornamentum/models/block/stairs/").resolve(name);
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)modelJson), (Path)saveFile);
        }
    }

    @NotNull
    public String m_6055_() {
        return "Stairs Block Model Provider";
    }

    private static String getTypeFromShape(StairsShape shape) {
        return switch (shape) {
            case StairsShape.INNER_LEFT, StairsShape.INNER_RIGHT -> "stairs_inner";
            case StairsShape.OUTER_LEFT, StairsShape.OUTER_RIGHT -> "stairs_outer";
            default -> "stairs";
        };
    }
}

