/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block.decorative;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.ldtteam.domumornamentum.block.AbstractBlockDirectional;
import com.ldtteam.domumornamentum.block.ICachedItemGroupBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.components.SimpleRetexturableComponent;
import com.ldtteam.domumornamentum.block.types.ShingleSlabShapeType;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.entity.block.MateriallyTexturedBlockEntity;
import com.ldtteam.domumornamentum.recipe.ModRecipeSerializers;
import com.ldtteam.domumornamentum.tag.ModTags;
import com.ldtteam.domumornamentum.util.BlockUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShingleSlabBlock
extends AbstractBlockDirectional<ShingleSlabBlock>
implements SimpleWaterloggedBlock,
IMateriallyTexturedBlock,
ICachedItemGroupBlock,
EntityBlock {
    public static final List<IMateriallyTexturedBlockComponent> COMPONENTS = ImmutableList.builder().add((Object)new SimpleRetexturableComponent(new ResourceLocation("block/oak_planks"), ModTags.SHINGLES_ROOF, Blocks.f_50705_)).add((Object)new SimpleRetexturableComponent(new ResourceLocation("block/dark_oak_planks"), ModTags.SHINGLES_SUPPORT, Blocks.f_50745_)).build();
    public static final EnumProperty<ShingleSlabShapeType> SHAPE = EnumProperty.m_61587_((String)"shape", ShingleSlabShapeType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final float BLOCK_HARDNESS = 3.0f;
    private static final float RESISTANCE = 1.0f;
    private static final int FOUR_CONNECTIONS = 4;
    private static final int THREE_CONNECTIONS = 3;
    private static final int TWO_CONNECTIONS = 2;
    private static final int ONE_CONNECTION = 1;
    private final List<ItemStack> fillItemGroupCache = Lists.newArrayList();

    public ShingleSlabBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(3.0f, 1.0f).m_60999_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public BlockState m_7417_(BlockState stateIn, @NotNull Direction HORIZONTAL_FACING, @NotNull BlockState HORIZONTAL_FACINGState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos HORIZONTAL_FACINGPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return ShingleSlabBlock.getSlabShape(stateIn, worldIn, currentPos);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        @NotNull Direction facing = context.m_43723_() == null ? Direction.NORTH : Direction.m_122364_((double)context.m_43723_().m_146908_());
        return ShingleSlabBlock.getSlabShape((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_)), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.9, (double)7.9, (double)15.9);
    }

    private static BlockState getSlabShape(@NotNull BlockState state, @NotNull LevelAccessor world, @NotNull BlockPos position) {
        BlockState shapeState;
        boolean north = world.m_8055_(position.m_122012_()).m_60734_() instanceof ShingleSlabBlock;
        boolean south = world.m_8055_(position.m_122019_()).m_60734_() instanceof ShingleSlabBlock;
        boolean east = world.m_8055_(position.m_122029_()).m_60734_() instanceof ShingleSlabBlock;
        boolean west = world.m_8055_(position.m_122024_()).m_60734_() instanceof ShingleSlabBlock;
        boolean[] connectors = new boolean[]{north, south, east, west};
        int amount = 0;
        for (boolean check : connectors) {
            if (!check) continue;
            ++amount;
        }
        if (amount == 1) {
            shapeState = (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)ShingleSlabShapeType.ONE_WAY));
            if (north) {
                return (BlockState)shapeState.m_61124_((Property)f_54117_, (Comparable)Direction.NORTH);
            }
            if (south) {
                return (BlockState)shapeState.m_61124_((Property)f_54117_, (Comparable)Direction.SOUTH);
            }
            if (east) {
                return (BlockState)shapeState.m_61124_((Property)f_54117_, (Comparable)Direction.EAST);
            }
            if (west) {
                return (BlockState)shapeState.m_61124_((Property)f_54117_, (Comparable)Direction.WEST);
            }
        }
        if (amount == 2) {
            if (north && east) {
                shapeState = (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)ShingleSlabShapeType.CURVED));
                return (BlockState)shapeState.m_61124_((Property)f_54117_, (Comparable)Direction.WEST);
            }
            if (north && west) {
                shapeState = (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)ShingleSlabShapeType.CURVED));
                return (BlockState)shapeState.m_61124_((Property)f_54117_, (Comparable)Direction.SOUTH);
            }
            if (south && east) {
                shapeState = (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)ShingleSlabShapeType.CURVED));
                return (BlockState)shapeState.m_61124_((Property)f_54117_, (Comparable)Direction.NORTH);
            }
            if (south && west) {
                shapeState = (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)ShingleSlabShapeType.CURVED));
                return (BlockState)shapeState.m_61124_((Property)f_54117_, (Comparable)Direction.EAST);
            }
            if (north && south) {
                shapeState = (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)ShingleSlabShapeType.TWO_WAY));
                return (BlockState)shapeState.m_61124_((Property)f_54117_, (Comparable)Direction.NORTH);
            }
            if (east && west) {
                shapeState = (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)ShingleSlabShapeType.TWO_WAY));
                return (BlockState)shapeState.m_61124_((Property)f_54117_, (Comparable)Direction.EAST);
            }
        }
        if (amount == 3) {
            shapeState = (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)ShingleSlabShapeType.THREE_WAY));
            if (north && east && west) {
                return (BlockState)shapeState.m_61124_((Property)f_54117_, (Comparable)Direction.NORTH);
            }
            if (south && east && west) {
                return (BlockState)shapeState.m_61124_((Property)f_54117_, (Comparable)Direction.SOUTH);
            }
            if (east && north && south) {
                return (BlockState)shapeState.m_61124_((Property)f_54117_, (Comparable)Direction.EAST);
            }
            if (west && north && south) {
                return (BlockState)shapeState.m_61124_((Property)f_54117_, (Comparable)Direction.WEST);
            }
        }
        if (amount == 4) {
            shapeState = (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)ShingleSlabShapeType.FOUR_WAY));
            return shapeState;
        }
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)ShingleSlabShapeType.TOP));
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return type == PathComputationType.WATER && worldIn.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, SHAPE, WATERLOGGED});
    }

    @NotNull
    public List<IMateriallyTexturedBlockComponent> getComponents() {
        return COMPONENTS;
    }

    public void m_49811_(@NotNull CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
        if (!this.fillItemGroupCache.isEmpty()) {
            items.addAll(this.fillItemGroupCache);
            return;
        }
        try {
            ItemStack result = new ItemStack((ItemLike)this);
            this.fillItemGroupCache.add(result);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        items.addAll(this.fillItemGroupCache);
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        CompoundTag textureData = stack.m_41698_("textureData");
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof MateriallyTexturedBlockEntity) {
            ((MateriallyTexturedBlockEntity)tileEntity).updateTextureDataWith(MaterialTextureData.deserializeFromNBT(textureData));
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new MateriallyTexturedBlockEntity(blockPos, blockState);
    }

    @Override
    public void resetCache() {
        this.fillItemGroupCache.clear();
    }

    @NotNull
    public List<ItemStack> m_7381_(@NotNull BlockState state, @NotNull LootContext.Builder builder) {
        return BlockUtils.getMaterializedItemStack(builder);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return BlockUtils.getMaterializedItemStack((Entity)player, world, pos);
    }

    @Override
    @NotNull
    public Block getBlock() {
        return this;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        MateriallyTexturedBlockEntity mtbe;
        Block block;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof MateriallyTexturedBlockEntity && (block = (mtbe = (MateriallyTexturedBlockEntity)be).getTextureData().getTexturedComponents().get(COMPONENTS.get(1).getId())) != null) {
            return block.getExplosionResistance(state, level, pos, explosion);
        }
        return super.getExplosionResistance(state, level, pos, explosion);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        MateriallyTexturedBlockEntity mtbe;
        Block block;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof MateriallyTexturedBlockEntity && (block = (mtbe = (MateriallyTexturedBlockEntity)be).getTextureData().getTexturedComponents().get(COMPONENTS.get(1).getId())) != null) {
            return block.m_5880_(block.m_49966_(), player, level, pos);
        }
        return super.m_5880_(state, player, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        MateriallyTexturedBlockEntity mtbe;
        Block block;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof MateriallyTexturedBlockEntity && (block = (mtbe = (MateriallyTexturedBlockEntity)be).getTextureData().getTexturedComponents().get(COMPONENTS.get(1).getId())) != null) {
            return block.getSoundType(state, level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    @Override
    @NotNull
    public Collection<FinishedRecipe> getValidCutterRecipes() {
        return Lists.newArrayList((Object[])new FinishedRecipe[]{new FinishedRecipe(){

            public void m_7917_(@NotNull JsonObject json) {
                json.addProperty("count", (Number)(COMPONENTS.size() * 3));
            }

            @NotNull
            public ResourceLocation m_6445_() {
                return Objects.requireNonNull(ShingleSlabBlock.this.getRegistryName(ShingleSlabBlock.this.getBlock()));
            }

            @NotNull
            public RecipeSerializer<?> m_6637_() {
                return (RecipeSerializer)ModRecipeSerializers.ARCHITECTS_CUTTER.get();
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        }});
    }
}

