/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block.vanilla;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.ldtteam.domumornamentum.block.AbstractBlockStairs;
import com.ldtteam.domumornamentum.block.ICachedItemGroupBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.components.SimpleRetexturableComponent;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.entity.block.MateriallyTexturedBlockEntity;
import com.ldtteam.domumornamentum.tag.ModTags;
import com.ldtteam.domumornamentum.util.BlockUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StairBlock
extends AbstractBlockStairs<StairBlock>
implements IMateriallyTexturedBlock,
EntityBlock,
ICachedItemGroupBlock {
    private static IMateriallyTexturedBlockComponent MATERIAL_COMPONENT = new SimpleRetexturableComponent(new ResourceLocation("minecraft:block/oak_planks"), ModTags.STAIRS_MATERIALS, Blocks.f_50705_);
    public static final List<IMateriallyTexturedBlockComponent> COMPONENTS = ImmutableList.builder().add((Object)MATERIAL_COMPONENT).build();
    private final List<ItemStack> fillItemGroupCache = Lists.newArrayList();

    public StairBlock() {
        super(() -> ((Block)Blocks.f_50705_).m_49966_(), BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)Blocks.f_50705_.m_60590_()).m_60955_().m_60913_(2.0f, 3.0f).m_60999_().m_60918_(SoundType.f_56736_));
    }

    @NotNull
    public List<IMateriallyTexturedBlockComponent> getComponents() {
        return COMPONENTS;
    }

    public void m_49811_(@NotNull CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
        if (!this.fillItemGroupCache.isEmpty()) {
            items.addAll(this.fillItemGroupCache);
            return;
        }
        try {
            ItemStack result = new ItemStack((ItemLike)this);
            this.fillItemGroupCache.add(result);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        items.addAll(this.fillItemGroupCache);
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        CompoundTag textureData = stack.m_41698_("textureData");
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof MateriallyTexturedBlockEntity) {
            ((MateriallyTexturedBlockEntity)tileEntity).updateTextureDataWith(MaterialTextureData.deserializeFromNBT(textureData));
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new MateriallyTexturedBlockEntity(blockPos, blockState);
    }

    @Override
    public void resetCache() {
        this.fillItemGroupCache.clear();
    }

    public void m_214162_(@NotNull BlockState p_56914_, @NotNull Level p_56915_, @NotNull BlockPos p_56916_, @NotNull RandomSource p_56917_) {
        BlockState state = this.getBlockState((BlockGetter)p_56915_, p_56916_);
        state.m_60734_().m_214162_(state, p_56915_, p_56916_, p_56917_);
    }

    public void m_6256_(@NotNull BlockState p_56896_, @NotNull Level p_56897_, @NotNull BlockPos p_56898_, @NotNull Player p_56899_) {
        BlockState state = this.getBlockState((BlockGetter)p_56897_, p_56898_);
        state.m_60686_(p_56897_, p_56898_, p_56899_);
    }

    public void m_6786_(@NotNull LevelAccessor p_56882_, @NotNull BlockPos p_56883_, @NotNull BlockState p_56884_) {
        BlockState state = this.getBlockState((BlockGetter)p_56882_, p_56883_);
        state.m_60734_().m_6786_(p_56882_, p_56883_, state);
    }

    public void m_6807_(@NotNull BlockState p_56961_, @NotNull Level p_56962_, @NotNull BlockPos p_56963_, @NotNull BlockState p_56964_, boolean p_56965_) {
        BlockState state = this.getBlockState((BlockGetter)p_56962_, p_56963_);
        state.m_60696_(p_56962_, p_56963_, p_56964_, p_56965_);
    }

    public void m_6810_(@NotNull BlockState p_56908_, @NotNull Level p_56909_, @NotNull BlockPos p_56910_, @NotNull BlockState p_56911_, boolean p_56912_) {
        BlockState state = this.getBlockState((BlockGetter)p_56909_, p_56910_);
        state.m_60753_(p_56909_, p_56910_, p_56911_, p_56912_);
    }

    public void m_141947_(@NotNull Level p_154720_, @NotNull BlockPos p_154721_, @NotNull BlockState p_154722_, @NotNull Entity p_154723_) {
        BlockState state = this.getBlockState((BlockGetter)p_154720_, p_154721_);
        state.m_60734_().m_141947_(p_154720_, p_154721_, state, p_154723_);
    }

    public void m_213898_(@NotNull BlockState p_56951_, @NotNull ServerLevel p_56952_, @NotNull BlockPos p_56953_, @NotNull RandomSource p_56954_) {
        BlockState state = this.getBlockState((BlockGetter)p_56952_, p_56953_);
        state.m_222972_(p_56952_, p_56953_, p_56954_);
    }

    public void m_213897_(@NotNull BlockState p_56886_, @NotNull ServerLevel p_56887_, @NotNull BlockPos p_56888_, @NotNull RandomSource p_56889_) {
        BlockState state = this.getBlockState((BlockGetter)p_56887_, p_56888_);
        state.m_222963_(p_56887_, p_56888_, p_56889_);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState p_56901_, @NotNull Level p_56902_, @NotNull BlockPos p_56903_, @NotNull Player p_56904_, @NotNull InteractionHand p_56905_, @NotNull BlockHitResult p_56906_) {
        BlockState state = this.getBlockState((BlockGetter)p_56902_, p_56903_);
        return state.m_60664_(p_56902_, p_56904_, p_56905_, p_56906_);
    }

    public void m_7592_(@NotNull Level p_56878_, @NotNull BlockPos p_56879_, @NotNull Explosion p_56880_) {
        BlockState state = this.getBlockState((BlockGetter)p_56878_, p_56879_);
        state.m_60734_().m_7592_(p_56878_, p_56879_, p_56880_);
    }

    @NotNull
    public List<ItemStack> m_7381_(@NotNull BlockState state, @NotNull LootContext.Builder builder) {
        return BlockUtils.getMaterializedItemStack(builder);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return BlockUtils.getMaterializedItemStack((Entity)player, world, pos);
    }

    private BlockState getBlockState(BlockGetter blockGetter, BlockPos blockPos) {
        MaterialTextureData data;
        Block block;
        BlockEntity blockEntity = blockGetter.m_7702_(blockPos);
        if (blockEntity instanceof MateriallyTexturedBlockEntity && (block = (data = ((MateriallyTexturedBlockEntity)blockEntity).getTextureData()).getTexturedComponents().get(MATERIAL_COMPONENT.getId())) != null) {
            return block.m_49966_();
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    @NotNull
    public Block getBlock() {
        return this;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof MateriallyTexturedBlockEntity) {
            MateriallyTexturedBlockEntity mtbe = (MateriallyTexturedBlockEntity)be;
            Block block = mtbe.getTextureData().getTexturedComponents().get(COMPONENTS.get(0).getId());
            return block.getExplosionResistance(state, level, pos, explosion);
        }
        return super.getExplosionResistance(state, level, pos, explosion);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof MateriallyTexturedBlockEntity) {
            MateriallyTexturedBlockEntity mtbe = (MateriallyTexturedBlockEntity)be;
            Block block = mtbe.getTextureData().getTexturedComponents().get(COMPONENTS.get(0).getId());
            return super.m_5880_(block.m_49966_(), player, level, pos);
        }
        return super.m_5880_(state, player, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof MateriallyTexturedBlockEntity) {
            MateriallyTexturedBlockEntity mtbe = (MateriallyTexturedBlockEntity)be;
            Block block = mtbe.getTextureData().getTexturedComponents().get(COMPONENTS.get(0).getId());
            return block.getSoundType(state, level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }
}

