/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.block.SmelterTileEntity;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public class SmelterGui
extends GenericGuiContainer<SmelterTileEntity, GenericContainer> {
    public static final int SMELTER_WIDTH = 180;
    public static final int SMELTER_HEIGHT = 152;
    private EnergyBar energyBar;
    private ImageLabel burningImage;
    private Label percentage;
    private static final ResourceLocation iconLocation = new ResourceLocation("deepresonance", "textures/gui/smelter.png");
    private static final ResourceLocation iconBurning = new ResourceLocation("deepresonance", "textures/gui/burning.png");

    public SmelterGui(SmelterTileEntity tile, GenericContainer container, Inventory inventory) {
        super((GenericTileEntity)tile, (AbstractContainerMenu)container, inventory, ManualEntry.EMPTY);
        this.f_97726_ = 180;
        this.f_97727_ = 152;
    }

    public void m_7856_() {
        super.m_7856_();
        long maxEnergyStored = ((SmelterTileEntity)this.tileEntity).getMaxPower();
        this.energyBar = ((EnergyBar)new EnergyBar().vertical().maxValue(maxEnergyStored).hint((LayoutHint)new PositionalLayout.PositionalHint(10, 7, 8, 54))).showText(false);
        this.energyBar.value((long)((SmelterTileEntity)this.tileEntity).getCurrentPower());
        this.burningImage = (ImageLabel)((ImageLabel)new ImageLabel().image(iconBurning, 0, 0)).hint((LayoutHint)new PositionalLayout.PositionalHint(90, 2, 64, 64));
        this.percentage = (Label)new Label().hint((LayoutHint)new PositionalLayout.PositionalHint(54, 44, 32, 14));
        Panel toplevel = (Panel)((Panel)new Panel().background(iconLocation)).layout((Layout)new PositionalLayout()).children(new Widget[]{this.energyBar, this.burningImage, this.percentage});
        toplevel.setBounds(new Rectangle(this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_));
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    protected void m_7286_(@Nonnull PoseStack matrixStack, float partialTicks, int x, int y) {
        int progress = ((SmelterTileEntity)this.tileEntity).getProgress();
        if (0 < progress && progress < 100) {
            int p = progress / 3 % 9 + 1;
            int xx = p % 4 * 64;
            int yy = p / 4 * 64;
            this.burningImage.image(iconBurning, xx, yy);
        } else {
            this.burningImage.image(iconBurning, 0, 0);
        }
        this.percentage.text(progress + "%");
        this.updateEnergyBar(this.energyBar);
        super.m_7286_(matrixStack, partialTicks, x, y);
    }

    public static void register() {
        SmelterGui.register((MenuType)((MenuType)MachinesModule.SMELTER_CONTAINER.get()), SmelterGui::new);
    }
}

