/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.core.block;

import java.util.Random;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalBlock;
import mcjty.deepresonance.modules.core.util.CrystalConfig;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ResonatingCrystalTileEntity
extends GenericTileEntity {
    private double strength = 1.0;
    private double power = 1.0;
    private double efficiency = 1.0;
    private double purity = 1.0;
    private float powerPerTick = -1.0f;
    private int rfPerTick = -1;
    private boolean glowing = false;

    public ResonatingCrystalTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CoreModule.TYPE_RESONATING_CRYSTAL.get(), pos, state);
    }

    public double getStrength() {
        return this.strength;
    }

    public double getPower() {
        return this.power;
    }

    public double getEfficiency() {
        return this.efficiency;
    }

    public double getPurity() {
        return this.purity;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setStrength(double strength) {
        this.strength = strength;
        this.m_6596_();
    }

    public boolean isEmpty() {
        return this.power < (double)1.0E-5f;
    }

    public void setPower(double power) {
        boolean oldempty = this.isEmpty();
        this.power = power;
        this.m_6596_();
        boolean newempty = this.isEmpty();
        if (oldempty != newempty) {
            Block block;
            if (this.f_58857_ != null && (block = this.m_58900_().m_60734_()) instanceof ResonatingCrystalBlock) {
                ResonatingCrystalBlock crystalBlock = (ResonatingCrystalBlock)block;
                this.f_58857_.m_7731_(this.f_58858_, crystalBlock.getEmpty().m_49966_(), 11);
            }
            this.m_6596_();
        }
    }

    public float getPowerPerTick() {
        if (this.powerPerTick < 0.0f) {
            double totalRF = ResonatingCrystalTileEntity.getTotalPower(this.strength, this.purity);
            double numticks = totalRF / (double)ResonatingCrystalTileEntity.getRfPerTick(this.efficiency, this.purity);
            this.powerPerTick = (float)(100.0 / numticks);
        }
        return this.powerPerTick;
    }

    public static double getTotalPower(double strength, double purity) {
        return 1000.0 * (double)((Integer)CrystalConfig.MAX_POWER_STORED.get()).intValue() * strength / 100.0 * (purity + 30.0) / 130.0;
    }

    public int getRfPerTick() {
        if (this.rfPerTick == -1) {
            this.rfPerTick = ResonatingCrystalTileEntity.getRfPerTick(this.efficiency, this.purity);
        }
        return this.rfPerTick;
    }

    public static int getRfPerTick(double efficiency, double purity) {
        return (int)((double)((Integer)CrystalConfig.MAX_POWER_TICK.get()).intValue() * efficiency / 100.1 * (purity + 2.0) / 102.0 + 1.0);
    }

    public void setEfficiency(double efficiency) {
        this.efficiency = efficiency;
        this.m_6596_();
    }

    public void setPurity(double purity) {
        this.purity = purity;
        this.m_6596_();
    }

    public void setGlowing(boolean glowing) {
        if (this.glowing == glowing) {
            return;
        }
        this.glowing = glowing;
        this.markDirtyClient();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        boolean oldempty = this.isEmpty();
        super.onDataPacket(net, packet);
        boolean newempty = this.isEmpty();
        if (oldempty != newempty) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        if (tagCompound.m_128441_("Info")) {
            CompoundTag info = tagCompound.m_128469_("Info");
            this.strength = info.m_128459_("strength");
            this.power = info.m_128459_("power");
            this.efficiency = info.m_128459_("efficiency");
            this.purity = info.m_128459_("purity");
        }
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128347_("strength", this.strength);
        info.m_128347_("power", this.power);
        info.m_128347_("efficiency", this.efficiency);
        info.m_128347_("purity", this.purity);
    }

    public void m_142466_(@Nonnull CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.glowing = tagCompound.m_128471_("glowing");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128379_("glowing", this.glowing);
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        this.glowing = tagCompound.m_128471_("glowing");
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        tagCompound.m_128379_("glowing", this.glowing);
    }

    public static void spawnRandomCrystal(Level world, Random random, BlockPos pos, int special) {
        world.m_7731_(pos, ((ResonatingCrystalBlock)((Object)CoreModule.RESONATING_CRYSTAL_GENERATED.get())).m_49966_(), 3);
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)te;
            if (special >= 5) {
                crystal.setStrength(1.0);
                crystal.setPower(0.05f);
                crystal.setEfficiency(1.0);
                crystal.setPurity(100.0);
            } else if (special >= 3) {
                crystal.setStrength(100.0);
                crystal.setPower(100.0);
                crystal.setEfficiency(100.0);
                crystal.setPurity(special == 4 ? 1.0 : 100.0);
            } else {
                crystal.setStrength(ResonatingCrystalTileEntity.getRandomSpecial(random, special) * 3.0f + 0.01f);
                crystal.setPower(ResonatingCrystalTileEntity.getRandomSpecial(random, special) * 60.0f + 0.2f);
                crystal.setEfficiency(ResonatingCrystalTileEntity.getRandomSpecial(random, special) * 3.0f + 0.1f);
                crystal.setPurity(ResonatingCrystalTileEntity.getRandomSpecial(random, special) * 10.0f + 5.0f);
            }
        }
    }

    public static void spawnRandomCrystal(Level world, Random random, BlockPos pos, float str, float pow, float eff, float pur) {
        world.m_7731_(pos, ((ResonatingCrystalBlock)((Object)CoreModule.RESONATING_CRYSTAL_GENERATED.get())).m_49966_(), 3);
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)te;
            crystal.setStrength(Math.min(100.0f, random.nextFloat() * str * 3.0f + 0.01f));
            crystal.setPower(Math.min(100.0f, random.nextFloat() * pow * 60.0f + 0.2f));
            crystal.setEfficiency(Math.min(100.0f, random.nextFloat() * eff * 3.0f + 0.1f));
            crystal.setPurity(Math.min(100.0f, random.nextFloat() * pur * 10.0f + 5.0f));
        }
    }

    private static float getRandomSpecial(Random random, int special) {
        if (special == 0) {
            return random.nextFloat();
        }
        if (special == 1) {
            return 0.5f;
        }
        return 1.0f;
    }
}

