/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.client.model;

import com.kyanite.deeperdarker.content.entities.Stalker;
import com.kyanite.deeperdarker.content.entities.animations.StalkerAnimation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class StalkerModel
extends HierarchicalModel<Stalker> {
    private final ModelPart root;
    private final ModelPart head;

    public StalkerModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("root").m_171324_("waist").m_171324_("body").m_171324_("head");
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        PartDefinition root = parts.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition waist = root.m_171599_("waist", CubeListBuilder.m_171558_().m_171514_(18, 46).m_171488_(-6.5f, -2.0f, -3.0f, 7.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(44, 46).m_171488_(0.5f, -2.0f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-29.0f, (float)0.5f));
        PartDefinition body = waist.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        body.m_171599_("body_top", CubeListBuilder.m_171558_().m_171514_(24, 9).m_171488_(-7.0f, -4.0f, -3.5f, 14.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        body.m_171599_("body_right", CubeListBuilder.m_171558_().m_171514_(24, 20).m_171488_(-3.0f, -4.5f, -3.5f, 3.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-7.5f, (float)0.0f));
        body.m_171599_("body_left", CubeListBuilder.m_171558_().m_171514_(44, 20).m_171488_(0.0f, -4.5f, -3.5f, 3.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-7.5f, (float)0.0f));
        body.m_171599_("body_bottom", CubeListBuilder.m_171558_().m_171514_(24, 36).m_171488_(-7.0f, 0.0f, -3.5f, 14.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -24.0f, -3.0f, 6.0f, 24.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-16.0f, (float)0.0f));
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-4.98f, -2.5f, -2.0f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.02f, (float)-18.5f, (float)0.0f));
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(42, 1).m_171488_(-0.02f, -2.5f, -1.5f, 5.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.02f, (float)-16.5f, (float)0.0f));
        PartDefinition arms = body.m_171599_("arms", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)0.0f));
        arms.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(-4.0f, 0.0f, -2.0f, 4.0f, 31.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.0f, (float)0.0f, (float)-0.5f));
        arms.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 66).m_171488_(0.0f, -2.0f, -2.5f, 5.0f, 22.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)0.0f, (float)0.0f));
        PartDefinition teeth = body.m_171599_("teeth", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-7.5f, (float)-3.5f));
        teeth.m_171599_("upper_right_tooth", CubeListBuilder.m_171558_().m_171514_(66, 2).m_171488_(-1.3536f, -1.1465f, -5.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.3964f, (float)-5.6035f, (float)0.0f));
        teeth.m_171599_("upper_left_tooth", CubeListBuilder.m_171558_().m_171514_(80, 0).m_171488_(-1.3536f, -0.8535f, -7.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.1036f, (float)-4.8965f, (float)0.0f));
        teeth.m_171599_("lower_right_tooth", CubeListBuilder.m_171558_().m_171514_(66, 9).m_171488_(-1.0f, -1.0f, -7.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.75f, (float)5.25f, (float)0.0f));
        teeth.m_171599_("lower_left_tooth", CubeListBuilder.m_171558_().m_171514_(84, 9).m_171488_(-1.0f, -1.5f, -6.0f, 2.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.75f, (float)5.25f, (float)0.0f));
        PartDefinition back = body.m_171599_("back", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)31.0f, (float)-0.5f));
        back.m_171599_("upper_back", CubeListBuilder.m_171558_().m_171514_(68, 18).m_171488_(-2.5f, -1.0f, 0.0f, 5.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)-44.5f, (float)4.0f));
        back.m_171599_("middle_back", CubeListBuilder.m_171558_().m_171514_(68, 29).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 4.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)-38.0f, (float)4.0f));
        back.m_171599_("lower_back", CubeListBuilder.m_171558_().m_171514_(68, 44).m_171488_(-2.0f, -1.5f, 0.0f, 4.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.5f, (float)-33.5f, (float)4.0f));
        back.m_171599_("vase", CubeListBuilder.m_171558_().m_171514_(72, 58).m_171488_(-4.0f, -16.0f, -3.9167f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(64, 69).m_171488_(-6.0f, -13.0f, -5.9167f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(68, 93).m_171488_(-5.0f, -1.0f, -4.9167f, 10.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-38.5f, (float)15.4167f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition legs = waist.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        legs.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(24, 54).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 29.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.5f, (float)0.0f, (float)0.0f));
        legs.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(44, 55).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 28.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.5f, (float)1.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)128);
    }

    public void setupAnim(Stalker entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animateWalk(limbSwing, limbSwingAmount);
        this.m_233381_(entity.idleState, StalkerAnimation.IDLE, ageInTicks);
        this.m_233381_(entity.attackState, StalkerAnimation.ATTACK, ageInTicks);
        this.m_233381_(entity.ringAttackState, StalkerAnimation.RING_ATTACK, ageInTicks);
        this.m_233381_(entity.emergeState, StalkerAnimation.EMERGE, ageInTicks);
    }

    private void animateWalk(float pLimbSwing, float pLimbSwingAmount) {
        long i = (long)(pLimbSwing * 150.0f);
        float f = Math.min(pLimbSwingAmount * 2.5f, 1.0f);
        KeyframeAnimations.m_232319_((HierarchicalModel)this, (AnimationDefinition)StalkerAnimation.WALK, (long)i, (float)f, (Vector3f)new Vector3f());
    }

    private void applyHeadRotation(float netHeadYaw, float headPitch) {
        netHeadYaw = Mth.m_14036_((float)netHeadYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.m_14036_((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_171324_("root").m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

