/*
 * Decompiled with CFR 0.152.
 */
package com.cupboard.util;

import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;

public class BlockSearch {
    final BiPredicate<BlockGetter, BlockPos> DOUBLE_AIR = (world, pos) -> world.m_8055_(pos).m_60795_() && world.m_8055_(pos.m_7494_()).m_60795_();
    final BiPredicate<BlockGetter, BlockPos> DOUBLE_AIR_GROUND = this.DOUBLE_AIR.and((world, pos) -> world.m_8055_(pos.m_7495_()).m_60767_().m_76333_());

    public static BlockPos findAround(ServerLevel world, BlockPos start, int verticalRange, int horizontalRange, int yStep, BiPredicate<BlockGetter, BlockPos> predicate) {
        if (horizontalRange < 1 && verticalRange < 1) {
            return null;
        }
        int y = 0;
        int y_offset = yStep;
        for (int i = 0; i < verticalRange + 2; ++i) {
            for (int steps = 1; steps <= horizontalRange; ++steps) {
                int z;
                int x;
                BlockPos temp = start.m_7918_(-steps, y, -steps);
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((BlockGetter)world, temp = temp.m_7918_(1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((BlockGetter)world, temp = temp.m_7918_(0, 0, 1))) continue;
                    return temp;
                }
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((BlockGetter)world, temp = temp.m_7918_(-1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((BlockGetter)world, temp = temp.m_7918_(0, 0, -1))) continue;
                    return temp;
                }
            }
            y += y_offset;
        }
        return null;
    }
}

