/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.EdgeData;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackGraphHelper;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TrackTargetingBehaviour<T extends TrackEdgePoint>
extends BlockEntityBehaviour {
    public static final BehaviourType<TrackTargetingBehaviour<?>> TYPE = new BehaviourType();
    private BlockPos targetTrack;
    private BezierTrackPointLocation targetBezier;
    private Direction.AxisDirection targetDirection;
    private UUID id;
    private Vec3 prevDirection;
    private Vec3 rotatedDirection;
    private CompoundTag migrationData;
    private EdgePointType<T> edgePointType;
    private T edgePoint;
    private boolean orthogonal;

    public TrackTargetingBehaviour(SmartBlockEntity be, EdgePointType<T> edgePointType) {
        super(be);
        this.edgePointType = edgePointType;
        this.targetDirection = Direction.AxisDirection.POSITIVE;
        this.targetTrack = BlockPos.f_121853_;
        this.id = UUID.randomUUID();
        this.migrationData = null;
        this.orthogonal = false;
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128362_("Id", this.id);
        nbt.m_128365_("TargetTrack", (Tag)NbtUtils.m_129224_((BlockPos)this.targetTrack));
        nbt.m_128379_("Ortho", this.orthogonal);
        nbt.m_128379_("TargetDirection", this.targetDirection == Direction.AxisDirection.POSITIVE);
        if (this.rotatedDirection != null) {
            nbt.m_128365_("RotatedAxis", (Tag)VecHelper.writeNBT(this.rotatedDirection));
        }
        if (this.prevDirection != null) {
            nbt.m_128365_("PrevAxis", (Tag)VecHelper.writeNBT(this.prevDirection));
        }
        if (this.migrationData != null && !clientPacket) {
            nbt.m_128365_("Migrate", (Tag)this.migrationData);
        }
        if (this.targetBezier != null) {
            CompoundTag bezierNbt = new CompoundTag();
            bezierNbt.m_128405_("Segment", this.targetBezier.segment());
            bezierNbt.m_128365_("Key", (Tag)NbtUtils.m_129224_((BlockPos)this.targetBezier.curveTarget().m_121996_((Vec3i)this.getPos())));
            nbt.m_128365_("Bezier", (Tag)bezierNbt);
        }
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        this.id = nbt.m_128441_("Id") ? nbt.m_128342_("Id") : UUID.randomUUID();
        this.targetTrack = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("TargetTrack"));
        this.targetDirection = nbt.m_128471_("TargetDirection") ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        this.orthogonal = nbt.m_128471_("Ortho");
        if (nbt.m_128441_("PrevAxis")) {
            this.prevDirection = VecHelper.readNBT(nbt.m_128437_("PrevAxis", 6));
        }
        if (nbt.m_128441_("RotatedAxis")) {
            this.rotatedDirection = VecHelper.readNBT(nbt.m_128437_("RotatedAxis", 6));
        }
        if (nbt.m_128441_("Migrate")) {
            this.migrationData = nbt.m_128469_("Migrate");
        }
        if (clientPacket) {
            this.edgePoint = null;
        }
        if (nbt.m_128441_("Bezier")) {
            CompoundTag bezierNbt = nbt.m_128469_("Bezier");
            BlockPos key = NbtUtils.m_129239_((CompoundTag)bezierNbt.m_128469_("Key"));
            this.targetBezier = new BezierTrackPointLocation(bezierNbt.m_128441_("FromStack") ? key : key.m_121955_((Vec3i)this.getPos()), bezierNbt.m_128451_("Segment"));
        }
        super.read(nbt, clientPacket);
    }

    @Nullable
    public T getEdgePoint() {
        return this.edgePoint;
    }

    public void invalidateEdgePoint(CompoundTag migrationData) {
        this.migrationData = migrationData;
        this.edgePoint = null;
        this.blockEntity.sendData();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.edgePoint == null) {
            this.edgePoint = this.createEdgePoint();
        }
    }

    public T createEdgePoint() {
        Level level = this.getWorld();
        boolean isClientSide = level.f_46443_;
        if (this.migrationData == null || isClientSide) {
            for (TrackGraph trackGraph : Create.RAILWAYS.sided((LevelAccessor)level).trackNetworks.values()) {
                T point = trackGraph.getPoint(this.edgePointType, this.id);
                if (point == null) continue;
                return point;
            }
        }
        if (isClientSide) {
            return null;
        }
        if (!this.hasValidTrack()) {
            return null;
        }
        TrackGraphLocation loc = this.determineGraphLocation();
        if (loc == null) {
            return null;
        }
        TrackGraph graph = loc.graph;
        TrackNode node1 = graph.locateNode((TrackNodeLocation)((Object)loc.edge.getFirst()));
        TrackNode node2 = graph.locateNode((TrackNodeLocation)((Object)loc.edge.getSecond()));
        TrackEdge edge = graph.getConnectionsFrom(node1).get(node2);
        if (edge == null) {
            return null;
        }
        T point = this.edgePointType.create();
        boolean front = this.getTargetDirection() == Direction.AxisDirection.POSITIVE;
        this.prevDirection = edge.getDirectionAt(loc.position).m_82490_(front ? -1.0 : 1.0);
        if (this.rotatedDirection != null) {
            double dot = this.prevDirection.m_82526_(this.rotatedDirection);
            if (dot < (double)-0.85f) {
                this.rotatedDirection = null;
                this.targetDirection = this.targetDirection.m_122541_();
                return null;
            }
            this.rotatedDirection = null;
        }
        double length = edge.getLength();
        CompoundTag data = this.migrationData;
        this.migrationData = null;
        this.orthogonal = this.targetBezier == null;
        Vec3 direction = edge.getDirection(true);
        int nonZeroComponents = 0;
        for (Direction.Axis axis : Iterate.axes) {
            nonZeroComponents += direction.m_82507_(axis) != 0.0 ? 1 : 0;
        }
        this.orthogonal &= nonZeroComponents <= 1;
        EdgeData signalData = edge.getEdgeData();
        if (signalData.hasPoints()) {
            for (EdgePointType<?> otherType : EdgePointType.TYPES.values()) {
                Object otherPoint = signalData.get(otherType, loc.position);
                if (otherPoint == null) continue;
                if (otherType != this.edgePointType) {
                    if (((TrackEdgePoint)otherPoint).canCoexistWith(this.edgePointType, front)) continue;
                    return null;
                }
                if (!((TrackEdgePoint)otherPoint).canMerge()) {
                    return null;
                }
                ((TrackEdgePoint)otherPoint).blockEntityAdded(this.blockEntity, front);
                this.id = ((TrackEdgePoint)otherPoint).getId();
                this.blockEntity.notifyUpdate();
                return (T)otherPoint;
            }
        }
        if (data != null) {
            ((TrackEdgePoint)point).read(data, true, DimensionPalette.read(data));
        }
        ((TrackEdgePoint)point).setId(this.id);
        boolean reverseEdge = front || point instanceof SingleBlockEntityEdgePoint;
        ((TrackEdgePoint)point).setLocation((Couple<TrackNodeLocation>)(reverseEdge ? loc.edge : loc.edge.swap()), reverseEdge ? loc.position : length - loc.position);
        ((TrackEdgePoint)point).blockEntityAdded(this.blockEntity, front);
        loc.graph.addPoint(this.edgePointType, point);
        this.blockEntity.sendData();
        return point;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.edgePoint != null && !this.getWorld().f_46443_) {
            ((TrackEdgePoint)this.edgePoint).blockEntityRemoved(this.getPos(), this.getTargetDirection() == Direction.AxisDirection.POSITIVE);
        }
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public boolean isOnCurve() {
        return this.targetBezier != null;
    }

    public boolean isOrthogonal() {
        return this.orthogonal;
    }

    public boolean hasValidTrack() {
        return this.getTrackBlockState().m_60734_() instanceof ITrackBlock;
    }

    public ITrackBlock getTrack() {
        return (ITrackBlock)this.getTrackBlockState().m_60734_();
    }

    public BlockState getTrackBlockState() {
        return this.getWorld().m_8055_(this.getGlobalPosition());
    }

    public BlockPos getGlobalPosition() {
        return this.targetTrack.m_121955_((Vec3i)this.blockEntity.m_58899_());
    }

    public BlockPos getPositionForMapMarker() {
        BlockEntity blockEntity;
        BlockPos target = this.targetTrack.m_121955_((Vec3i)this.blockEntity.m_58899_());
        if (this.targetBezier != null && (blockEntity = this.getWorld().m_7702_(target)) instanceof TrackBlockEntity) {
            TrackBlockEntity tbe = (TrackBlockEntity)blockEntity;
            BezierConnection bc = tbe.getConnections().get(this.targetBezier.curveTarget());
            if (bc == null) {
                return target;
            }
            double length = Mth.m_14107_((double)(bc.getLength() * 2.0));
            int seg = this.targetBezier.segment() + 1;
            double t = (double)seg / length;
            return new BlockPos(bc.getPosition(t));
        }
        return target;
    }

    public Direction.AxisDirection getTargetDirection() {
        return this.targetDirection;
    }

    public BezierTrackPointLocation getTargetBezier() {
        return this.targetBezier;
    }

    public TrackGraphLocation determineGraphLocation() {
        Level level = this.getWorld();
        BlockPos pos = this.getGlobalPosition();
        BlockState state = this.getTrackBlockState();
        ITrackBlock track = this.getTrack();
        List<Vec3> trackAxes = track.getTrackAxes((BlockGetter)level, pos, state);
        Direction.AxisDirection targetDirection = this.getTargetDirection();
        return this.targetBezier != null ? TrackGraphHelper.getBezierGraphLocationAt(level, pos, targetDirection, this.targetBezier) : TrackGraphHelper.getGraphLocationAt(level, pos, targetDirection, trackAxes.get(0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void render(LevelAccessor level, BlockPos pos, Direction.AxisDirection direction, BezierTrackPointLocation bezier, PoseStack ms, MultiBufferSource buffer, int light, int overlay, RenderedTrackOverlayType type, float scale) {
        if (level instanceof SchematicWorld && !(level instanceof PonderWorld)) {
            return;
        }
        BlockState trackState = level.m_8055_(pos);
        Block block = trackState.m_60734_();
        if (!(block instanceof ITrackBlock)) {
            return;
        }
        ms.m_85836_();
        ITrackBlock track = (ITrackBlock)block;
        PartialModel partial = track.prepareTrackOverlay((BlockGetter)level, pos, trackState, bezier, direction, ms, type);
        if (partial != null) {
            ((SuperByteBuffer)CachedBufferer.partial(partial, trackState).translate(0.5, 0.0, 0.5).scale(scale)).translate(-0.5, 0.0, -0.5).light(LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)pos)).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
        }
        ms.m_85849_();
    }

    public void transform(StructureTransform transform) {
        this.id = UUID.randomUUID();
        this.targetTrack = transform.applyWithoutOffset(this.targetTrack);
        if (this.prevDirection != null) {
            this.rotatedDirection = transform.applyWithoutOffsetUncentered(this.prevDirection);
        }
        if (this.targetBezier != null) {
            this.targetBezier = new BezierTrackPointLocation(transform.applyWithoutOffset(this.targetBezier.curveTarget().m_121996_((Vec3i)this.getPos())).m_121955_((Vec3i)this.getPos()), this.targetBezier.segment());
        }
        this.blockEntity.notifyUpdate();
    }

    public static enum RenderedTrackOverlayType {
        STATION,
        SIGNAL,
        DUAL_SIGNAL,
        OBSERVER;

    }
}

