/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.nixieTube;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.redstone.nixieTube.DoubleFaceAttachedBlock;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlock;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.RenderTypes;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.DyeHelper;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class NixieTubeRenderer
extends SafeBlockEntityRenderer<NixieTubeBlockEntity> {
    private static Random r = new Random();

    public NixieTubeRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(NixieTubeBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        ms.m_85836_();
        BlockState blockState = be.m_58900_();
        DoubleFaceAttachedBlock.DoubleAttachFace face = (DoubleFaceAttachedBlock.DoubleAttachFace)((Object)blockState.m_61143_((Property)NixieTubeBlock.FACE));
        float yRot = AngleHelper.horizontalAngle((Direction)blockState.m_61143_((Property)NixieTubeBlock.f_54117_)) - 90.0f + (float)(face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED ? 180 : 0);
        float xRot = face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL ? -90.0f : (face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED ? 90.0f : 0.0f);
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        ((TransformStack)((TransformStack)((TransformStack)msr.centre()).rotateY((double)yRot)).rotateZ((double)xRot)).unCentre();
        if (be.signalState != null) {
            this.renderAsSignal(be, partialTicks, ms, buffer, light, overlay);
            ms.m_85849_();
            return;
        }
        msr.centre();
        float height = face == DoubleFaceAttachedBlock.DoubleAttachFace.CEILING ? 5.0f : 3.0f;
        float scale = 0.05f;
        Couple<String> s = be.getDisplayedStrings();
        DyeColor color = NixieTubeBlock.colorOf(be.m_58900_());
        ms.m_85836_();
        ms.m_85837_(-0.25, 0.0, 0.0);
        ms.m_85841_(scale, -scale, scale);
        NixieTubeRenderer.drawTube(ms, buffer, (String)s.getFirst(), height, color);
        ms.m_85849_();
        ms.m_85836_();
        ms.m_85837_(0.25, 0.0, 0.0);
        ms.m_85841_(scale, -scale, scale);
        NixieTubeRenderer.drawTube(ms, buffer, (String)s.getSecond(), height, color);
        ms.m_85849_();
        ms.m_85849_();
    }

    public static void drawTube(PoseStack ms, MultiBufferSource buffer, String c, float height, DyeColor color) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        float charWidth = fontRenderer.m_92895_(c);
        float shadowOffset = 0.5f;
        float flicker = r.nextFloat();
        Couple<Integer> couple = DyeHelper.DYE_TABLE.get(color);
        int brightColor = (Integer)couple.getFirst();
        int darkColor = (Integer)couple.getSecond();
        int flickeringBrightColor = Color.mixColors(brightColor, darkColor, flicker / 4.0f);
        ms.m_85836_();
        ms.m_85837_((double)((charWidth - shadowOffset) / -2.0f), (double)(-height), 0.0);
        NixieTubeRenderer.drawInWorldString(ms, buffer, c, flickeringBrightColor);
        ms.m_85836_();
        ms.m_85837_((double)shadowOffset, (double)shadowOffset, -0.0625);
        NixieTubeRenderer.drawInWorldString(ms, buffer, c, darkColor);
        ms.m_85849_();
        ms.m_85849_();
        ms.m_85836_();
        ms.m_85841_(-1.0f, 1.0f, 1.0f);
        ms.m_85837_((double)((charWidth - shadowOffset) / -2.0f), (double)(-height), 0.0);
        NixieTubeRenderer.drawInWorldString(ms, buffer, c, darkColor);
        ms.m_85836_();
        ms.m_85837_((double)(-shadowOffset), (double)shadowOffset, -0.0625);
        NixieTubeRenderer.drawInWorldString(ms, buffer, c, Color.mixColors(darkColor, 0, 0.35f));
        ms.m_85849_();
        ms.m_85849_();
    }

    public static void drawInWorldString(PoseStack ms, MultiBufferSource buffer, String c, int color) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        fontRenderer.m_92811_(c, 0.0f, 0.0f, color, false, ms.m_85850_().m_85861_(), buffer, false, 0, 0xF000F0);
        if (buffer instanceof MultiBufferSource.BufferSource) {
            BakedGlyph texturedglyph = fontRenderer.m_92863_(Style.f_131100_).m_95064_();
            ((MultiBufferSource.BufferSource)buffer).m_109912_(texturedglyph.m_181387_(Font.DisplayMode.NORMAL));
        }
    }

    private void renderAsSignal(NixieTubeBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.m_58900_();
        Direction facing = NixieTubeBlock.getFacing(blockState);
        Vec3 observerVec = Minecraft.m_91087_().f_91075_.m_20299_(partialTicks);
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        if (facing == Direction.DOWN) {
            ((TransformStack)((TransformStack)msr.centre()).rotateZ(180.0)).unCentre();
        }
        boolean invertTubes = facing == Direction.DOWN || blockState.m_61143_((Property)NixieTubeBlock.FACE) == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED;
        CachedBufferer.partial(AllPartialModels.SIGNAL_PANEL, blockState).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        ms.m_85836_();
        ms.m_85837_(0.5, 0.46875, 0.5);
        float renderTime = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
        for (boolean first : Iterate.trueAndFalse) {
            Vec3 lampVec = Vec3.m_82512_((Vec3i)be.m_58899_());
            Vec3 diff = lampVec.m_82546_(observerVec);
            if (first && !be.signalState.isRedLight(renderTime) || !first && !be.signalState.isGreenLight(renderTime) && !be.signalState.isYellowLight(renderTime)) continue;
            boolean flip = first == invertTubes;
            boolean yellow = be.signalState.isYellowLight(renderTime);
            ms.m_85836_();
            ms.m_85837_(flip ? 0.25 : -0.25, 0.0, 0.0);
            if (diff.m_82556_() < 9216.0) {
                boolean vert = first ^ facing.m_122434_().m_122479_();
                float longSide = yellow ? 1.0f : 4.0f;
                float longSideGlow = yellow ? 2.0f : 5.125f;
                CachedBufferer.partial(AllPartialModels.SIGNAL_WHITE_CUBE, blockState).light(0xF000F0).disableDiffuse().scale(vert ? longSide : 1.0f, vert ? 1.0f : longSide, 1.0f).renderInto(ms, buffer.m_6299_(RenderType.m_110466_()));
                CachedBufferer.partial(first ? AllPartialModels.SIGNAL_RED_GLOW : (yellow ? AllPartialModels.SIGNAL_YELLOW_GLOW : AllPartialModels.SIGNAL_WHITE_GLOW), blockState).light(0xF000F0).disableDiffuse().scale(vert ? longSideGlow : 2.0f, vert ? 2.0f : longSideGlow, 2.0f).renderInto(ms, buffer.m_6299_(RenderTypes.getAdditive()));
            }
            ((SuperByteBuffer)CachedBufferer.partial(first ? AllPartialModels.SIGNAL_RED : (yellow ? AllPartialModels.SIGNAL_YELLOW : AllPartialModels.SIGNAL_WHITE), blockState).light(0xF000F0).disableDiffuse().scale(1.0625f)).renderInto(ms, buffer.m_6299_(RenderTypes.getAdditive()));
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    public int m_142163_() {
        return 128;
    }
}

